/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.LongTimeWithTimeZoneType;
import io.trino.spi.type.ShortTimeWithTimeZoneType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TimeWithTimeZoneType
extends AbstractType
implements FixedWidthType {
    public static final int MAX_PRECISION = 12;
    public static final int MAX_SHORT_PRECISION = 9;
    public static final int DEFAULT_PRECISION = 3;
    @Deprecated
    public static final TimeWithTimeZoneType TIME_WITH_TIME_ZONE = new ShortTimeWithTimeZoneType(3);
    private final int precision;

    public static TimeWithTimeZoneType createTimeWithTimeZoneType(int precision) {
        if (precision == 3) {
            return TIME_WITH_TIME_ZONE;
        }
        if (precision < 0 || precision > 12) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIME WITH TIME ZONE precision must be in range [0, %s]: %s", 12, precision));
        }
        if (precision <= 9) {
            return new ShortTimeWithTimeZoneType(precision);
        }
        return new LongTimeWithTimeZoneType(precision);
    }

    protected TimeWithTimeZoneType(int precision, Class<?> javaType) {
        super(new TypeSignature("time with time zone", TypeSignatureParameter.numericParameter(precision)), javaType);
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public final boolean isShort() {
        return this.precision <= 9;
    }

    @Override
    public final boolean isComparable() {
        return true;
    }

    @Override
    public final boolean isOrderable() {
        return true;
    }
}

