/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.BlockTestUtils;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseBlockEncodingTest<T> {
    private static final int[] RANDOM_BLOCK_SIZES = new int[]{2, 4, 8, 9, 16, 17, 32, 33, 64, 65, 1000, 1000000};
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();

    protected abstract Type getType();

    protected abstract void write(BlockBuilder var1, T var2);

    protected abstract T randomValue(Random var1);

    @Test
    public void testEmpty() {
        this.roundTrip(new Object[0]);
    }

    @Test
    public void testSingleNull() {
        this.roundTrip(new Object[]{null});
    }

    @Test
    public void testSingleValue() {
        this.roundTrip(this.randomValue(BaseBlockEncodingTest.getRandom()));
    }

    @Test
    public void testNullAtTheBeginningAndEnd() {
        Random random = BaseBlockEncodingTest.getRandom();
        this.roundTrip(null, null, this.randomValue(random), null, this.randomValue(random), null, null);
    }

    @Test
    public void testBlocksOf8() {
        Random random = BaseBlockEncodingTest.getRandom();
        Object[] values = Stream.of(BlockFill.MIXED, BlockFill.ONLY_NULLS, BlockFill.MIXED, BlockFill.ONLY_VALUES, BlockFill.MIXED, BlockFill.ONLY_NULLS, BlockFill.ONLY_VALUES, BlockFill.MIXED).map(fill -> this.getObjects(8, (BlockFill)((Object)fill), random)).flatMap(Arrays::stream).toArray();
        this.roundTrip(values);
    }

    @Test(dataProvider="testRandomDataDataProvider")
    public void testRandomData(int size, BlockFill fill) {
        this.roundTrip(this.getObjects(size, fill, BaseBlockEncodingTest.getRandom()));
    }

    private Object[] getObjects(int size, BlockFill fill, Random random) {
        Object[] values = new Object[size];
        block5: for (int i = 0; i < size; ++i) {
            switch (fill) {
                case ONLY_NULLS: {
                    values[i] = null;
                    continue block5;
                }
                case ONLY_VALUES: {
                    values[i] = this.randomValue(random);
                    continue block5;
                }
                case MIXED: {
                    values[i] = random.nextBoolean() ? null : this.randomValue(random);
                }
            }
        }
        return values;
    }

    @DataProvider
    public static Object[][] testRandomDataDataProvider() {
        return (Object[][])Arrays.stream(BlockFill.values()).flatMap(fill -> IntStream.of(RANDOM_BLOCK_SIZES).mapToObj(size -> new Object[]{size, fill})).toArray(x$0 -> new Object[x$0][]);
    }

    protected final void roundTrip(Object ... values) {
        BlockBuilder expectedBlockBuilder = this.createBlockBuilder(values.length);
        for (Object value : values) {
            if (value == null) {
                expectedBlockBuilder.appendNull();
                continue;
            }
            this.write(expectedBlockBuilder, value);
        }
        Block expectedBlock = expectedBlockBuilder.build();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, expectedBlock);
        Block actualBlock = this.blockEncodingSerde.readBlock((SliceInput)sliceOutput.slice().getInput());
        BlockTestUtils.assertBlockEquals(this.getType(), actualBlock, expectedBlock);
    }

    private BlockBuilder createBlockBuilder(int length) {
        return this.getType().createBlockBuilder(null, length);
    }

    private static Random getRandom() {
        return new Random(32167L);
    }

    private static enum BlockFill {
        ONLY_NULLS,
        ONLY_VALUES,
        MIXED;

    }
}

