/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.BlockTestUtils;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryBlockEncoding {
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
    private final Block dictionary = TestDictionaryBlockEncoding.buildTestDictionary();

    @Test
    public void testRoundTrip() {
        int positionCount = 40;
        int[] ids = new int[positionCount];
        for (int i = 0; i < 40; ++i) {
            ids[i] = i % 4;
        }
        DictionaryBlock dictionaryBlock = (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)this.dictionary, (int[])ids);
        Block actualBlock = this.roundTripBlock((Block)dictionaryBlock);
        Assert.assertTrue((boolean)(actualBlock instanceof DictionaryBlock));
        DictionaryBlock actualDictionaryBlock = (DictionaryBlock)actualBlock;
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualDictionaryBlock.getDictionary(), this.dictionary);
        for (int position = 0; position < actualDictionaryBlock.getPositionCount(); ++position) {
            Assert.assertEquals((int)actualDictionaryBlock.getId(position), (int)ids[position]);
        }
        Assert.assertEquals((Object)actualDictionaryBlock.getDictionarySourceId(), (Object)dictionaryBlock.getDictionarySourceId());
    }

    @Test
    public void testNonSequentialDictionaryUnnest() {
        int[] ids = new int[]{3, 2, 1, 0};
        DictionaryBlock dictionaryBlock = (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)this.dictionary, (int[])ids);
        Block actualBlock = this.roundTripBlock((Block)dictionaryBlock);
        Assert.assertTrue((boolean)(actualBlock instanceof DictionaryBlock));
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, this.dictionary.getPositions(ids, 0, 4));
    }

    @Test
    public void testNonSequentialDictionaryUnnestWithGaps() {
        int[] ids = new int[]{3, 2, 0};
        DictionaryBlock dictionaryBlock = (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)this.dictionary, (int[])ids);
        Block actualBlock = this.roundTripBlock((Block)dictionaryBlock);
        Assert.assertTrue((boolean)(actualBlock instanceof VariableWidthBlock));
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, this.dictionary.getPositions(ids, 0, 3));
    }

    @Test
    public void testSequentialDictionaryUnnest() {
        int[] ids = new int[]{0, 1, 2, 3};
        DictionaryBlock dictionaryBlock = (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)this.dictionary, (int[])ids);
        Block actualBlock = this.roundTripBlock((Block)dictionaryBlock);
        Assert.assertTrue((boolean)(actualBlock instanceof VariableWidthBlock));
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, this.dictionary.getPositions(ids, 0, 4));
    }

    private Block roundTripBlock(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, block);
        return this.blockEncodingSerde.readBlock((SliceInput)sliceOutput.slice().getInput());
    }

    private static Block buildTestDictionary() {
        BlockBuilder dictionaryBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 4);
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "alice");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "bob");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "charlie");
        VarcharType.VARCHAR.writeString(dictionaryBuilder, "dave");
        return dictionaryBuilder.build();
    }
}

