/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.collect.ImmutableList;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRowBlockBuilder {
    @Test
    public void testBuilderProducesNullRleForNullRows() {
        TestRowBlockBuilder.assertIsAllNulls(TestRowBlockBuilder.blockBuilder().build(), 0);
        TestRowBlockBuilder.assertIsAllNulls(TestRowBlockBuilder.blockBuilder().appendNull().build(), 1);
        TestRowBlockBuilder.assertIsAllNulls(TestRowBlockBuilder.blockBuilder().appendNull().appendNull().build(), 2);
        BlockBuilder blockBuilder = TestRowBlockBuilder.blockBuilder().appendNull().appendNull();
        TestRowBlockBuilder.assertIsAllNulls(blockBuilder.copyPositions(new int[]{0}, 0, 1), 1);
        TestRowBlockBuilder.assertIsAllNulls(blockBuilder.getRegion(0, 1), 1);
        TestRowBlockBuilder.assertIsAllNulls(blockBuilder.copyRegion(0, 1), 1);
    }

    private static BlockBuilder blockBuilder() {
        return new RowBlockBuilder((List)ImmutableList.of((Object)BigintType.BIGINT), null, 10);
    }

    private static void assertIsAllNulls(Block block, int expectedPositionCount) {
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedPositionCount);
        if (expectedPositionCount <= 1) {
            Assert.assertEquals(block.getClass(), RowBlock.class);
        } else {
            Assert.assertEquals(block.getClass(), RunLengthEncodedBlock.class);
            Assert.assertEquals(((RunLengthEncodedBlock)block).getValue().getClass(), RowBlock.class);
        }
        if (expectedPositionCount > 0) {
            Assert.assertTrue((boolean)block.isNull(0));
        }
    }
}

