/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.VarcharType;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableWidthBlockBuilder {
    private static final int BLOCK_BUILDER_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(VariableWidthBlockBuilder.class).instanceSize());
    private static final int SLICE_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(DynamicSliceOutput.class).instanceSize() + ClassLayout.parseClass(Slice.class).instanceSize());
    private static final int VARCHAR_VALUE_SIZE = 7;
    private static final int VARCHAR_ENTRY_SIZE = 11;
    private static final int EXPECTED_ENTRY_COUNT = 3;

    @Test
    public void testFixedBlockIsFull() {
        this.testIsFull(new PageBuilderStatus(33));
    }

    @Test
    public void testNewBlockBuilderLike() {
        int entries = 12345;
        double resetSkew = 1.25;
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, entries, entries);
        for (int i = 0; i < entries; ++i) {
            blockBuilder.writeByte(i);
            blockBuilder.closeEntry();
        }
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        blockBuilder.writeByte(1);
        long actualArrayBytes = SizeOf.sizeOf((int[])new int[(int)Math.ceil(resetSkew * (double)(entries + 1))]) + SizeOf.sizeOf((boolean[])new boolean[(int)Math.ceil(resetSkew * (double)entries)]);
        long actualSliceBytes = (long)SLICE_INSTANCE_SIZE + SizeOf.sizeOf((byte[])new byte[(int)Math.ceil(resetSkew * (double)entries)]);
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)((long)BLOCK_BUILDER_INSTANCE_SIZE + actualSliceBytes + actualArrayBytes));
    }

    private void testIsFull(PageBuilderStatus pageBuilderStatus) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(pageBuilderStatus.createBlockBuilderStatus(), 32, 1024);
        Assert.assertTrue((boolean)pageBuilderStatus.isEmpty());
        while (!pageBuilderStatus.isFull()) {
            VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, Slices.allocate((int)7));
        }
        Assert.assertEquals((int)blockBuilder.getPositionCount(), (int)3);
        Assert.assertEquals((boolean)pageBuilderStatus.isFull(), (boolean)true);
    }

    @Test
    public void testBuilderProducesNullRleForNullRows() {
        TestVariableWidthBlockBuilder.assertIsAllNulls(TestVariableWidthBlockBuilder.blockBuilder().build(), 0);
        TestVariableWidthBlockBuilder.assertIsAllNulls(TestVariableWidthBlockBuilder.blockBuilder().appendNull().build(), 1);
        TestVariableWidthBlockBuilder.assertIsAllNulls(TestVariableWidthBlockBuilder.blockBuilder().appendNull().appendNull().build(), 2);
        BlockBuilder blockBuilder = TestVariableWidthBlockBuilder.blockBuilder().appendNull().appendNull();
        TestVariableWidthBlockBuilder.assertIsAllNulls(blockBuilder.copyPositions(new int[]{0}, 0, 1), 1);
        TestVariableWidthBlockBuilder.assertIsAllNulls(blockBuilder.getRegion(0, 1), 1);
        TestVariableWidthBlockBuilder.assertIsAllNulls(blockBuilder.copyRegion(0, 1), 1);
    }

    private static BlockBuilder blockBuilder() {
        return new VariableWidthBlockBuilder(null, 10, 0);
    }

    private static void assertIsAllNulls(Block block, int expectedPositionCount) {
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedPositionCount);
        if (expectedPositionCount <= 1) {
            Assert.assertEquals(block.getClass(), VariableWidthBlock.class);
        } else {
            Assert.assertEquals(block.getClass(), RunLengthEncodedBlock.class);
            Assert.assertEquals(((RunLengthEncodedBlock)block).getValue().getClass(), VariableWidthBlock.class);
        }
        if (expectedPositionCount > 0) {
            Assert.assertTrue((boolean)block.isNull(0));
        }
    }
}

