/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.BaseBlockEncodingTest;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Random;
import org.testng.annotations.Test;

public class TestVariableWidthBlockEncoding
extends BaseBlockEncodingTest<String> {
    @Override
    protected Type getType() {
        return VarcharType.VARCHAR;
    }

    @Override
    protected void write(BlockBuilder blockBuilder, String value) {
        VarcharType.VARCHAR.writeString(blockBuilder, value);
    }

    @Override
    protected String randomValue(Random random) {
        char[] value = new char[random.nextInt(16)];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (char)random.nextInt(127);
        }
        return new String(value);
    }

    @Test
    public void testUnicode() {
        this.roundTrip("\u0000", "N\u00ed h\u00e9 l\u00e1 na gaoithe l\u00e1 na scolb", "\u0644\u0648\u0644\u0627 \u0627\u062e\u062a\u0644\u0627\u0641 \u0627\u0644\u0646\u0638\u0631\u060c \u0644\u0628\u0627\u0631\u062a \u0627\u0644\u0633\u0644\u0639", "\u25b3\u25b3\u25bf\u25bf\u25c1\u25b7\u25c1\u25b7BA", "Something in ASCII, latin \u00ff, some \u0130 and I, geometry \u25a6 and finally an emoji \ud83d\ude0d");
    }
}

