/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.block.Block;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.TestingBlockJsonSerde;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.EquatableValueSet;
import io.trino.spi.predicate.ToStringSession;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.TestingIdType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEquatableValueSet {
    @Test
    public void testEmptySet() {
        EquatableValueSet equatables = EquatableValueSet.none((Type)TestingIdType.ID);
        Assert.assertEquals((Object)equatables.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertTrue((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.inclusive());
        Assert.assertEquals((int)equatables.getValues().size(), (int)0);
        Assert.assertEquals((Object)equatables.complement(), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertFalse((boolean)equatables.containsValue((Object)0L));
        Assert.assertFalse((boolean)equatables.containsValue((Object)1L));
        Assert.assertEquals((String)equatables.toString(), (String)"EquatableValueSet[type=id, values=0, {}]");
    }

    @Test
    public void testEntireSet() {
        EquatableValueSet equatables = EquatableValueSet.all((Type)TestingIdType.ID);
        Assert.assertEquals((Object)equatables.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertTrue((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertFalse((boolean)equatables.inclusive());
        Assert.assertEquals((int)equatables.getValues().size(), (int)0);
        Assert.assertEquals((Object)equatables.complement(), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertTrue((boolean)equatables.containsValue((Object)0L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)1L));
    }

    @Test
    public void testSingleValue() {
        EquatableValueSet equatables = EquatableValueSet.of((Type)TestingIdType.ID, (Object)10L, (Object[])new Object[0]);
        EquatableValueSet complement = (EquatableValueSet)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)equatables);
        Assert.assertEquals((Object)equatables.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertTrue((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.inclusive());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)equatables.getValues(), (Iterable)ImmutableList.of((Object)10L)));
        Assert.assertEquals((Object)equatables.complement(), (Object)complement);
        Assert.assertFalse((boolean)equatables.containsValue((Object)0L));
        Assert.assertFalse((boolean)equatables.containsValue((Object)1L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)10L));
        Assert.assertEquals((Object)complement.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)complement.isNone());
        Assert.assertFalse((boolean)complement.isAll());
        Assert.assertFalse((boolean)complement.isSingleValue());
        Assert.assertFalse((boolean)complement.inclusive());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)complement.getValues(), (Iterable)ImmutableList.of((Object)10L)));
        Assert.assertEquals((Object)complement.complement(), (Object)equatables);
        Assert.assertTrue((boolean)complement.containsValue((Object)0L));
        Assert.assertTrue((boolean)complement.containsValue((Object)1L));
        Assert.assertFalse((boolean)complement.containsValue((Object)10L));
    }

    @Test
    public void testMultipleValues() {
        EquatableValueSet equatables = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L, 3L, 1L});
        EquatableValueSet complement = (EquatableValueSet)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)equatables);
        Assert.assertEquals((Object)equatables.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)equatables.isNone());
        Assert.assertFalse((boolean)equatables.isAll());
        Assert.assertFalse((boolean)equatables.isSingleValue());
        Assert.assertTrue((boolean)equatables.inclusive());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)equatables.getValues(), (Iterable)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)));
        Assert.assertEquals((Object)equatables.complement(), (Object)complement);
        Assert.assertFalse((boolean)equatables.containsValue((Object)0L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)1L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)2L));
        Assert.assertTrue((boolean)equatables.containsValue((Object)3L));
        Assert.assertFalse((boolean)equatables.containsValue((Object)4L));
        Assert.assertEquals((String)equatables.toString(), (String)"EquatableValueSet[type=id, values=3, {1, 2, 3}]");
        Assert.assertEquals((String)equatables.toString((ConnectorSession)ToStringSession.INSTANCE, 2), (String)"EquatableValueSet[type=id, values=3, {1, 2, ...}]");
        Assert.assertEquals((Object)complement.getType(), (Object)((Object)TestingIdType.ID));
        Assert.assertFalse((boolean)complement.isNone());
        Assert.assertFalse((boolean)complement.isAll());
        Assert.assertFalse((boolean)complement.isSingleValue());
        Assert.assertFalse((boolean)complement.inclusive());
        Assert.assertTrue((boolean)Iterables.elementsEqual((Iterable)complement.getValues(), (Iterable)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)));
        Assert.assertEquals((Object)complement.complement(), (Object)equatables);
        Assert.assertTrue((boolean)complement.containsValue((Object)0L));
        Assert.assertFalse((boolean)complement.containsValue((Object)1L));
        Assert.assertFalse((boolean)complement.containsValue((Object)2L));
        Assert.assertFalse((boolean)complement.containsValue((Object)3L));
        Assert.assertTrue((boolean)complement.containsValue((Object)4L));
        Assert.assertEquals((String)complement.toString(), (String)"EquatableValueSet[type=id, values=3, EXCLUDES{1, 2, 3}]");
        Assert.assertEquals((String)complement.toString((ConnectorSession)ToStringSession.INSTANCE, 2), (String)"EquatableValueSet[type=id, values=3, EXCLUDES{1, 2, ...}]");
    }

    @Test
    public void testGetSingleValue() {
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).getSingleValue(), (Object)0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> EquatableValueSet.all((Type)TestingIdType.ID).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("EquatableValueSet does not have just a single value");
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement()));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().overlaps((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement()));
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertTrue((boolean)EquatableValueSet.all((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.none((Type)TestingIdType.ID).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])));
        Assert.assertTrue((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0])));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})));
        Assert.assertFalse((boolean)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().contains((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)-1L, (Object[])new Object[0]).complement()));
    }

    @Test
    public void testIntersect() {
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)2L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().intersect((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L, 2L}).complement());
    }

    @Test
    public void testUnion() {
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L, 2L}));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement().union((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{2L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
    }

    @Test
    public void testSubtract() {
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.all((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assert.assertEquals((Object)EquatableValueSet.all((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.none((Type)TestingIdType.ID).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.all((Type)TestingIdType.ID)), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.none((Type)TestingIdType.ID)), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.none((Type)TestingIdType.ID));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0])), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L})), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement());
        Assert.assertEquals((Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[0]).complement().subtract((ValueSet)EquatableValueSet.of((Type)TestingIdType.ID, (Object)0L, (Object[])new Object[]{1L}).complement()), (Object)EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]));
    }

    @Test
    public void testUnmodifiableCollection() {
        Collection values = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getValues();
        Assertions.assertThatThrownBy(values::clear).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testUnmodifiableValueEntries() {
        Set entries = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getEntries();
        Assertions.assertThatThrownBy(entries::clear).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testUnmodifiableIterator() {
        Iterator iterator = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getValues().iterator();
        iterator.next();
        Assertions.assertThatThrownBy(iterator::remove).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testUnmodifiableValueEntryIterator() {
        Iterator iterator = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]).getEntries().iterator();
        iterator.next();
        Assertions.assertThatThrownBy(iterator::remove).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer(blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer(blockEncodingSerde)));
        EquatableValueSet set = EquatableValueSet.all((Type)TestingIdType.ID);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.none((Type)TestingIdType.ID);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[0]);
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L});
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
        set = EquatableValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).complement();
        Assert.assertEquals((Object)set, (Object)mapper.readValue(mapper.writeValueAsString((Object)set), EquatableValueSet.class));
    }

    @Test
    public void testExpandRanges() {
        Assertions.assertThat((Optional)ValueSet.all((Type)TestingIdType.ID).tryExpandRanges(10)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.none((Type)TestingIdType.ID).tryExpandRanges(10)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.none((Type)TestingIdType.ID).tryExpandRanges(1)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.none((Type)TestingIdType.ID).tryExpandRanges(0)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).tryExpandRanges(3)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L))));
        Assertions.assertThat((Optional)ValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).tryExpandRanges(2)).isEqualTo(Optional.of(List.of(Long.valueOf(1L), Long.valueOf(2L))));
        Assertions.assertThat((Optional)ValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).tryExpandRanges(1)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.of((Type)TestingIdType.ID, (Object)1L, (Object[])new Object[]{2L}).tryExpandRanges(0)).isEqualTo(Optional.empty());
    }
}

