/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import io.airlift.slice.Slices;
import io.trino.spi.predicate.Range;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRange {
    @Test
    public void testInvertedBounds() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)0L, (boolean)true)).isInstanceOf(IllegalArgumentException.class)).hasMessage("low must be less than or equal to high");
    }

    @Test
    public void testSingleValueExclusive() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)10L, (boolean)true)).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid bounds for single value range");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)10L, (boolean)false)).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid bounds for single value range");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)10L, (boolean)false)).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid bounds for single value range");
    }

    @Test
    public void testSingleValue() {
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)1L, (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)DoubleType.DOUBLE, (Object)1.1, (boolean)true, (Object)1.1, (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"), (boolean)true, (Object)Slices.utf8Slice((String)"a"), (boolean)true).isSingleValue());
        Assert.assertTrue((boolean)Range.range((Type)BooleanType.BOOLEAN, (Object)true, (boolean)true, (Object)true, (boolean)true).isSingleValue());
        Assert.assertFalse((boolean)Range.range((Type)BooleanType.BOOLEAN, (Object)false, (boolean)true, (Object)true, (boolean)true).isSingleValue());
    }

    @Test
    public void testAllRange() {
        Range range = Range.all((Type)BigintType.BIGINT);
        Assert.assertTrue((boolean)range.isLowUnbounded());
        Assert.assertFalse((boolean)range.isLowInclusive());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getLowBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is low-unbounded");
        Assert.assertTrue((boolean)range.isHighUnbounded());
        Assert.assertFalse((boolean)range.isHighInclusive());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getHighBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is high-unbounded");
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertTrue((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testGreaterThanRange() {
        Range range = Range.greaterThan((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertFalse((boolean)range.isLowUnbounded());
        Assert.assertFalse((boolean)range.isLowInclusive());
        Assert.assertEquals((Object)range.getLowBoundedValue(), (Object)1L);
        Assert.assertTrue((boolean)range.isHighUnbounded());
        Assert.assertFalse((boolean)range.isHighInclusive());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getHighBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is high-unbounded");
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testGreaterThanOrEqualRange() {
        Range range = Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertFalse((boolean)range.isLowUnbounded());
        Assert.assertTrue((boolean)range.isLowInclusive());
        Assert.assertEquals((Object)range.getLowBoundedValue(), (Object)1L);
        Assert.assertTrue((boolean)range.isHighUnbounded());
        Assert.assertFalse((boolean)range.isHighInclusive());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getHighBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is high-unbounded");
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testLessThanRange() {
        Range range = Range.lessThan((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertTrue((boolean)range.isLowUnbounded());
        Assert.assertFalse((boolean)range.isLowInclusive());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getLowBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is low-unbounded");
        Assert.assertFalse((boolean)range.isHighUnbounded());
        Assert.assertFalse((boolean)range.isHighInclusive());
        Assert.assertEquals((Object)range.getHighBoundedValue(), (Object)1L);
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testLessThanOrEqualRange() {
        Range range = Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertTrue((boolean)range.isLowUnbounded());
        Assert.assertFalse((boolean)range.isLowInclusive());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getLowBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is low-unbounded");
        Assert.assertFalse((boolean)range.isHighUnbounded());
        Assert.assertTrue((boolean)range.isHighInclusive());
        Assert.assertEquals((Object)range.getHighBoundedValue(), (Object)1L);
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testEqualRange() {
        Range range = Range.equal((Type)BigintType.BIGINT, (Object)1L);
        Assert.assertFalse((boolean)range.isLowUnbounded());
        Assert.assertTrue((boolean)range.isLowInclusive());
        Assert.assertEquals((Object)range.getLowBoundedValue(), (Object)1L);
        Assert.assertFalse((boolean)range.isHighUnbounded());
        Assert.assertTrue((boolean)range.isHighInclusive());
        Assert.assertEquals((Object)range.getHighBoundedValue(), (Object)1L);
        Assert.assertTrue((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testRange() {
        Range range = Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)true);
        Assert.assertFalse((boolean)range.isLowUnbounded());
        Assert.assertFalse((boolean)range.isLowInclusive());
        Assert.assertEquals((Object)range.getLowBoundedValue(), (Object)0L);
        Assert.assertFalse((boolean)range.isHighUnbounded());
        Assert.assertTrue((boolean)range.isHighInclusive());
        Assert.assertEquals((Object)range.getHighBoundedValue(), (Object)2L);
        Assert.assertFalse((boolean)range.isSingleValue());
        Assert.assertFalse((boolean)range.isAll());
        Assert.assertEquals((Object)range.getType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testGetSingleValue() {
        Assert.assertEquals((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L).getSingleValue(), (Object)0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.lessThan((Type)BigintType.BIGINT, (Object)0L).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("Range does not have just a single value");
    }

    @Test
    public void testContains() {
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.equal((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.equal((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertFalse((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.all((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertFalse((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L).contains(Range.lessThan((Type)BigintType.BIGINT, (Object)0L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true)));
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false)));
    }

    @Test
    public void testSpan() {
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L)), (Object)Range.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.equal((Type)BigintType.BIGINT, (Object)2L)), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false));
        Assert.assertEquals((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false)), (Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)10L, (boolean)false));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.equal((Type)BigintType.BIGINT, (Object)0L)), (Object)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L));
        Assert.assertEquals((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L)), (Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Range.lessThan((Type)BigintType.BIGINT, (Object)1L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L)), (Object)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L));
        Assert.assertEquals((Object)Range.all((Type)BigintType.BIGINT).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L)), (Object)Range.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testOverlaps() {
        Assert.assertTrue((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).overlaps(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertFalse((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).overlaps(Range.lessThan((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.equal((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false)));
        Assert.assertFalse((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
        Assert.assertTrue((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true).overlaps(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false)));
        Assert.assertTrue((boolean)Range.all((Type)BigintType.BIGINT).overlaps(Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE)));
    }

    @Test
    public void testIntersect() {
        Assertions.assertThat((Optional)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).intersect(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L))).contains((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)true));
        Assertions.assertThat((Optional)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.equal((Type)BigintType.BIGINT, (Object)2L))).contains((Object)Range.equal((Type)BigintType.BIGINT, (Object)2L));
        Assertions.assertThat((Optional)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false))).contains((Object)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)3L, (boolean)false));
        Assertions.assertThat((Optional)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true).intersect(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false))).contains((Object)Range.equal((Type)BigintType.BIGINT, (Object)3L));
        Assertions.assertThat((Optional)Range.all((Type)BigintType.BIGINT).intersect(Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE))).contains((Object)Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE));
    }

    @Test
    public void testExceptionalIntersect() {
        Range greaterThan2 = Range.greaterThan((Type)BigintType.BIGINT, (Object)2L);
        Range lessThan2 = Range.lessThan((Type)BigintType.BIGINT, (Object)2L);
        Assertions.assertThat((Optional)greaterThan2.intersect(lessThan2)).isEmpty();
        Range range1To3Exclusive = Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false);
        Range range3To10 = Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false);
        Assertions.assertThat((Optional)range1To3Exclusive.intersect(range3To10)).isEmpty();
    }
}

