/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.DecimalParseResult;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import java.math.BigDecimal;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDecimals {
    @Test
    public void testParse() {
        this.assertParseResult("0", 0L, 1, 0);
        this.assertParseResult("0.", 0L, 1, 0);
        this.assertParseResult(".0", 0L, 1, 1);
        this.assertParseResult("+0", 0L, 1, 0);
        this.assertParseResult("-0", 0L, 1, 0);
        this.assertParseResult("000", 0L, 1, 0);
        this.assertParseResult("+000", 0L, 1, 0);
        this.assertParseResult("-000", 0L, 1, 0);
        this.assertParseResult("0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("+0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("-0000000000000000000000000000", 0L, 1, 0);
        this.assertParseResult("1.1", 11L, 2, 1);
        this.assertParseResult("1.", 1L, 1, 0);
        this.assertParseResult("+1.1", 11L, 2, 1);
        this.assertParseResult("+1.", 1L, 1, 0);
        this.assertParseResult("-1.1", -11L, 2, 1);
        this.assertParseResult("-1.", -1L, 1, 0);
        this.assertParseResult("0001.1", 11L, 2, 1);
        this.assertParseResult("+0001.1", 11L, 2, 1);
        this.assertParseResult("-0001.1", -11L, 2, 1);
        this.assertParseResult("0.1", 1L, 1, 1);
        this.assertParseResult(".1", 1L, 1, 1);
        this.assertParseResult("+0.1", 1L, 1, 1);
        this.assertParseResult("+.1", 1L, 1, 1);
        this.assertParseResult("-0.1", -1L, 1, 1);
        this.assertParseResult("-.1", -1L, 1, 1);
        this.assertParseResult(".1", 1L, 1, 1);
        this.assertParseResult("+.1", 1L, 1, 1);
        this.assertParseResult("-.1", -1L, 1, 1);
        this.assertParseResult("000.1", 1L, 1, 1);
        this.assertParseResult("+000.1", 1L, 1, 1);
        this.assertParseResult("-000.1", -1L, 1, 1);
        this.assertParseResult("12345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("+12345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("-12345678901234567", -12345678901234567L, 17, 0);
        this.assertParseResult("00012345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("+00012345678901234567", 12345678901234567L, 17, 0);
        this.assertParseResult("-00012345678901234567", -12345678901234567L, 17, 0);
        this.assertParseResult("0.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("+0.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("-0.12345678901234567", -12345678901234567L, 17, 17);
        this.assertParseResult("000.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("+000.12345678901234567", 12345678901234567L, 17, 17);
        this.assertParseResult("-000.12345678901234567", -12345678901234567L, 17, 17);
        this.assertParseResult("12345678901234567890.123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("+12345678901234567890.123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("-12345678901234567890.123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("00012345678901234567890.123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("+00012345678901234567890.123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("-00012345678901234567890.123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 18);
        this.assertParseResult("0.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+0.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-0.12345678901234567890123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult(".12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-.12345678901234567890123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("0000.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("+0000.12345678901234567890123456789012345678", Int128.valueOf((String)"12345678901234567890123456789012345678"), 38, 38);
        this.assertParseResult("-0000.12345678901234567890123456789012345678", Int128.valueOf((String)"-12345678901234567890123456789012345678"), 38, 38);
    }

    @Test
    public void testRejectNoDigits() {
        this.assertParseFailure(".");
        this.assertParseFailure("+.");
        this.assertParseFailure("-.");
    }

    @Test
    public void testEncodeShortScaledValue() {
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2.00"), (int)2), (long)200L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2.13"), (int)2), (long)213L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("172.60"), (int)2), (long)17260L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("2"), (int)2), (long)200L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("172.6"), (int)2), (long)17260L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2.00"), (int)2), (long)-200L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2.13"), (int)2), (long)-213L);
        Assert.assertEquals((long)Decimals.encodeShortScaledValue((BigDecimal)new BigDecimal("-2"), (int)2), (long)-200L);
    }

    @Test
    public void testEncodeScaledValue() {
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2.00"), (int)2), (Object)Int128.valueOf((long)200L));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2.13"), (int)2), (Object)Int128.valueOf((long)213L));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("172.60"), (int)2), (Object)Int128.valueOf((long)17260L));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("2"), (int)2), (Object)Int128.valueOf((long)200L));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("172.6"), (int)2), (Object)Int128.valueOf((long)17260L));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2.00"), (int)2), (Object)Int128.valueOf((long)-200L));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2.13"), (int)2), (Object)Int128.valueOf((long)-213L));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-2"), (int)2), (Object)Int128.valueOf((long)-200L));
        Assert.assertEquals((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("-172.60"), (int)2), (Object)Int128.valueOf((long)-17260L));
    }

    @Test
    public void testOverflows() {
        Assert.assertTrue((boolean)Decimals.overflows((Int128)Int128.valueOf((String)"100"), (int)2));
        Assert.assertTrue((boolean)Decimals.overflows((Int128)Int128.valueOf((String)"-100"), (int)2));
        Assert.assertFalse((boolean)Decimals.overflows((Int128)Int128.valueOf((String)"99"), (int)2));
        Assert.assertFalse((boolean)Decimals.overflows((Int128)Int128.valueOf((String)"-99"), (int)2));
    }

    private void assertParseResult(String value, Object expectedObject, int expectedPrecision, int expectedScale) {
        Assert.assertEquals((Object)Decimals.parse((String)value), (Object)new DecimalParseResult(expectedObject, DecimalType.createDecimalType((int)expectedPrecision, (int)expectedScale)));
    }

    private void assertParseFailure(String text) {
        try {
            Decimals.parse((String)text);
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = String.format("Invalid decimal value '%s'", text);
            if (!Objects.equals(e.getMessage(), expectedMessage)) {
                Assert.fail((String)String.format("Unexpected exception, exception with message '%s' was expected", expectedMessage), (Throwable)e);
            }
            return;
        }
        Assert.fail((String)"Parse failure was expected");
    }
}

