/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.IntArrayList;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.type.MapType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public abstract class AbstractMapBlock
implements Block {
    private final MapType mapType;

    public AbstractMapBlock(MapType mapType) {
        this.mapType = Objects.requireNonNull(mapType, "mapType is null");
    }

    @Override
    public final List<Block> getChildren() {
        return List.of(this.getRawKeyBlock(), this.getRawValueBlock());
    }

    protected MapType getMapType() {
        return this.mapType;
    }

    protected abstract Block getRawKeyBlock();

    protected abstract Block getRawValueBlock();

    protected abstract MapHashTables getHashTables();

    protected abstract int[] getOffsets();

    protected abstract int getOffsetBase();

    @Nullable
    protected abstract boolean[] getMapIsNull();

    protected abstract void ensureHashTableLoaded();

    int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public String getEncodingName() {
        return "MAP";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        boolean[] newMapIsNull = new boolean[length];
        IntArrayList entriesPositions = new IntArrayList();
        int newPosition = 0;
        for (int i = offset; i < offset + length; ++i) {
            int position = positions[i];
            if (this.isNull(position)) {
                newMapIsNull[newPosition] = true;
                newOffsets[newPosition + 1] = newOffsets[newPosition];
            } else {
                int entriesStartOffset = this.getOffset(position);
                int entriesEndOffset = this.getOffset(position + 1);
                int entryCount = entriesEndOffset - entriesStartOffset;
                newOffsets[newPosition + 1] = newOffsets[newPosition] + entryCount;
                for (int elementIndex = entriesStartOffset; elementIndex < entriesEndOffset; ++elementIndex) {
                    entriesPositions.add(elementIndex);
                }
            }
            ++newPosition;
        }
        int[] rawHashTables = this.getHashTables().tryGet().orElse(null);
        int[] newRawHashTables = null;
        int newHashTableEntries = newOffsets[newOffsets.length - 1] * 2;
        if (rawHashTables != null) {
            newRawHashTables = new int[newHashTableEntries];
            int newHashIndex = 0;
            for (int i = offset; i < offset + length; ++i) {
                int position = positions[i];
                int entriesStartOffset = this.getOffset(position);
                int entriesEndOffset = this.getOffset(position + 1);
                for (int hashIndex = entriesStartOffset * 2; hashIndex < entriesEndOffset * 2; ++hashIndex) {
                    newRawHashTables[newHashIndex] = rawHashTables[hashIndex];
                    ++newHashIndex;
                }
            }
        }
        Block newKeys = this.getRawKeyBlock().copyPositions(entriesPositions.elements(), 0, entriesPositions.size());
        Block newValues = this.getRawValueBlock().copyPositions(entriesPositions.elements(), 0, entriesPositions.size());
        return MapBlock.createMapBlockInternal(this.mapType, 0, length, Optional.of(newMapIsNull), newOffsets, newKeys, newValues, new MapHashTables(this.mapType, Optional.ofNullable(newRawHashTables)));
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return MapBlock.createMapBlockInternal(this.mapType, position + this.getOffsetBase(), length, Optional.ofNullable(this.getMapIsNull()), this.getOffsets(), this.getRawKeyBlock(), this.getRawValueBlock(), this.getHashTables());
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int entriesStart = this.getOffsets()[this.getOffsetBase() + position];
        int entriesEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        int entryCount = entriesEnd - entriesStart;
        return this.getRawKeyBlock().getRegionSizeInBytes(entriesStart, entryCount) + this.getRawValueBlock().getRegionSizeInBytes(entriesStart, entryCount) + 5L * (long)length + 8L * (long)entryCount;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    private OptionalInt keyAndValueFixedSizeInBytesPerRow() {
        OptionalInt keyFixedSizePerRow = this.getRawKeyBlock().fixedSizeInBytesPerPosition();
        if (!keyFixedSizePerRow.isPresent()) {
            return OptionalInt.empty();
        }
        OptionalInt valueFixedSizePerRow = this.getRawValueBlock().fixedSizeInBytesPerPosition();
        if (!valueFixedSizePerRow.isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(keyFixedSizePerRow.getAsInt() + valueFixedSizePerRow.getAsInt());
    }

    @Override
    public final long getPositionsSizeInBytes(boolean[] positions, int selectedMapPositions) {
        long keyAndValuesSizeInBytes;
        int selectedEntryCount;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidPositions(positions, positionCount);
        if (selectedMapPositions == 0) {
            return 0L;
        }
        if (selectedMapPositions == positionCount) {
            return this.getSizeInBytes();
        }
        int[] offsets = this.getOffsets();
        int offsetBase = this.getOffsetBase();
        OptionalInt fixedKeyAndValueSizePerRow = this.keyAndValueFixedSizeInBytesPerRow();
        if (fixedKeyAndValueSizePerRow.isPresent()) {
            selectedEntryCount = BlockUtil.countSelectedPositionsFromOffsets(positions, offsets, offsetBase);
            keyAndValuesSizeInBytes = (long)fixedKeyAndValueSizePerRow.getAsInt() * (long)selectedEntryCount;
        } else {
            boolean[] entryPositions = new boolean[this.getRawKeyBlock().getPositionCount()];
            selectedEntryCount = BlockUtil.countAndMarkSelectedPositionsFromOffsets(positions, offsets, offsetBase, entryPositions);
            keyAndValuesSizeInBytes = this.getRawKeyBlock().getPositionsSizeInBytes(entryPositions, selectedEntryCount) + this.getRawValueBlock().getPositionsSizeInBytes(entryPositions, selectedEntryCount);
        }
        return keyAndValuesSizeInBytes + 5L * (long)selectedMapPositions + 8L * (long)selectedEntryCount;
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newKeys = this.getRawKeyBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        Block newValues = this.getRawValueBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = BlockUtil.compactOffsets(this.getOffsets(), position + this.getOffsetBase(), length);
        boolean[] mapIsNull = this.getMapIsNull();
        boolean[] newMapIsNull = mapIsNull == null ? null : BlockUtil.compactArray(mapIsNull, position + this.getOffsetBase(), length);
        int[] rawHashTables = this.getHashTables().tryGet().orElse(null);
        int[] newRawHashTables = null;
        int expectedNewHashTableEntries = (endValueOffset - startValueOffset) * 2;
        if (rawHashTables != null) {
            newRawHashTables = BlockUtil.compactArray(rawHashTables, startValueOffset * 2, expectedNewHashTableEntries);
        }
        if (newKeys == this.getRawKeyBlock() && newValues == this.getRawValueBlock() && newOffsets == this.getOffsets() && newMapIsNull == mapIsNull && newRawHashTables == rawHashTables) {
            return this;
        }
        return MapBlock.createMapBlockInternal(this.mapType, 0, length, Optional.ofNullable(newMapIsNull), newOffsets, newKeys, newValues, new MapHashTables(this.mapType, Optional.ofNullable(newRawHashTables)));
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        BlockUtil.checkReadablePosition(this, position);
        int startEntryOffset = this.getOffset(position);
        int endEntryOffset = this.getOffset(position + 1);
        return clazz.cast(new SingleMapBlock(startEntryOffset * 2, (endEntryOffset - startEntryOffset) * 2, this));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        BlockUtil.checkReadablePosition(this, position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        int valueLength = endValueOffset - startValueOffset;
        Block newKeys = this.getRawKeyBlock().copyRegion(startValueOffset, valueLength);
        Block newValues = this.getRawValueBlock().copyRegion(startValueOffset, valueLength);
        int[] rawHashTables = this.getHashTables().tryGet().orElse(null);
        int[] newRawHashTables = null;
        if (rawHashTables != null) {
            newRawHashTables = Arrays.copyOfRange(rawHashTables, startValueOffset * 2, endValueOffset * 2);
        }
        return MapBlock.createMapBlockInternal(this.mapType, 0, 1, Optional.of(new boolean[]{this.isNull(position)}), new int[]{0, valueLength}, newKeys, newValues, new MapHashTables(this.mapType, Optional.ofNullable(newRawHashTables)));
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            return 0L;
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        long size = 0L;
        Block rawKeyBlock = this.getRawKeyBlock();
        Block rawValueBlock = this.getRawValueBlock();
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            size += rawKeyBlock.getEstimatedDataSizeForStats(i);
            size += rawValueBlock.getEstimatedDataSizeForStats(i);
        }
        return size;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        boolean[] mapIsNull = this.getMapIsNull();
        return mapIsNull != null && mapIsNull[position + this.getOffsetBase()];
    }

    public boolean isHashTablesPresent() {
        return this.getHashTables().tryGet().isPresent();
    }
}

