/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class Int128ArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Int128ArrayBlockBuilder.class).instanceSize());
    private static final Block NULL_VALUE_BLOCK = new Int128ArrayBlock(0, 1, new boolean[]{true}, new long[2]);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private long[] values = new long[0];
    private long retainedSizeInBytes;
    private int entryPositionCount;

    public Int128ArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public BlockBuilder writeLong(long value) {
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount * 2 + this.entryPositionCount] = value;
        ++this.entryPositionCount;
        this.hasNonNullValue = true;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.entryPositionCount != 2) {
            throw new IllegalStateException("Expected entry size to be exactly 16 bytes but was " + this.entryPositionCount * 8);
        }
        ++this.positionCount;
        this.entryPositionCount = 0;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(17);
        }
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        if (this.entryPositionCount != 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(17);
        }
        return this;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new Int128ArrayBlock(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new Int128ArrayBlockBuilder(blockBuilderStatus, expectedEntries);
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize * 2);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((long[])this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(17);
    }

    @Override
    public long getSizeInBytes() {
        return 17L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 17L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        return 17L * (long)selectedPositionsCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 16L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((long[])this.values));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getLong(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        if (offset == 0) {
            return this.values[position * 2];
        }
        if (offset == 8) {
            return this.values[position * 2 + 1];
        }
        throw new IllegalArgumentException("offset must be 0 or 8");
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullValue;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull[position];
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        if (this.valueIsNull[position]) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new Int128ArrayBlock(0, 1, blArray, new long[]{this.values[position * 2], this.values[position * 2 + 1]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = new boolean[length];
        }
        long[] newValues = new long[length * 2];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            BlockUtil.checkReadablePosition(this, position);
            if (this.hasNullValue) {
                newValueIsNull[i] = this.valueIsNull[position];
            }
            newValues[i * 2] = this.values[position * 2];
            newValues[i * 2 + 1] = this.values[position * 2 + 1];
        }
        return new Int128ArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        return new Int128ArrayBlock(positionOffset, length, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        }
        long[] newValues = BlockUtil.compactArray(this.values, positionOffset * 2, length * 2);
        return new Int128ArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public String getEncodingName() {
        return "INT128_ARRAY";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Int128ArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    Slice getValuesSlice() {
        return Slices.wrappedLongArray((long[])this.values, (int)0, (int)(this.positionCount * 2));
    }
}

