/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import io.trino.spi.Experimental;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@Experimental(eta="2022-10-31")
public class AggregationFunctionMetadata {
    private final boolean orderSensitive;
    private final List<TypeSignature> intermediateTypes;

    private AggregationFunctionMetadata(boolean orderSensitive, List<TypeSignature> intermediateTypes) {
        this.orderSensitive = orderSensitive;
        this.intermediateTypes = List.copyOf((Collection)Objects.requireNonNull(intermediateTypes, "intermediateTypes is null"));
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public boolean isDecomposable() {
        return !this.intermediateTypes.isEmpty();
    }

    public List<TypeSignature> getIntermediateTypes() {
        return this.intermediateTypes;
    }

    public String toString() {
        return new StringJoiner(", ", AggregationFunctionMetadata.class.getSimpleName() + "[", "]").add("orderSensitive=" + this.orderSensitive).add("intermediateTypes=" + this.intermediateTypes).toString();
    }

    public static AggregationFunctionMetadataBuilder builder() {
        return new AggregationFunctionMetadataBuilder();
    }

    public static class AggregationFunctionMetadataBuilder {
        private boolean orderSensitive;
        private final List<TypeSignature> intermediateTypes = new ArrayList<TypeSignature>();

        private AggregationFunctionMetadataBuilder() {
        }

        public AggregationFunctionMetadataBuilder orderSensitive() {
            this.orderSensitive = true;
            return this;
        }

        public AggregationFunctionMetadataBuilder intermediateType(Type type) {
            this.intermediateTypes.add(type.getTypeSignature());
            return this;
        }

        public AggregationFunctionMetadataBuilder intermediateType(TypeSignature type) {
            this.intermediateTypes.add(Objects.requireNonNull(type, "type is null"));
            return this;
        }

        public AggregationFunctionMetadata build() {
            return new AggregationFunctionMetadata(this.orderSensitive, this.intermediateTypes);
        }
    }
}

