/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.airlift.slice.SizeOf;
import io.trino.spi.Experimental;
import java.util.Locale;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

@Experimental(eta="2023-02-01")
public final class CatalogHandle {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(CatalogHandle.class).instanceSize());
    private final String catalogName;
    private final CatalogHandleType type;
    private final CatalogHandle rootCatalogHandle;
    private final CatalogVersion version;

    public static CatalogHandle createRootCatalogHandle(String catalogName, CatalogVersion version) {
        return new CatalogHandle(catalogName, CatalogHandleType.NORMAL, version);
    }

    public static CatalogHandle createInformationSchemaCatalogHandle(CatalogHandle catalogHandle) {
        return new CatalogHandle(catalogHandle.getCatalogName(), CatalogHandleType.INFORMATION_SCHEMA, catalogHandle.getVersion());
    }

    public static CatalogHandle createSystemTablesCatalogHandle(CatalogHandle catalogHandle) {
        return new CatalogHandle(catalogHandle.getCatalogName(), CatalogHandleType.SYSTEM, catalogHandle.getVersion());
    }

    @JsonCreator
    public static CatalogHandle fromId(String id) {
        Objects.requireNonNull(id, "id is null");
        int versionSplit = id.lastIndexOf(58);
        if (versionSplit <= 0) {
            throw new IllegalArgumentException("invalid id " + id);
        }
        int typeSplit = id.lastIndexOf(58, versionSplit - 1);
        if (typeSplit <= 0) {
            throw new IllegalArgumentException("invalid id " + id);
        }
        String catalogName = id.substring(0, typeSplit);
        CatalogHandleType type = CatalogHandleType.valueOf(id.substring(typeSplit + 1, versionSplit).toUpperCase(Locale.ROOT));
        CatalogVersion version = new CatalogVersion(id.substring(versionSplit + 1));
        return new CatalogHandle(catalogName, type, version);
    }

    private CatalogHandle(String catalogName, CatalogHandleType type, CatalogVersion version) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.version = Objects.requireNonNull(version, "version is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isEmpty()) {
            throw new IllegalArgumentException("catalogName is empty");
        }
        this.rootCatalogHandle = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case CatalogHandleType.NORMAL -> this;
            case CatalogHandleType.INFORMATION_SCHEMA, CatalogHandleType.SYSTEM -> new CatalogHandle(catalogName, CatalogHandleType.NORMAL, version);
        };
    }

    @JsonValue
    public String getId() {
        return this.catalogName + ":" + this.type.toString().toLowerCase(Locale.ROOT) + ":" + this.version;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public CatalogHandleType getType() {
        return this.type;
    }

    public CatalogVersion getVersion() {
        return this.version;
    }

    public CatalogHandle getRootCatalogHandle() {
        return this.rootCatalogHandle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CatalogHandle)) return false;
        CatalogHandle that = (CatalogHandle)other;
        if (!Objects.equals(this.catalogName, that.catalogName)) return false;
        if (this.type != that.type) return false;
        if (!Objects.equals(this.version, that.version)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalogName, this.type, this.version});
    }

    public String toString() {
        return this.catalogName;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.catalogName) + this.version.getRetainedSizeInBytes() + (this.rootCatalogHandle == this ? 0L : this.rootCatalogHandle.getRetainedSizeInBytes());
    }

    public static enum CatalogHandleType {
        NORMAL(false),
        INFORMATION_SCHEMA(true),
        SYSTEM(true);

        private final boolean internal;

        private CatalogHandleType(boolean internal) {
            this.internal = internal;
        }

        public boolean isInternal() {
            return this.internal;
        }
    }

    @Experimental(eta="2023-02-01")
    public static final class CatalogVersion
    implements Comparable<CatalogVersion> {
        private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(CatalogVersion.class).instanceSize());
        private final String version;

        @JsonCreator
        public CatalogVersion(String version) {
            Objects.requireNonNull(version, "version is null");
            if (version.isEmpty()) {
                throw new IllegalArgumentException("version is empty");
            }
            for (int i = 0; i < version.length(); ++i) {
                if (CatalogVersion.isAllowedCharacter(version.charAt(i))) continue;
                throw new IllegalArgumentException("invalid version: " + version);
            }
            this.version = version;
        }

        private static boolean isAllowedCharacter(char c) {
            return '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || c == '_' || c == '-';
        }

        @Override
        public int compareTo(CatalogVersion other) {
            return this.version.compareTo(other.version);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CatalogVersion)) return false;
            CatalogVersion that = (CatalogVersion)other;
            if (!this.version.equals(that.version)) return false;
            return true;
        }

        public int hashCode() {
            return this.version.hashCode();
        }

        @JsonValue
        public String toString() {
            return this.version;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.version);
        }
    }
}

