/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigInteger;
import java.nio.ByteOrder;
import org.openjdk.jol.info.ClassLayout;

public class Int128
implements Comparable<Int128> {
    private static final VarHandle BIG_ENDIAN_LONG_VIEW = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
    public static final int SIZE = 16;
    public static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Int128.class).instanceSize());
    public static final Int128 MAX_VALUE = Int128.valueOf(Long.MAX_VALUE, -1L);
    public static final Int128 MIN_VALUE = Int128.valueOf(Long.MIN_VALUE, 0L);
    public static final Int128 ONE = Int128.valueOf(0L, 1L);
    public static final Int128 ZERO = Int128.valueOf(0L, 0L);
    private final long high;
    private final long low;

    private Int128(long high, long low) {
        this.high = high;
        this.low = low;
    }

    public static Int128 fromBigEndian(byte[] bytes) {
        long high;
        if (bytes.length >= 16) {
            int offset = bytes.length - 8;
            long low = BIG_ENDIAN_LONG_VIEW.get(bytes, offset);
            long high2 = BIG_ENDIAN_LONG_VIEW.get(bytes, offset -= 8);
            for (int i = 0; i < offset; ++i) {
                if ((long)bytes[i] == high2 >> 63) continue;
                throw new ArithmeticException("Overflow");
            }
            return Int128.valueOf(high2, low);
        }
        if (bytes.length > 8) {
            int offset = bytes.length - 8;
            long low = BIG_ENDIAN_LONG_VIEW.get(bytes, offset);
            long high3 = BIG_ENDIAN_LONG_VIEW.get(bytes, 0);
            return Int128.valueOf(high3 >>= -(offset -= 8) * 8, low);
        }
        if (bytes.length == 8) {
            long low = BIG_ENDIAN_LONG_VIEW.get(bytes, 0);
            long high4 = low >> 63;
            return Int128.valueOf(high4, low);
        }
        long low = high = (long)(bytes[0] >> 7);
        for (int i = 0; i < bytes.length; ++i) {
            low = low << 8 | (long)(bytes[i] & 0xFF);
        }
        return Int128.valueOf(high, low);
    }

    public static Int128 valueOf(long[] value) {
        if (value.length != 2) {
            throw new IllegalArgumentException("Expected long[2]");
        }
        long high = value[0];
        long low = value[1];
        return Int128.valueOf(high, low);
    }

    public static Int128 valueOf(long high, long low) {
        return new Int128(high, low);
    }

    public static Int128 valueOf(String value) {
        return Int128.valueOf(new BigInteger(value));
    }

    public static Int128 valueOf(BigInteger value) {
        long high;
        long low = value.longValue();
        try {
            high = value.shiftRight(64).longValueExact();
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("BigInteger out of Int128 range");
        }
        return new Int128(high, low);
    }

    public static Int128 valueOf(long value) {
        return new Int128(value >> 63, value);
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Int128 that = (Int128)o;
        return this.high == that.high && this.low == that.low;
    }

    public int hashCode() {
        long hash = -7046029288634856825L;
        hash = (hash ^ this.high) * -4417276706812531889L;
        hash = (hash ^ this.low) * -4417276706812531889L;
        return Long.hashCode(hash);
    }

    @Override
    public int compareTo(Int128 other) {
        return Int128.compare(this.high, this.low, other.high, other.low);
    }

    public String toString() {
        return this.toBigInteger().toString();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.toBigEndianBytes());
    }

    public byte[] toBigEndianBytes() {
        byte[] bytes = new byte[16];
        this.toBigEndianBytes(bytes, 0);
        return bytes;
    }

    public void toBigEndianBytes(byte[] bytes, int offset) {
        BIG_ENDIAN_LONG_VIEW.set(bytes, offset, this.high);
        BIG_ENDIAN_LONG_VIEW.set(bytes, offset + 8, this.low);
    }

    public long toLong() {
        return this.low;
    }

    public long toLongExact() {
        if (this.high != this.low >> 63) {
            throw new ArithmeticException("Overflow");
        }
        return this.low;
    }

    public long[] toLongArray() {
        return new long[]{this.high, this.low};
    }

    public static int compare(long leftHigh, long leftLow, long rightHigh, long rightLow) {
        int comparison = Long.compare(leftHigh, rightHigh);
        if (comparison == 0) {
            comparison = Long.compareUnsigned(leftLow, rightLow);
        }
        return comparison;
    }

    public boolean isZero() {
        return this.high == 0L && this.low == 0L;
    }

    public boolean isNegative() {
        return this.high < 0L;
    }
}

