/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.Int96ArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;
import java.util.Optional;

class LongTimestampType
extends TimestampType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(LongTimestampType.class, MethodHandles.lookup(), LongTimestamp.class);
    private final Type.Range range;

    public LongTimestampType(int precision) {
        super(precision, LongTimestamp.class);
        if (precision < 7 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [%s, %s]", 7, 12));
        }
        int picosOfMicroMax = Math.toIntExact(1000000L - Timestamps.rescale(1L, 0, 12 - this.getPrecision()));
        this.range = new Type.Range(new LongTimestamp(Long.MIN_VALUE, 0), new LongTimestamp(Long.MAX_VALUE, picosOfMicroMax));
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 12;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int96ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int96ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(LongTimestampType.getEpochMicros(block, position));
            blockBuilder.writeInt(LongTimestampType.getFraction(block, position));
            blockBuilder.closeEntry();
        }
    }

    @Override
    public Object getObject(Block block, int position) {
        return new LongTimestamp(LongTimestampType.getEpochMicros(block, position), LongTimestampType.getFraction(block, position));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LongTimestamp timestamp = (LongTimestamp)value;
        this.write(blockBuilder, timestamp.getEpochMicros(), timestamp.getPicosOfMicro());
    }

    public void write(BlockBuilder blockBuilder, long epochMicros, int fraction) {
        blockBuilder.writeLong(epochMicros);
        blockBuilder.writeInt(fraction);
        blockBuilder.closeEntry();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long epochMicros = LongTimestampType.getEpochMicros(block, position);
        int fraction = LongTimestampType.getFraction(block, position);
        return SqlTimestamp.newInstance(this.getPrecision(), epochMicros, fraction);
    }

    private static long getEpochMicros(Block block, int position) {
        return block.getLong(position, 0);
    }

    private static int getFraction(Block block, int position) {
        return block.getInt(position, 8);
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(this.range);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(LongTimestamp left, LongTimestamp right) {
        return LongTimestampType.equal(left.getEpochMicros(), left.getPicosOfMicro(), right.getEpochMicros(), right.getPicosOfMicro());
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampType.equal(LongTimestampType.getEpochMicros(leftBlock, leftPosition), LongTimestampType.getFraction(leftBlock, leftPosition), LongTimestampType.getEpochMicros(rightBlock, rightPosition), LongTimestampType.getFraction(rightBlock, rightPosition));
    }

    private static boolean equal(long leftEpochMicros, int leftFraction, long rightEpochMicros, int rightFraction) {
        return leftEpochMicros == rightEpochMicros && leftFraction == rightFraction;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(LongTimestamp value) {
        return LongTimestampType.xxHash64(value.getEpochMicros(), value.getPicosOfMicro());
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return LongTimestampType.xxHash64(LongTimestampType.getEpochMicros(block, position), LongTimestampType.getFraction(block, position));
    }

    private static long xxHash64(long epochMicros, int fraction) {
        return XxHash64.hash((long)epochMicros) ^ XxHash64.hash((long)fraction);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(LongTimestamp left, LongTimestamp right) {
        return LongTimestampType.comparison(left.getEpochMicros(), left.getPicosOfMicro(), right.getEpochMicros(), right.getPicosOfMicro());
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampType.comparison(LongTimestampType.getEpochMicros(leftBlock, leftPosition), LongTimestampType.getFraction(leftBlock, leftPosition), LongTimestampType.getEpochMicros(rightBlock, rightPosition), LongTimestampType.getFraction(rightBlock, rightPosition));
    }

    private static int comparison(long leftEpochMicros, int leftPicosOfMicro, long rightEpochMicros, int rightPicosOfMicro) {
        int value = Long.compare(leftEpochMicros, rightEpochMicros);
        if (value != 0) {
            return value;
        }
        return Integer.compare(leftPicosOfMicro, rightPicosOfMicro);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(LongTimestamp left, LongTimestamp right) {
        return LongTimestampType.lessThan(left.getEpochMicros(), left.getPicosOfMicro(), right.getEpochMicros(), right.getPicosOfMicro());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampType.lessThan(LongTimestampType.getEpochMicros(leftBlock, leftPosition), LongTimestampType.getFraction(leftBlock, leftPosition), LongTimestampType.getEpochMicros(rightBlock, rightPosition), LongTimestampType.getFraction(rightBlock, rightPosition));
    }

    private static boolean lessThan(long leftEpochMicros, int leftPicosOfMicro, long rightEpochMicros, int rightPicosOfMicro) {
        return leftEpochMicros < rightEpochMicros || leftEpochMicros == rightEpochMicros && leftPicosOfMicro < rightPicosOfMicro;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(LongTimestamp left, LongTimestamp right) {
        return LongTimestampType.lessThanOrEqual(left.getEpochMicros(), left.getPicosOfMicro(), right.getEpochMicros(), right.getPicosOfMicro());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampType.lessThanOrEqual(LongTimestampType.getEpochMicros(leftBlock, leftPosition), LongTimestampType.getFraction(leftBlock, leftPosition), LongTimestampType.getEpochMicros(rightBlock, rightPosition), LongTimestampType.getFraction(rightBlock, rightPosition));
    }

    private static boolean lessThanOrEqual(long leftEpochMicros, int leftPicosOfMicro, long rightEpochMicros, int rightPicosOfMicro) {
        return leftEpochMicros < rightEpochMicros || leftEpochMicros == rightEpochMicros && leftPicosOfMicro <= rightPicosOfMicro;
    }
}

