/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.testng.annotations.Test;

@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=2)
@Warmup(iterations=5, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkCopyPositions {
    private static final int SEED = 831;
    private static final int POSITIONS = 8096;
    private static final double NULLS_CHANCE = 0.2;

    @Benchmark
    public Block copyPositions(BenchmarkData data) {
        int[] positionIds = data.getPositionsIds();
        return data.getBlock().copyPositions(positionIds, 0, positionIds.length);
    }

    @Test
    public void testCopyPositions() {
        for (SelectedPositions selectedPositions : SelectedPositions.values()) {
            for (boolean nullsAllowed : new boolean[]{false, true}) {
                for (String type : new String[]{"VARCHAR", "ROW(BIGINT)"}) {
                    BenchmarkData data = new BenchmarkData(1024, nullsAllowed, selectedPositions, type);
                    data.setup();
                    this.copyPositions(data);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkCopyPositions.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgsAppend(new String[]{"-Xmx4g", "-Xms4g"})).run();
    }

    static {
        new BenchmarkCopyPositions().testCopyPositions();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"200", "1000", "8000"})
        private int selectedPositionsCount;
        @Param(value={"false", "true"})
        private boolean nullsAllowed;
        @Param(value={"GROUPED", "SEQUENCE", "RANDOM"})
        private SelectedPositions selectedPositions;
        @Param(value={"VARCHAR", "ROW(BIGINT)"})
        private String type;
        private int[] positionsIds;
        private Block block;

        public BenchmarkData(int selectedPositionsCount, boolean nullsAllowed, SelectedPositions selectedPositions, String type) {
            this.selectedPositionsCount = selectedPositionsCount;
            this.nullsAllowed = nullsAllowed;
            this.selectedPositions = Objects.requireNonNull(selectedPositions, "selectedPositions is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public BenchmarkData() {
            this(1000, false, SelectedPositions.SEQUENCE, "VARCHAR");
        }

        @Setup
        public void setup() {
            this.positionsIds = this.selectedPositions.generateIds(this.selectedPositionsCount);
            if (this.type.equals("VARCHAR")) {
                Slice[] slices = this.generateValues();
                this.block = BenchmarkData.createBlockBuilderWithValues(slices).build();
            } else if (this.type.equals("ROW(BIGINT)")) {
                this.block = this.createRowBlock(8096, new Block[]{BenchmarkData.createRandomLongArrayBlock()});
            }
        }

        private Slice[] generateValues() {
            Random random = new Random(831L);
            Slice[] generatedValues = new Slice[8096];
            for (int position = 0; position < 8096; ++position) {
                if (this.nullsAllowed && BenchmarkData.randomNullChance(random)) {
                    generatedValues[position] = null;
                    continue;
                }
                int length = random.nextInt(380) + 20;
                byte[] buffer = new byte[length];
                random.nextBytes(buffer);
                generatedValues[position] = Slices.wrappedBuffer((byte[])buffer);
            }
            return generatedValues;
        }

        private static boolean randomNullChance(Random random) {
            double value = 0.0;
            while (value == 0.0) {
                value = random.nextDouble();
            }
            return value < 0.2;
        }

        private static BlockBuilder createBlockBuilderWithValues(Slice[] generatedValues) {
            VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, generatedValues.length, 32 * generatedValues.length);
            for (Slice value : generatedValues) {
                if (value == null) {
                    blockBuilder.appendNull();
                    continue;
                }
                blockBuilder.writeBytes(value, 0, value.length()).closeEntry();
            }
            return blockBuilder;
        }

        private static LongArrayBlock createRandomLongArrayBlock() {
            Random random = new Random(831L);
            return new LongArrayBlock(8096, Optional.empty(), LongStream.range(0L, 8096L).map(i -> random.nextLong()).toArray());
        }

        private Block createRowBlock(int positionCount, Block ... field) {
            Optional rowIsNull = this.nullsAllowed ? Optional.of(this.generateIsNull(positionCount)) : Optional.empty();
            return RowBlock.fromFieldBlocks((int)positionCount, rowIsNull, (Block[])field);
        }

        private boolean[] generateIsNull(int positionCount) {
            Random random = new Random(831L);
            boolean[] result = new boolean[positionCount];
            for (int i = 0; i < positionCount; ++i) {
                result[i] = BenchmarkData.randomNullChance(random);
            }
            return result;
        }

        public int[] getPositionsIds() {
            return this.positionsIds;
        }

        public Block getBlock() {
            return this.block;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SelectedPositions {
        SEQUENCE{

            @Override
            int[] generateIds(int positionsCount) {
                return IntStream.range(0, positionsCount).toArray();
            }
        }
        ,
        RANDOM{

            @Override
            int[] generateIds(int positionsCount) {
                return new Random(831L).ints(positionsCount, 0, 8096).toArray();
            }
        }
        ,
        GROUPED{

            @Override
            int[] generateIds(int positionsCount) {
                Random random = new Random(831L);
                int maxGroupSize = positionsCount / 10;
                int[] ids = new int[positionsCount];
                int index = 0;
                int currentPosition = 0;
                while (index < positionsCount) {
                    Preconditions.checkState((currentPosition < 8096 ? 1 : 0) != 0, (Object)"Reduce maxGroupSize or positionsCount to fit the generated ids within POSITIONS");
                    int groupSize = Math.min(random.nextInt(maxGroupSize), Math.min(positionsCount - index, 8096 - currentPosition));
                    for (int i = 0; i < groupSize; ++i) {
                        ids[index] = currentPosition++;
                        ++index;
                    }
                    ++currentPosition;
                }
                return ids;
            }
        };


        abstract int[] generateIds(int var1);
    }
}

