/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.spi.block.BaseBlockEncodingTest;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;

public class TestRowBlockEncoding
extends BaseBlockEncodingTest<Object[]> {
    @Override
    protected Type getType() {
        return RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR));
    }

    @Override
    protected void write(BlockBuilder blockBuilder, Object[] value) {
        BlockBuilder row = blockBuilder.beginBlockEntry();
        BigintType.BIGINT.writeLong(row, ((Long)value[0]).longValue());
        VarcharType.VARCHAR.writeSlice(row, Slices.utf8Slice((String)((String)value[1])));
        blockBuilder.closeEntry();
    }

    @Override
    protected Object[] randomValue(Random random) {
        byte[] data = new byte[random.nextInt(256)];
        random.nextBytes(data);
        return new Object[]{random.nextLong(), new String(data, Charset.defaultCharset()), null};
    }
}

