/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Provider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConnectorViewDefinition {
    private static final JsonCodec<ConnectorViewDefinition> CODEC = TestConnectorViewDefinition.createTestingViewCodec();
    private static final String BASE_JSON = "\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}]";

    private static JsonCodec<ConnectorViewDefinition> createTestingViewCodec() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)((Object)new TestingTypeDeserializer(new TestingTypeManager()))));
        return new JsonCodecFactory((Provider)provider).jsonCodec(ConnectorViewDefinition.class);
    }

    @Test
    public void testLegacyViewWithoutOwner() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}]}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assert.assertFalse((boolean)view.getOwner().isPresent());
    }

    @Test
    public void testViewWithOwner() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}], \"owner\": \"abc\"}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assert.assertEquals((Object)view.getOwner(), Optional.of("abc"));
        Assert.assertFalse((boolean)view.isRunAsInvoker());
    }

    @Test
    public void testViewComment() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}], \"comment\": \"hello\"}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assert.assertEquals((Object)view.getComment(), Optional.of("hello"));
    }

    @Test
    public void testViewSecurityDefiner() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}], \"owner\": \"abc\", \"runAsInvoker\": false}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assert.assertEquals((Object)view.getOwner(), Optional.of("abc"));
        Assert.assertFalse((boolean)view.isRunAsInvoker());
    }

    @Test
    public void testViewSecurityInvoker() {
        ConnectorViewDefinition view = (ConnectorViewDefinition)CODEC.fromJson("{\"originalSql\": \"SELECT 42 x\", \"columns\": [{\"name\": \"x\", \"type\": \"bigint\"}], \"runAsInvoker\": true}");
        TestConnectorViewDefinition.assertBaseView(view);
        Assert.assertFalse((boolean)view.getOwner().isPresent());
        Assert.assertTrue((boolean)view.isRunAsInvoker());
    }

    @Test
    public void testRoundTrip() {
        TestConnectorViewDefinition.assertRoundTrip(new ConnectorViewDefinition("test view SQL", Optional.of("test_catalog"), Optional.of("test_schema"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("abc", BigintType.BIGINT.getTypeId(), Optional.of("abc description")), (Object)new ConnectorViewDefinition.ViewColumn("xyz", new ArrayType((Type)VarcharType.createVarcharType((int)32)).getTypeId(), Optional.empty())), Optional.of("comment"), Optional.of("test_owner"), false));
    }

    private static void assertBaseView(ConnectorViewDefinition view) {
        Assert.assertEquals((String)view.getOriginalSql(), (String)"SELECT 42 x");
        Assert.assertEquals((int)view.getColumns().size(), (int)1);
        ConnectorViewDefinition.ViewColumn column = (ConnectorViewDefinition.ViewColumn)Iterables.getOnlyElement((Iterable)view.getColumns());
        Assert.assertEquals((String)column.getName(), (String)"x");
        Assert.assertEquals((Object)column.getType(), (Object)BigintType.BIGINT.getTypeId());
        TestConnectorViewDefinition.assertRoundTrip(view);
    }

    private static void assertRoundTrip(ConnectorViewDefinition expected) {
        ConnectorViewDefinition actual = (ConnectorViewDefinition)CODEC.fromJson(CODEC.toJson((Object)expected));
        Assert.assertEquals((Object)actual.getOwner(), (Object)expected.getOwner());
        Assert.assertEquals((boolean)actual.isRunAsInvoker(), (boolean)expected.isRunAsInvoker());
        Assert.assertEquals((Object)actual.getCatalog(), (Object)expected.getCatalog());
        Assert.assertEquals((Object)actual.getSchema(), (Object)expected.getSchema());
        Assert.assertEquals((String)actual.getOriginalSql(), (String)expected.getOriginalSql());
        ((ListAssert)Assertions.assertThat((List)actual.getColumns()).usingElementComparator(TestConnectorViewDefinition.columnComparator())).isEqualTo((Object)expected.getColumns());
    }

    private static Comparator<ConnectorViewDefinition.ViewColumn> columnComparator() {
        return Comparator.comparing(ConnectorViewDefinition.ViewColumn::getName).thenComparing(column -> column.getType().toString());
    }
}

