/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.testing;

import io.trino.spi.testing.ForwardingInterfaceWithPrivateMethod;
import io.trino.spi.testing.InterfaceTestUtils;
import io.trino.spi.testing.InterfaceWithPrivateMethod;
import java.io.Serializable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestInterfaceTestUtils {
    @Test
    public void testReportUnimplementedInterfaceMethod() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> InterfaceTestUtils.assertAllMethodsOverridden(Interface.class, Implementation.class)).isInstanceOf(AssertionError.class)).hasMessage("io.trino.spi.testing.TestInterfaceTestUtils$Implementation does not override [public default void io.trino.spi.testing.TestInterfaceTestUtils$Interface.foo(java.lang.String)]");
    }

    @Test
    public void testAcceptStaticMethod() {
        InterfaceTestUtils.assertAllMethodsOverridden(InterfaceWithStaticMethod.class, ImplementationOfInterfaceWithStaticMethod.class);
    }

    @Test
    public void testAcceptMultipleImplementedInterfaces() {
        InterfaceTestUtils.assertAllMethodsOverridden(Interface.class, ImplementationWithMultipleInterfaces.class);
    }

    @Test
    public void testAcceptAbstractClass() {
        InterfaceTestUtils.assertAllMethodsOverridden(AbstractClass.class, ImplementationOfAbstractClass.class);
    }

    @Test
    public void testAssertProperForwardingMethodsAreCalledWithPrivateMethods() {
        InterfaceTestUtils.assertProperForwardingMethodsAreCalled(InterfaceWithPrivateMethod.class, ForwardingInterfaceWithPrivateMethod::new);
    }

    private static interface InterfaceWithStaticMethod {
        default public void foo(String s) {
        }

        public static void staticMethod(String s) {
        }
    }

    private static class ImplementationOfInterfaceWithStaticMethod
    implements InterfaceWithStaticMethod {
        private ImplementationOfInterfaceWithStaticMethod() {
        }

        @Override
        public void foo(String s) {
        }
    }

    private static interface Interface {
        default public void foo(String s) {
        }
    }

    private static class ImplementationWithMultipleInterfaces
    implements Cloneable,
    Interface,
    Serializable {
        private ImplementationWithMultipleInterfaces() {
        }

        @Override
        public void foo(String s) {
        }
    }

    private static abstract class AbstractClass {
        private AbstractClass() {
        }

        public void foo(String s) {
        }
    }

    private static class ImplementationOfAbstractClass
    extends AbstractClass {
        private ImplementationOfAbstractClass() {
        }

        @Override
        public void foo(String s) {
        }
    }

    private static class Implementation
    implements Interface {
        private Implementation() {
        }
    }
}

