/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimeZoneNotSupportedException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTimeZoneKey {
    private static final TimeZoneKey PLUS_7_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)420L);
    private static final TimeZoneKey MINUS_7_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)-420L);

    @Test
    public void testUTC() {
        Assert.assertEquals((int)TimeZoneKey.UTC_KEY.getKey(), (int)0);
        Assert.assertEquals((String)TimeZoneKey.UTC_KEY.getId(), (String)"UTC");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((short)0), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Z"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Zulu"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UCT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Universal"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"+00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"-00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"+0000"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"-0000"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-00:00"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UCT"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/Universal"), (Object)TimeZoneKey.UTC_KEY);
    }

    @Test
    public void testHourOffsetZone() {
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("GMT7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-7"), (Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("UT0");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("UT7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UT-7"), (Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("UTC0");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("UTC7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/GMT7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-7"), (Object)PLUS_7_KEY);
        this.assertTimeZoneNotSupported("Etc/UT0");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/UT7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-7"), (Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("Etc/UTC0");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+0"), (Object)TimeZoneKey.UTC_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-0"), (Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/UTC7");
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7:00"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-07:00"), (Object)MINUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7:00"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+07:00"), (Object)PLUS_7_KEY);
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7:35"), (Object)TimeZoneKey.getTimeZoneKeyForOffset((long)-455L));
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-07:35"), (Object)TimeZoneKey.getTimeZoneKeyForOffset((long)-455L));
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7:35"), (Object)TimeZoneKey.getTimeZoneKeyForOffset((long)455L));
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+07:35"), (Object)TimeZoneKey.getTimeZoneKeyForOffset((long)455L));
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"+0735"), (Object)TimeZoneKey.getTimeZoneKeyForOffset((long)455L));
        Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)"-0735"), (Object)TimeZoneKey.getTimeZoneKeyForOffset((long)-455L));
    }

    @Test
    public void testZoneKeyLookup() {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((short)timeZoneKey.getKey()), (Object)timeZoneKey);
            Assert.assertSame((Object)TimeZoneKey.getTimeZoneKey((String)timeZoneKey.getId()), (Object)timeZoneKey);
        }
    }

    @Test
    public void testMaxTimeZoneKey() {
        boolean foundMax = false;
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            Assert.assertTrue((timeZoneKey.getKey() <= TimeZoneKey.MAX_TIME_ZONE_KEY ? 1 : 0) != 0, (String)(timeZoneKey + " key is larger than max key " + TimeZoneKey.MAX_TIME_ZONE_KEY));
            foundMax = foundMax || timeZoneKey.getKey() == TimeZoneKey.MAX_TIME_ZONE_KEY;
        }
        Assert.assertTrue((boolean)foundMax, (String)"Did not find a time zone with the MAX_TIME_ZONE_KEY");
    }

    @Test
    public void testZoneKeyIdRange() {
        boolean[] hasValue = new boolean[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            short key = timeZoneKey.getKey();
            Assert.assertTrue((key >= 0 ? 1 : 0) != 0, (String)(timeZoneKey + " has a negative time zone key"));
            Assert.assertFalse((boolean)hasValue[key], (String)("Another time zone has the same zone key as " + timeZoneKey));
            hasValue[key] = true;
        }
        Assert.assertFalse((boolean)hasValue[2040]);
        hasValue[2040] = true;
        Assert.assertFalse((boolean)hasValue[2180]);
        hasValue[2180] = true;
        Assert.assertFalse((boolean)hasValue[2186]);
        hasValue[2186] = true;
        Assert.assertFalse((boolean)hasValue[2196]);
        hasValue[2196] = true;
        Assert.assertFalse((boolean)hasValue[2174]);
        hasValue[2174] = true;
        for (int i = 0; i < hasValue.length; ++i) {
            Assert.assertTrue((boolean)hasValue[i], (String)("There is no time zone with key " + i));
        }
    }

    @Test
    public void testZoneKeyData() {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        ImmutableSortedSet timeZoneKeysSortedByKey = ImmutableSortedSet.copyOf(Comparator.comparingInt(TimeZoneKey::getKey), (Collection)TimeZoneKey.getTimeZoneKeys());
        for (TimeZoneKey timeZoneKey : timeZoneKeysSortedByKey) {
            hasher.putShort(timeZoneKey.getKey());
            hasher.putString((CharSequence)timeZoneKey.getId(), StandardCharsets.UTF_8);
        }
        Assert.assertEquals((long)hasher.hash().asLong(), (long)4825838578917475630L, (String)"zone-index.properties file contents changed!");
    }

    @Test
    public void testRoundTripSerialization() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        for (TimeZoneKey zoneKey : TimeZoneKey.getTimeZoneKeys()) {
            String json = mapper.writeValueAsString((Object)zoneKey);
            Object value = mapper.readValue(json, zoneKey.getClass());
            Assert.assertEquals((Object)value, (Object)zoneKey);
        }
    }

    private void assertTimeZoneNotSupported(String zoneId) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimeZoneKey.getTimeZoneKey((String)zoneId)).isInstanceOf(TimeZoneNotSupportedException.class)).hasMessageStartingWith("Time zone not supported: ");
    }
}

