/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.TinyintType;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public final class MergePage {
    private final Optional<Page> deletionsPage;
    private final Optional<Page> insertionsPage;

    private MergePage(Optional<Page> deletionsPage, Optional<Page> insertionsPage) {
        this.deletionsPage = Objects.requireNonNull(deletionsPage);
        this.insertionsPage = Objects.requireNonNull(insertionsPage);
    }

    public Optional<Page> getDeletionsPage() {
        return this.deletionsPage;
    }

    public Optional<Page> getInsertionsPage() {
        return this.insertionsPage;
    }

    public static MergePage createDeleteAndInsertPages(Page inputPage, int dataColumnCount) {
        int inputChannelCount = inputPage.getChannelCount();
        if (inputChannelCount != dataColumnCount + 2) {
            throw new IllegalArgumentException(String.format("inputPage channelCount (%s) == dataColumns size (%s) + 2", inputChannelCount, dataColumnCount));
        }
        int positionCount = inputPage.getPositionCount();
        if (positionCount <= 0) {
            throw new IllegalArgumentException("positionCount should be > 0, but is " + positionCount);
        }
        Block operationBlock = inputPage.getBlock(inputChannelCount - 2);
        int[] deletePositions = new int[positionCount];
        int[] insertPositions = new int[positionCount];
        int deletePositionCount = 0;
        int insertPositionCount = 0;
        block4: for (int position = 0; position < positionCount; ++position) {
            int operation = Math.toIntExact(TinyintType.TINYINT.getLong(operationBlock, position));
            switch (operation) {
                case 2: 
                case 5: {
                    deletePositions[deletePositionCount] = position;
                    ++deletePositionCount;
                    continue block4;
                }
                case 1: 
                case 4: {
                    insertPositions[insertPositionCount] = position;
                    ++insertPositionCount;
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Invalid merge operation: " + operation);
                }
            }
        }
        Optional<Page> deletePage = Optional.empty();
        if (deletePositionCount > 0) {
            int[] columns = new int[dataColumnCount + 1];
            for (int i = 0; i < dataColumnCount; ++i) {
                columns[i] = i;
            }
            columns[dataColumnCount] = dataColumnCount + 1;
            deletePage = Optional.of(inputPage.getColumns(columns).getPositions(deletePositions, 0, deletePositionCount));
        }
        Optional<Page> insertPage = Optional.empty();
        if (insertPositionCount > 0) {
            insertPage = Optional.of(inputPage.getColumns(IntStream.range(0, dataColumnCount).toArray()).getPositions(insertPositions, 0, insertPositionCount));
        }
        return new MergePage(deletePage, insertPage);
    }
}

