/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Unstable;
import io.trino.spi.eventlistener.QueryPlanOptimizerStatistics;
import io.trino.spi.eventlistener.StageCpuDistribution;
import io.trino.spi.eventlistener.StageGcStatistics;
import io.trino.spi.eventlistener.StageOutputBufferUtilization;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryStatistics {
    private final Duration cpuTime;
    private final Duration failedCpuTime;
    private final Duration wallTime;
    private final Duration queuedTime;
    private final Optional<Duration> scheduledTime;
    private final Optional<Duration> failedScheduledTime;
    private final Optional<Duration> resourceWaitingTime;
    private final Optional<Duration> analysisTime;
    private final Optional<Duration> planningTime;
    private final Optional<Duration> executionTime;
    private final Optional<Duration> inputBlockedTime;
    private final Optional<Duration> failedInputBlockedTime;
    private final Optional<Duration> outputBlockedTime;
    private final Optional<Duration> failedOutputBlockedTime;
    private final Optional<Duration> physicalInputReadTime;
    private final long peakUserMemoryBytes;
    private final long peakTaskUserMemory;
    private final long peakTaskTotalMemory;
    private final long physicalInputBytes;
    private final long physicalInputRows;
    private final long processedInputBytes;
    private final long processedInputRows;
    private final long internalNetworkBytes;
    private final long internalNetworkRows;
    private final long totalBytes;
    private final long totalRows;
    private final long outputBytes;
    private final long outputRows;
    private final long writtenBytes;
    private final long writtenRows;
    private final long spilledBytes;
    private final double cumulativeMemory;
    private final double failedCumulativeMemory;
    private final List<StageGcStatistics> stageGcStatistics;
    private final int completedSplits;
    private final boolean complete;
    private final List<StageCpuDistribution> cpuTimeDistribution;
    private final List<StageOutputBufferUtilization> outputBufferUtilization;
    private final List<String> operatorSummaries;
    private final List<QueryPlanOptimizerStatistics> optimizerRulesSummaries;
    private final Optional<String> planNodeStatsAndCosts;

    @JsonCreator
    @Unstable
    public QueryStatistics(Duration cpuTime, Duration failedCpuTime, Duration wallTime, Duration queuedTime, Optional<Duration> scheduledTime, Optional<Duration> failedScheduledTime, Optional<Duration> resourceWaitingTime, Optional<Duration> analysisTime, Optional<Duration> planningTime, Optional<Duration> executionTime, Optional<Duration> inputBlockedTime, Optional<Duration> failedInputBlockedTime, Optional<Duration> outputBlockedTime, Optional<Duration> failedOutputBlockedTime, Optional<Duration> physicalInputReadTime, long peakUserMemoryBytes, long peakTaskUserMemory, long peakTaskTotalMemory, long physicalInputBytes, long physicalInputRows, long processedInputBytes, long processedInputRows, long internalNetworkBytes, long internalNetworkRows, long totalBytes, long totalRows, long outputBytes, long outputRows, long writtenBytes, long writtenRows, long spilledBytes, double cumulativeMemory, double failedCumulativeMemory, List<StageGcStatistics> stageGcStatistics, int completedSplits, boolean complete, List<StageCpuDistribution> cpuTimeDistribution, List<StageOutputBufferUtilization> outputBufferUtilization, List<String> operatorSummaries, List<QueryPlanOptimizerStatistics> optimizerRulesSummaries, Optional<String> planNodeStatsAndCosts) {
        this.cpuTime = Objects.requireNonNull(cpuTime, "cpuTime is null");
        this.failedCpuTime = Objects.requireNonNull(failedCpuTime, "failedCpuTime is null");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.scheduledTime = Objects.requireNonNull(scheduledTime, "scheduledTime is null");
        this.failedScheduledTime = Objects.requireNonNull(failedScheduledTime, "failedScheduledTime is null");
        this.resourceWaitingTime = Objects.requireNonNull(resourceWaitingTime, "resourceWaitingTime is null");
        this.analysisTime = Objects.requireNonNull(analysisTime, "analysisTime is null");
        this.planningTime = Objects.requireNonNull(planningTime, "planningTime is null");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.inputBlockedTime = Objects.requireNonNull(inputBlockedTime, "inputBlockedTime is null");
        this.failedInputBlockedTime = Objects.requireNonNull(failedInputBlockedTime, "failedInputBlockedTime is null");
        this.outputBlockedTime = Objects.requireNonNull(outputBlockedTime, "outputBlockedTime is null");
        this.failedOutputBlockedTime = Objects.requireNonNull(failedOutputBlockedTime, "failedOutputBlockedTime is null");
        this.physicalInputReadTime = Objects.requireNonNull(physicalInputReadTime, "physicalInputReadTime is null");
        this.peakUserMemoryBytes = peakUserMemoryBytes;
        this.peakTaskUserMemory = peakTaskUserMemory;
        this.peakTaskTotalMemory = peakTaskTotalMemory;
        this.physicalInputBytes = physicalInputBytes;
        this.physicalInputRows = physicalInputRows;
        this.processedInputBytes = processedInputBytes;
        this.processedInputRows = processedInputRows;
        this.internalNetworkBytes = internalNetworkBytes;
        this.internalNetworkRows = internalNetworkRows;
        this.totalBytes = totalBytes;
        this.totalRows = totalRows;
        this.outputBytes = outputBytes;
        this.outputRows = outputRows;
        this.writtenBytes = writtenBytes;
        this.writtenRows = writtenRows;
        this.spilledBytes = spilledBytes;
        this.cumulativeMemory = cumulativeMemory;
        this.failedCumulativeMemory = failedCumulativeMemory;
        this.stageGcStatistics = Objects.requireNonNull(stageGcStatistics, "stageGcStatistics is null");
        this.completedSplits = completedSplits;
        this.complete = complete;
        this.cpuTimeDistribution = Objects.requireNonNull(cpuTimeDistribution, "cpuTimeDistribution is null");
        this.outputBufferUtilization = Objects.requireNonNull(outputBufferUtilization, "outputBufferUtilization is null");
        this.operatorSummaries = Objects.requireNonNull(operatorSummaries, "operatorSummaries is null");
        this.optimizerRulesSummaries = Objects.requireNonNull(optimizerRulesSummaries, "optimizerRulesSummaries is null");
        this.planNodeStatsAndCosts = Objects.requireNonNull(planNodeStatsAndCosts, "planNodeStatsAndCosts is null");
    }

    @JsonProperty
    public Duration getCpuTime() {
        return this.cpuTime;
    }

    @JsonProperty
    public Duration getFailedCpuTime() {
        return this.failedCpuTime;
    }

    @JsonProperty
    public Duration getWallTime() {
        return this.wallTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Optional<Duration> getScheduledTime() {
        return this.scheduledTime;
    }

    @JsonProperty
    public Optional<Duration> getFailedScheduledTime() {
        return this.failedScheduledTime;
    }

    @JsonProperty
    public Optional<Duration> getResourceWaitingTime() {
        return this.resourceWaitingTime;
    }

    @JsonProperty
    public Optional<Duration> getAnalysisTime() {
        return this.analysisTime;
    }

    @JsonProperty
    public Optional<Duration> getPlanningTime() {
        return this.planningTime;
    }

    @JsonProperty
    public Optional<Duration> getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty
    public Optional<Duration> getInputBlockedTime() {
        return this.inputBlockedTime;
    }

    @JsonProperty
    public Optional<Duration> getFailedInputBlockedTime() {
        return this.failedInputBlockedTime;
    }

    @JsonProperty
    public Optional<Duration> getOutputBlockedTime() {
        return this.outputBlockedTime;
    }

    @JsonProperty
    public Optional<Duration> getFailedOutputBlockedTime() {
        return this.failedOutputBlockedTime;
    }

    @JsonProperty
    public Optional<Duration> getPhysicalInputReadTime() {
        return this.physicalInputReadTime;
    }

    @JsonProperty
    public long getPeakUserMemoryBytes() {
        return this.peakUserMemoryBytes;
    }

    @JsonProperty
    public long getPeakTaskUserMemory() {
        return this.peakTaskUserMemory;
    }

    @JsonProperty
    public long getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory;
    }

    @JsonProperty
    public long getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    @JsonProperty
    public long getPhysicalInputRows() {
        return this.physicalInputRows;
    }

    @JsonProperty
    public long getProcessedInputBytes() {
        return this.processedInputBytes;
    }

    @JsonProperty
    public long getProcessedInputRows() {
        return this.processedInputRows;
    }

    @JsonProperty
    public long getInternalNetworkBytes() {
        return this.internalNetworkBytes;
    }

    @JsonProperty
    public long getInternalNetworkRows() {
        return this.internalNetworkRows;
    }

    @JsonProperty
    public long getTotalBytes() {
        return this.totalBytes;
    }

    @JsonProperty
    public long getTotalRows() {
        return this.totalRows;
    }

    @JsonProperty
    public long getOutputBytes() {
        return this.outputBytes;
    }

    @JsonProperty
    public long getOutputRows() {
        return this.outputRows;
    }

    @JsonProperty
    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    @JsonProperty
    public long getWrittenRows() {
        return this.writtenRows;
    }

    @JsonProperty
    public long getSpilledBytes() {
        return this.spilledBytes;
    }

    @JsonProperty
    public double getCumulativeMemory() {
        return this.cumulativeMemory;
    }

    @JsonProperty
    public double getFailedCumulativeMemory() {
        return this.failedCumulativeMemory;
    }

    @JsonProperty
    public List<StageGcStatistics> getStageGcStatistics() {
        return this.stageGcStatistics;
    }

    @JsonProperty
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @JsonProperty
    public boolean isComplete() {
        return this.complete;
    }

    @JsonProperty
    public List<StageCpuDistribution> getCpuTimeDistribution() {
        return this.cpuTimeDistribution;
    }

    @JsonProperty
    public List<StageOutputBufferUtilization> getOutputBufferUtilization() {
        return this.outputBufferUtilization;
    }

    @JsonProperty
    public List<String> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public List<QueryPlanOptimizerStatistics> getOptimizerRulesSummaries() {
        return this.optimizerRulesSummaries;
    }

    @JsonProperty
    public Optional<String> getPlanNodeStatsAndCosts() {
        return this.planNodeStatsAndCosts;
    }
}

