/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.Fixed12BlockBuilder;

public class Fixed12BlockEncoding
implements BlockEncoding {
    public static final String NAME = "FIXED12";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            sliceOutput.writeBytes(Fixed12BlockEncoding.getValuesSlice(block));
        } else {
            int[] valuesWithoutNull = new int[positionCount * 3];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = block.getInt(i, 0);
                valuesWithoutNull[nonNullPositionCount + 1] = block.getInt(i, 4);
                valuesWithoutNull[nonNullPositionCount + 2] = block.getInt(i, 8);
                if (block.isNull(i)) continue;
                nonNullPositionCount += 3;
            }
            sliceOutput.writeInt(nonNullPositionCount / 3);
            sliceOutput.writeBytes(Slices.wrappedIntArray((int[])valuesWithoutNull, (int)0, (int)nonNullPositionCount));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        int[] values = new int[positionCount * 3];
        if (valueIsNull == null) {
            sliceInput.readBytes(Slices.wrappedIntArray((int[])values));
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readBytes(Slices.wrappedIntArray((int[])values, (int)0, (int)(nonNullPositionCount * 3)));
            int position = 3 * (nonNullPositionCount - 1);
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                System.arraycopy(values, position, values, 3 * i, 3);
                if (valueIsNull[i]) continue;
                position -= 3;
            }
        }
        return new Fixed12Block(0, positionCount, valueIsNull, values);
    }

    private static Slice getValuesSlice(Block block) {
        if (block instanceof Fixed12Block) {
            return ((Fixed12Block)block).getValuesSlice();
        }
        if (block instanceof Fixed12BlockBuilder) {
            return ((Fixed12BlockBuilder)block).getValuesSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }
}

