/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.AbstractMapBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.DuplicateMapKeyException;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.block.SingleMapBlockWriter;
import io.trino.spi.type.MapType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nullable;

public class MapBlockBuilder
extends AbstractMapBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MapBlockBuilder.class);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private int[] offsets;
    private boolean[] mapIsNull;
    private boolean hasNullValue;
    private final BlockBuilder keyBlockBuilder;
    private final BlockBuilder valueBlockBuilder;
    private final MapHashTables hashTables;
    private boolean currentEntryOpened;
    private boolean strict;

    public MapBlockBuilder(MapType mapType, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(mapType, blockBuilderStatus, mapType.getKeyType().createBlockBuilder(blockBuilderStatus, expectedEntries), mapType.getValueType().createBlockBuilder(blockBuilderStatus, expectedEntries), new int[expectedEntries + 1], new boolean[expectedEntries]);
    }

    private MapBlockBuilder(MapType mapType, @Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder, int[] offsets, boolean[] mapIsNull) {
        super(mapType);
        this.blockBuilderStatus = blockBuilderStatus;
        this.positionCount = 0;
        this.offsets = Objects.requireNonNull(offsets, "offsets is null");
        this.mapIsNull = Objects.requireNonNull(mapIsNull, "mapIsNull is null");
        this.keyBlockBuilder = Objects.requireNonNull(keyBlockBuilder, "keyBlockBuilder is null");
        this.valueBlockBuilder = Objects.requireNonNull(valueBlockBuilder, "valueBlockBuilder is null");
        int[] hashTable = new int[mapIsNull.length * 2];
        Arrays.fill(hashTable, -1);
        this.hashTables = new MapHashTables(mapType, Optional.of(hashTable));
    }

    public MapBlockBuilder strict() {
        this.strict = true;
        return this;
    }

    @Override
    protected Block getRawKeyBlock() {
        return this.keyBlockBuilder;
    }

    @Override
    protected Block getRawValueBlock() {
        return this.valueBlockBuilder;
    }

    @Override
    protected MapHashTables getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        return 0;
    }

    @Override
    @Nullable
    protected boolean[] getMapIsNull() {
        return this.hasNullValue ? this.mapIsNull : null;
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullValue;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.keyBlockBuilder.getSizeInBytes() + this.valueBlockBuilder.getSizeInBytes() + 5L * (long)this.positionCount + 8L * (long)this.keyBlockBuilder.getPositionCount();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.mapIsNull) + this.hashTables.getRetainedSizeInBytes();
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.keyBlockBuilder, this.keyBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.valueBlockBuilder, this.valueBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        consumer.accept(this.mapIsNull, SizeOf.sizeOf((boolean[])this.mapIsNull));
        consumer.accept(this.hashTables, this.hashTables.getRetainedSizeInBytes());
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public SingleMapBlockWriter beginBlockEntry() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        return new SingleMapBlockWriter(this.keyBlockBuilder.getPositionCount() * 2, this.keyBlockBuilder, this.valueBlockBuilder, this::strict);
    }

    @Override
    public BlockBuilder closeEntry() {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        this.ensureHashTableSize();
        int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
        int aggregatedEntryCount = this.offsets[this.positionCount];
        int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
        if (this.strict) {
            this.hashTables.buildHashTableStrict(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount);
        } else {
            this.hashTables.buildHashTable(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount);
        }
        return this;
    }

    @Deprecated
    public void closeEntryStrict() throws DuplicateMapKeyException {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        this.ensureHashTableSize();
        int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
        int aggregatedEntryCount = this.offsets[this.positionCount];
        int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
        this.hashTables.buildHashTableStrict(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount);
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.keyBlockBuilder.getPositionCount() != this.valueBlockBuilder.getPositionCount()) {
            throw new IllegalStateException(String.format("keyBlock and valueBlock has different size: %s %s", this.keyBlockBuilder.getPositionCount(), this.valueBlockBuilder.getPositionCount()));
        }
        if (this.mapIsNull.length <= this.positionCount) {
            int newSize = BlockUtil.calculateNewArraySize(this.mapIsNull.length);
            this.mapIsNull = Arrays.copyOf(this.mapIsNull, newSize);
            this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        }
        this.offsets[this.positionCount + 1] = this.keyBlockBuilder.getPositionCount();
        this.mapIsNull[this.positionCount] = isNull;
        this.hasNullValue |= isNull;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
            this.blockBuilderStatus.addBytes((this.offsets[this.positionCount] - this.offsets[this.positionCount - 1]) * 2 * 4);
        }
    }

    private void ensureHashTableSize() {
        int[] rawHashTables = this.hashTables.get();
        if (rawHashTables.length < this.offsets[this.positionCount] * 2) {
            int newSize = BlockUtil.calculateNewArraySize(this.offsets[this.positionCount] * 2);
            this.hashTables.growHashTables(newSize);
        }
    }

    @Override
    public Block build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        int[] rawHashTables = this.hashTables.get();
        int hashTablesEntries = this.offsets[this.positionCount] * 2;
        return MapBlock.createMapBlockInternal(this.getMapType(), 0, this.positionCount, this.hasNullValue ? Optional.of(this.mapIsNull) : Optional.empty(), this.offsets, this.keyBlockBuilder.build(), this.valueBlockBuilder.build(), new MapHashTables(this.getMapType(), Optional.of(Arrays.copyOf(rawHashTables, hashTablesEntries))));
    }

    public String toString() {
        return "MapBlockBuilder{positionCount=" + this.getPositionCount() + "}";
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new MapBlockBuilder(this.getMapType(), blockBuilderStatus, this.keyBlockBuilder.newBlockBuilderLike(blockBuilderStatus), this.valueBlockBuilder.newBlockBuilderLike(blockBuilderStatus), new int[expectedEntries + 1], new boolean[expectedEntries]);
    }

    @Override
    protected void ensureHashTableLoaded() {
    }
}

