/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.Experimental;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.ptf.Descriptor;
import io.trino.spi.ptf.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Experimental(eta="2022-10-31")
public final class TableFunctionAnalysis {
    private final Optional<Descriptor> returnedType;
    private final Map<String, List<Integer>> requiredColumns;
    private final ConnectorTableFunctionHandle handle;

    private TableFunctionAnalysis(Optional<Descriptor> returnedType, Map<String, List<Integer>> requiredColumns, ConnectorTableFunctionHandle handle) {
        this.returnedType = Objects.requireNonNull(returnedType, "returnedType is null");
        returnedType.ifPresent(descriptor -> Preconditions.checkArgument(descriptor.isTyped(), "field types not specified"));
        this.requiredColumns = Map.copyOf(requiredColumns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> List.copyOf((Collection)entry.getValue()))));
        this.handle = Objects.requireNonNull(handle, "handle is null");
    }

    public Optional<Descriptor> getReturnedType() {
        return this.returnedType;
    }

    public Map<String, List<Integer>> getRequiredColumns() {
        return this.requiredColumns;
    }

    public ConnectorTableFunctionHandle getHandle() {
        return this.handle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Descriptor returnedType;
        private final Map<String, List<Integer>> requiredColumns = new HashMap<String, List<Integer>>();
        private ConnectorTableFunctionHandle handle;

        private Builder() {
        }

        public Builder returnedType(Descriptor returnedType) {
            this.returnedType = returnedType;
            return this;
        }

        public Builder requiredColumns(String tableArgument, List<Integer> columns) {
            this.requiredColumns.put(tableArgument, columns);
            return this;
        }

        public Builder handle(ConnectorTableFunctionHandle handle) {
            this.handle = handle;
            return this;
        }

        public TableFunctionAnalysis build() {
            return new TableFunctionAnalysis(Optional.ofNullable(this.returnedType), this.requiredColumns, this.handle);
        }
    }
}

