/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeWithTimeZoneTypes;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;

final class ShortTimeWithTimeZoneType
extends TimeWithTimeZoneType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(ShortTimeWithTimeZoneType.class, MethodHandles.lookup(), Long.TYPE);

    public ShortTimeWithTimeZoneType(int precision) {
        super(precision, Long.TYPE);
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [0, %s]", 9));
        }
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public final int getFixedSize() {
        return 8;
    }

    @Override
    public final long getLong(Block block, int position) {
        return block.getLong(position, 0);
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }

    @Override
    public final void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0)).closeEntry();
        }
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 8));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 8);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long value = block.getLong(position, 0);
        return SqlTimeWithTimeZone.newInstance(this.getPrecision(), DateTimeEncoding.unpackTimeNanos(value) * 1000L, DateTimeEncoding.unpackOffsetMinutes(value));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long leftPackedTime, long rightPackedTime) {
        return TimeWithTimeZoneTypes.normalizePackedTime(leftPackedTime) == TimeWithTimeZoneTypes.normalizePackedTime(rightPackedTime);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long packedTime) {
        return AbstractLongType.hash(TimeWithTimeZoneTypes.normalizePackedTime(packedTime));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long packedTime) {
        return XxHash64.hash((long)TimeWithTimeZoneTypes.normalizePackedTime(packedTime));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(long left, long right) {
        return Long.compare(TimeWithTimeZoneTypes.normalizePackedTime(left), TimeWithTimeZoneTypes.normalizePackedTime(right));
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return TimeWithTimeZoneTypes.normalizePackedTime(left) < TimeWithTimeZoneTypes.normalizePackedTime(right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return TimeWithTimeZoneTypes.normalizePackedTime(left) <= TimeWithTimeZoneTypes.normalizePackedTime(right);
    }
}

