/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.Int2IntOpenHashMap;
import io.trino.spi.block.IntArrayList;
import io.trino.spi.block.RunLengthEncodedBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public class DictionaryBlock
implements Block {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DictionaryBlock.class) + SizeOf.instanceSize(DictionaryId.class);
    private static final int NULL_NOT_FOUND = -1;
    private final int positionCount;
    private final Block dictionary;
    private final int idsOffset;
    private final int[] ids;
    private final long retainedSizeInBytes;
    private volatile long sizeInBytes = -1L;
    private volatile long logicalSizeInBytes = -1L;
    private volatile int uniqueIds = -1;
    private volatile boolean isSequentialIds;
    private final DictionaryId dictionarySourceId;
    private final boolean mayHaveNull;

    public static Block create(int positionCount, Block dictionary, int[] ids) {
        return DictionaryBlock.createInternal(positionCount, dictionary, ids, DictionaryId.randomDictionaryId());
    }

    public static Block createProjectedDictionaryBlock(int positionCount, Block dictionary, int[] ids, DictionaryId dictionarySourceId) {
        return DictionaryBlock.createInternal(positionCount, dictionary, ids, dictionarySourceId);
    }

    private static Block createInternal(int positionCount, Block dictionary, int[] ids, DictionaryId dictionarySourceId) {
        if (positionCount == 0) {
            return dictionary.copyRegion(0, 0);
        }
        if (positionCount == 1) {
            return dictionary.getRegion(ids[0], 1);
        }
        if (dictionary instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock rle = (RunLengthEncodedBlock)dictionary;
            return RunLengthEncodedBlock.create(rle.getValue(), positionCount);
        }
        if (dictionary instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)dictionary;
            int[] newIds = new int[positionCount];
            for (int position = 0; position < positionCount; ++position) {
                newIds[position] = dictionaryBlock.getId(ids[position]);
            }
            dictionary = dictionaryBlock.getDictionary();
            dictionarySourceId = DictionaryId.randomDictionaryId();
            ids = newIds;
        }
        return new DictionaryBlock(0, positionCount, dictionary, ids, false, false, dictionarySourceId);
    }

    DictionaryBlock(int idsOffset, int positionCount, Block dictionary, int[] ids) {
        this(idsOffset, positionCount, dictionary, ids, false, false, DictionaryId.randomDictionaryId());
    }

    private DictionaryBlock(int idsOffset, int positionCount, Block dictionary, int[] ids, boolean dictionaryIsCompacted, boolean isSequentialIds, DictionaryId dictionarySourceId) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        Objects.requireNonNull(ids, "ids is null");
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.idsOffset = idsOffset;
        if (ids.length - idsOffset < positionCount) {
            throw new IllegalArgumentException("ids length is less than positionCount");
        }
        this.positionCount = positionCount;
        this.dictionary = dictionary;
        this.ids = ids;
        this.dictionarySourceId = Objects.requireNonNull(dictionarySourceId, "dictionarySourceId is null");
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])ids);
        boolean bl = this.mayHaveNull = positionCount > 0 && (!dictionary.isLoaded() || dictionary.mayHaveNull());
        if (dictionaryIsCompacted) {
            this.sizeInBytes = dictionary.getSizeInBytes() + 4L * (long)positionCount;
            this.uniqueIds = dictionary.getPositionCount();
        }
        if (isSequentialIds && !dictionaryIsCompacted) {
            throw new IllegalArgumentException("sequential ids flag is only valid for compacted dictionary");
        }
        this.isSequentialIds = isSequentialIds;
    }

    int[] getRawIds() {
        return this.ids;
    }

    int getRawIdsOffset() {
        return this.idsOffset;
    }

    @Override
    public int getSliceLength(int position) {
        return this.dictionary.getSliceLength(this.getId(position));
    }

    @Override
    public byte getByte(int position, int offset) {
        return this.dictionary.getByte(this.getId(position), offset);
    }

    @Override
    public short getShort(int position, int offset) {
        return this.dictionary.getShort(this.getId(position), offset);
    }

    @Override
    public int getInt(int position, int offset) {
        return this.dictionary.getInt(this.getId(position), offset);
    }

    @Override
    public long getLong(int position, int offset) {
        return this.dictionary.getLong(this.getId(position), offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        return this.dictionary.getSlice(this.getId(position), offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        return this.dictionary.getObject(this.getId(position), clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.dictionary.bytesEqual(this.getId(position), offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.dictionary.bytesCompare(this.getId(position), offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.dictionary.writeBytesTo(this.getId(position), offset, length, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.dictionary.equals(this.getId(position), offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        return this.dictionary.hash(this.getId(position), offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.dictionary.compareTo(this.getId(leftPosition), leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        return this.dictionary.getSingleValueBlock(this.getId(position));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        if (this.uniqueIds == this.positionCount) {
            OptionalInt dictionarySizePerPosition = this.dictionary.fixedSizeInBytesPerPosition();
            if (dictionarySizePerPosition.isPresent()) {
                dictionarySizePerPosition = OptionalInt.of(dictionarySizePerPosition.getAsInt() + 4);
            }
            return dictionarySizePerPosition;
        }
        return OptionalInt.empty();
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes == -1L) {
            this.calculateCompactSize();
        }
        return this.sizeInBytes;
    }

    private void calculateCompactSize() {
        int uniqueIds = 0;
        boolean[] used = new boolean[this.dictionary.getPositionCount()];
        boolean isSequentialIds = true;
        int previousPosition = -1;
        for (int i = 0; i < this.positionCount; ++i) {
            int position = this.ids[this.idsOffset + i];
            uniqueIds += used[position] ? 0 : 1;
            used[position] = true;
            if (!isSequentialIds) continue;
            isSequentialIds = previousPosition < position;
            previousPosition = position;
        }
        this.sizeInBytes = this.getSizeInBytesForSelectedPositions(used, uniqueIds, this.positionCount);
        this.uniqueIds = uniqueIds;
        this.isSequentialIds = isSequentialIds;
    }

    @Override
    public long getLogicalSizeInBytes() {
        if (this.logicalSizeInBytes >= 0L) {
            return this.logicalSizeInBytes;
        }
        OptionalInt dictionarySizePerPosition = this.dictionary.fixedSizeInBytesPerPosition();
        if (dictionarySizePerPosition.isPresent()) {
            this.logicalSizeInBytes = (long)dictionarySizePerPosition.getAsInt() * (long)this.getPositionCount();
            return this.logicalSizeInBytes;
        }
        long sizeInBytes = 0L;
        long[] seenSizes = new long[this.dictionary.getPositionCount()];
        Arrays.fill(seenSizes, -1L);
        for (int i = 0; i < this.getPositionCount(); ++i) {
            int position = this.getId(i);
            if (seenSizes[position] < 0L) {
                seenSizes[position] = this.dictionary.getRegionSizeInBytes(position, 1);
            }
            sizeInBytes += seenSizes[position];
        }
        this.logicalSizeInBytes = sizeInBytes;
        return sizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int positionOffset, int length) {
        if (positionOffset == 0 && length == this.getPositionCount()) {
            return this.getSizeInBytes();
        }
        OptionalInt fixedSizeInBytesPerPosition = this.fixedSizeInBytesPerPosition();
        if (fixedSizeInBytesPerPosition.isPresent()) {
            return (long)fixedSizeInBytesPerPosition.getAsInt() * (long)length;
        }
        int uniqueIds = 0;
        boolean[] used = new boolean[this.dictionary.getPositionCount()];
        int startOffset = this.idsOffset + positionOffset;
        for (int i = 0; i < length; ++i) {
            int id = this.ids[startOffset + i];
            uniqueIds += used[id] ? 0 : 1;
            used[id] = true;
        }
        return this.getSizeInBytesForSelectedPositions(used, uniqueIds, length);
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        BlockUtil.checkValidPositions(positions, this.positionCount);
        if (selectedPositionsCount == 0) {
            return 0L;
        }
        if (selectedPositionsCount == this.positionCount) {
            return this.getSizeInBytes();
        }
        OptionalInt fixedSizeInBytesPerPosition = this.fixedSizeInBytesPerPosition();
        if (fixedSizeInBytesPerPosition.isPresent()) {
            return (long)fixedSizeInBytesPerPosition.getAsInt() * (long)selectedPositionsCount;
        }
        int uniqueIds = 0;
        boolean[] used = new boolean[this.dictionary.getPositionCount()];
        for (int i = 0; i < positions.length; ++i) {
            int id = this.ids[this.idsOffset + i];
            if (!positions[i]) continue;
            uniqueIds += used[id] ? 0 : 1;
            used[id] = true;
        }
        return this.getSizeInBytesForSelectedPositions(used, uniqueIds, selectedPositionsCount);
    }

    private long getSizeInBytesForSelectedPositions(boolean[] usedIds, int uniqueIds, int selectedPositions) {
        long dictionarySize = this.dictionary.getPositionsSizeInBytes(usedIds, uniqueIds);
        if (uniqueIds == this.dictionary.getPositionCount() && this.sizeInBytes == -1L) {
            this.uniqueIds = uniqueIds;
            this.sizeInBytes = dictionarySize + 4L * (long)this.positionCount;
        }
        return dictionarySize + 4L * (long)selectedPositions;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + this.dictionary.getRetainedSizeInBytes();
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.dictionary.getEstimatedDataSizeForStats(this.getId(position));
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.dictionary, this.dictionary.getRetainedSizeInBytes());
        consumer.accept(this.ids, SizeOf.sizeOf((int[])this.ids));
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public String getEncodingName() {
        return "DICTIONARY";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        if (length <= 1 || this.uniqueIds == this.positionCount) {
            int[] positionsToCopy = new int[length];
            for (int i = 0; i < length; ++i) {
                positionsToCopy[i] = this.getId(positions[offset + i]);
            }
            return this.dictionary.copyPositions(positionsToCopy, 0, length);
        }
        IntArrayList positionsToCopy = new IntArrayList();
        Int2IntOpenHashMap oldIndexToNewIndex = new Int2IntOpenHashMap(Math.min(length, this.dictionary.getPositionCount()));
        int[] newIds = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            int oldIndex = this.getId(position);
            int newId = oldIndexToNewIndex.putIfAbsent(oldIndex, positionsToCopy.size());
            if (newId == -1) {
                newId = positionsToCopy.size();
                positionsToCopy.add(oldIndex);
            }
            newIds[i] = newId;
        }
        Block compactDictionary = this.dictionary.copyPositions(positionsToCopy.elements(), 0, positionsToCopy.size());
        if (positionsToCopy.size() == length) {
            return compactDictionary;
        }
        return new DictionaryBlock(0, length, compactDictionary, newIds, true, false, DictionaryId.randomDictionaryId());
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.positionCount, positionOffset, length);
        if (length == this.positionCount) {
            return this;
        }
        return new DictionaryBlock(this.idsOffset + positionOffset, length, this.dictionary, this.ids, false, false, this.dictionarySourceId);
    }

    @Override
    public Block copyRegion(int position, int length) {
        BlockUtil.checkValidRegion(this.positionCount, position, length);
        int uniqueIds = this.uniqueIds;
        if (length <= 1 || uniqueIds == this.dictionary.getPositionCount() && this.isSequentialIds) {
            return this.dictionary.copyRegion(this.getId(position), length);
        }
        if (uniqueIds == this.positionCount) {
            return this.dictionary.copyPositions(this.ids, this.idsOffset + position, length);
        }
        int[] newIds = Arrays.copyOfRange(this.ids, this.idsOffset + position, this.idsOffset + position + length);
        DictionaryBlock dictionaryBlock = new DictionaryBlock(0, newIds.length, this.dictionary, newIds, false, false, DictionaryId.randomDictionaryId());
        return dictionaryBlock.compact();
    }

    @Override
    public boolean mayHaveNull() {
        return this.mayHaveNull && this.dictionary.mayHaveNull();
    }

    @Override
    public boolean isNull(int position) {
        if (!this.mayHaveNull) {
            return false;
        }
        BlockUtil.checkValidPosition(position, this.positionCount);
        return this.dictionary.isNull(this.getIdUnchecked(position));
    }

    @Override
    public Block getPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newIds = new int[length];
        boolean isCompact = length >= this.dictionary.getPositionCount() && this.isCompact();
        boolean[] usedIds = isCompact ? new boolean[this.dictionary.getPositionCount()] : null;
        int uniqueIds = 0;
        for (int i = 0; i < length; ++i) {
            int id;
            newIds[i] = id = this.getId(positions[offset + i]);
            if (usedIds == null) continue;
            uniqueIds += usedIds[id] ? 0 : 1;
            usedIds[id] = true;
        }
        DictionaryBlock result = new DictionaryBlock(0, newIds.length, this.dictionary, newIds, isCompact &= usedIds != null && usedIds.length == uniqueIds, false, this.getDictionarySourceId());
        if (usedIds != null && !isCompact) {
            result.uniqueIds = uniqueIds;
            result.sizeInBytes = this.dictionary.getPositionsSizeInBytes(usedIds, uniqueIds) + 4L * (long)length;
        }
        return result;
    }

    @Override
    public Block copyWithAppendedNull() {
        int desiredLength = this.idsOffset + this.positionCount + 1;
        int[] newIds = Arrays.copyOf(this.ids, desiredLength);
        Block newDictionary = this.dictionary;
        int nullIndex = -1;
        if (this.dictionary.mayHaveNull()) {
            int dictionaryPositionCount = this.dictionary.getPositionCount();
            for (int i = 0; i < dictionaryPositionCount; ++i) {
                if (!this.dictionary.isNull(i)) continue;
                nullIndex = i;
                break;
            }
        }
        if (nullIndex == -1) {
            newIds[this.idsOffset + this.positionCount] = this.dictionary.getPositionCount();
            newDictionary = this.dictionary.copyWithAppendedNull();
        } else {
            newIds[this.idsOffset + this.positionCount] = nullIndex;
        }
        return new DictionaryBlock(this.idsOffset, this.positionCount + 1, newDictionary, newIds, this.isCompact(), false, this.getDictionarySourceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DictionaryBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isLoaded() {
        return this.dictionary.isLoaded();
    }

    @Override
    public Block getLoadedBlock() {
        Block loadedDictionary = this.dictionary.getLoadedBlock();
        if (loadedDictionary == this.dictionary) {
            return this;
        }
        return new DictionaryBlock(this.idsOffset, this.getPositionCount(), loadedDictionary, this.ids, false, false, DictionaryId.randomDictionaryId());
    }

    @Override
    public final List<Block> getChildren() {
        return Collections.singletonList(this.getDictionary());
    }

    public Block getDictionary() {
        return this.dictionary;
    }

    Slice getIds() {
        return Slices.wrappedIntArray((int[])this.ids, (int)this.idsOffset, (int)this.positionCount);
    }

    boolean isSequentialIds() {
        if (this.uniqueIds == -1) {
            this.calculateCompactSize();
        }
        return this.isSequentialIds;
    }

    int getUniqueIds() {
        if (this.uniqueIds == -1) {
            this.calculateCompactSize();
        }
        return this.uniqueIds;
    }

    public int getId(int position) {
        BlockUtil.checkValidPosition(position, this.positionCount);
        return this.getIdUnchecked(position);
    }

    private int getIdUnchecked(int position) {
        return this.ids[position + this.idsOffset];
    }

    public DictionaryId getDictionarySourceId() {
        return this.dictionarySourceId;
    }

    public boolean isCompact() {
        if (this.uniqueIds == -1) {
            this.calculateCompactSize();
        }
        return this.uniqueIds == this.dictionary.getPositionCount();
    }

    public DictionaryBlock compact() {
        if (this.isCompact()) {
            return this;
        }
        int dictionarySize = this.dictionary.getPositionCount();
        IntArrayList dictionaryPositionsToCopy = new IntArrayList(Math.min(dictionarySize, this.positionCount));
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int newIndex = 0;
        for (int i = 0; i < this.positionCount; ++i) {
            int dictionaryIndex = this.getId(i);
            if (remapIndex[dictionaryIndex] != -1) continue;
            dictionaryPositionsToCopy.add(dictionaryIndex);
            remapIndex[dictionaryIndex] = newIndex++;
        }
        if (dictionaryPositionsToCopy.size() == dictionarySize) {
            return this;
        }
        int[] newIds = new int[this.positionCount];
        for (int i = 0; i < this.positionCount; ++i) {
            int newId = remapIndex[this.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        try {
            Block compactDictionary = this.dictionary.copyPositions(dictionaryPositionsToCopy.elements(), 0, dictionaryPositionsToCopy.size());
            return new DictionaryBlock(0, this.positionCount, compactDictionary, newIds, true, this.uniqueIds == this.positionCount, DictionaryId.randomDictionaryId());
        }
        catch (UnsupportedOperationException e) {
            return this;
        }
    }

    public static List<DictionaryBlock> compactRelatedBlocks(List<DictionaryBlock> blocks) {
        DictionaryBlock firstDictionaryBlock = blocks.get(0);
        Block dictionary = firstDictionaryBlock.getDictionary();
        int positionCount = firstDictionaryBlock.getPositionCount();
        int dictionarySize = dictionary.getPositionCount();
        int[] dictionaryPositionsToCopy = new int[Math.min(dictionarySize, positionCount)];
        int[] remapIndex = new int[dictionarySize];
        Arrays.fill(remapIndex, -1);
        int numberOfIndexes = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = firstDictionaryBlock.getId(i);
            if (remapIndex[position] != -1) continue;
            dictionaryPositionsToCopy[numberOfIndexes] = position;
            remapIndex[position] = numberOfIndexes++;
        }
        if (numberOfIndexes == dictionarySize) {
            return blocks;
        }
        int[] newIds = DictionaryBlock.getNewIds(positionCount, firstDictionaryBlock, remapIndex);
        ArrayList<DictionaryBlock> outputDictionaryBlocks = new ArrayList<DictionaryBlock>(blocks.size());
        DictionaryId newDictionaryId = DictionaryId.randomDictionaryId();
        for (DictionaryBlock dictionaryBlock : blocks) {
            if (!firstDictionaryBlock.getDictionarySourceId().equals(dictionaryBlock.getDictionarySourceId())) {
                throw new IllegalArgumentException("dictionarySourceIds must be the same");
            }
            try {
                Block compactDictionary = dictionaryBlock.getDictionary().copyPositions(dictionaryPositionsToCopy, 0, numberOfIndexes);
                outputDictionaryBlocks.add(new DictionaryBlock(0, positionCount, compactDictionary, newIds, !(compactDictionary instanceof DictionaryBlock), false, newDictionaryId));
            }
            catch (UnsupportedOperationException e) {
                outputDictionaryBlocks.add(dictionaryBlock);
            }
        }
        return outputDictionaryBlocks;
    }

    private static int[] getNewIds(int positionCount, DictionaryBlock dictionaryBlock, int[] remapIndex) {
        int[] newIds = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int newId = remapIndex[dictionaryBlock.getId(i)];
            if (newId == -1) {
                throw new IllegalStateException("reference to a non-existent key");
            }
            newIds[i] = newId;
        }
        return newIds;
    }
}

