/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nullable;

public class Fixed12BlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Fixed12BlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new Fixed12Block(0, 1, new boolean[]{true}, new int[3]);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] values = new int[0];
    private long retainedSizeInBytes;
    private int entryPositionCount;

    public Fixed12BlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public BlockBuilder writeLong(long value) {
        if (this.entryPositionCount != 0) {
            throw new IllegalArgumentException("long can only be written at the beginning of the entry");
        }
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        Fixed12Block.encodeFirst(value, this.values, this.positionCount);
        this.entryPositionCount += 2;
        this.hasNonNullValue = true;
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount * 3 + this.entryPositionCount] = value;
        ++this.entryPositionCount;
        this.hasNonNullValue = true;
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        if (this.entryPositionCount != 3) {
            throw new IllegalStateException("Expected entry size to be exactly 12 bytes but was " + this.entryPositionCount * 4);
        }
        ++this.positionCount;
        this.entryPositionCount = 0;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(13);
        }
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.entryPositionCount != 0) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(13);
        }
        return this;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new Fixed12Block(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new Fixed12BlockBuilder(blockBuilderStatus, expectedEntries);
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize * 3);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(13);
    }

    @Override
    public long getSizeInBytes() {
        return 13L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 13L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        return 13L * (long)selectedPositionsCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 12L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((int[])this.values));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getLong(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be 0");
        }
        return Fixed12Block.decodeFixed12First(this.values, position);
    }

    @Override
    public int getInt(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        if (offset == 0) {
            return this.values[position * 3];
        }
        if (offset == 4) {
            return this.values[position * 3 + 1];
        }
        if (offset == 8) {
            return this.values[position * 3 + 2];
        }
        throw new IllegalArgumentException("offset must be 0, 4, or 8");
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullValue;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull[position];
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        int index = position * 3;
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new Fixed12Block(0, 1, blArray, new int[]{this.values[index], this.values[index + 1], this.values[index + 2]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = new boolean[length];
        }
        int[] newValues = new int[length * 3];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            BlockUtil.checkReadablePosition(this, position);
            if (newValueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position];
            }
            int valuesIndex = position * 3;
            int newValuesIndex = i * 3;
            newValues[newValuesIndex] = this.values[valuesIndex];
            newValues[newValuesIndex + 1] = this.values[valuesIndex + 1];
            newValues[newValuesIndex + 2] = this.values[valuesIndex + 2];
        }
        return new Fixed12Block(0, length, newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        return new Fixed12Block(positionOffset, length, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        }
        int[] newValues = BlockUtil.compactArray(this.values, positionOffset * 3, length * 3);
        return new Fixed12Block(0, length, newValueIsNull, newValues);
    }

    @Override
    public String getEncodingName() {
        return "FIXED12";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Fixed12BlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    Slice getValuesSlice() {
        return Slices.wrappedIntArray((int[])this.values, (int)0, (int)(this.positionCount * 3));
    }
}

