/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.ptf;

import io.trino.spi.Experimental;
import io.trino.spi.Page;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Experimental(eta="2023-07-31")
public interface TableFunctionProcessorState {

    public static final class Processed
    implements TableFunctionProcessorState {
        private final boolean usedInput;
        private final Page result;

        private Processed(boolean usedInput, @Nullable Page result) {
            this.usedInput = usedInput;
            this.result = result;
        }

        public static Processed usedInput() {
            return new Processed(true, null);
        }

        public static Processed produced(Page result) {
            Objects.requireNonNull(result, "result is null");
            return new Processed(false, result);
        }

        public static Processed usedInputAndProduced(Page result) {
            Objects.requireNonNull(result, "result is null");
            return new Processed(true, result);
        }

        public boolean isUsedInput() {
            return this.usedInput;
        }

        public Page getResult() {
            return this.result;
        }
    }

    public static final class Finished
    implements TableFunctionProcessorState {
        public static final Finished FINISHED = new Finished();

        private Finished() {
        }
    }

    public static final class Blocked
    implements TableFunctionProcessorState {
        private final CompletableFuture<Void> future;

        private Blocked(CompletableFuture<Void> future) {
            this.future = Objects.requireNonNull(future, "future is null");
        }

        public static Blocked blocked(CompletableFuture<Void> future) {
            return new Blocked(future);
        }

        public CompletableFuture<Void> getFuture() {
            return this.future;
        }
    }
}

