/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.Preconditions;
import io.trino.spi.type.TypeId;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class ConnectorMaterializedViewDefinition {
    private final String originalSql;
    private final Optional<CatalogSchemaTableName> storageTable;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final List<Column> columns;
    private final Optional<Duration> gracePeriod;
    private final Optional<String> comment;
    private final Optional<String> owner;
    private final Map<String, Object> properties;

    @Deprecated
    public ConnectorMaterializedViewDefinition(String originalSql, Optional<CatalogSchemaTableName> storageTable, Optional<String> catalog, Optional<String> schema, List<Column> columns, Optional<String> comment, Optional<String> owner, Map<String, Object> properties) {
        this(originalSql, storageTable, catalog, schema, columns, Optional.of(Duration.ZERO), comment, owner, properties);
    }

    public ConnectorMaterializedViewDefinition(String originalSql, Optional<CatalogSchemaTableName> storageTable, Optional<String> catalog, Optional<String> schema, List<Column> columns, Optional<Duration> gracePeriod, Optional<String> comment, Optional<String> owner, Map<String, Object> properties) {
        this.originalSql = Objects.requireNonNull(originalSql, "originalSql is null");
        this.storageTable = Objects.requireNonNull(storageTable, "storageTable is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.columns = List.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        Preconditions.checkArgument(gracePeriod.isEmpty() || !gracePeriod.get().isNegative(), "gracePeriod cannot be negative: %s", gracePeriod);
        this.gracePeriod = gracePeriod;
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.properties = Objects.requireNonNull(properties, "properties are null");
        if (catalog.isEmpty() && schema.isPresent()) {
            throw new IllegalArgumentException("catalog must be present if schema is present");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("columns list is empty");
        }
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public Optional<CatalogSchemaTableName> getStorageTable() {
        return this.storageTable;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Optional<Duration> getGracePeriod() {
        return this.gracePeriod;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Optional<String> getOwner() {
        return this.owner;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        joiner.add("originalSql=[" + this.originalSql + "]");
        this.storageTable.ifPresent(value -> joiner.add("storageTable=" + value));
        this.catalog.ifPresent(value -> joiner.add("catalog=" + value));
        this.schema.ifPresent(value -> joiner.add("schema=" + value));
        joiner.add("columns=" + this.columns);
        this.gracePeriod.ifPresent(value -> joiner.add("gracePeriod=" + this.gracePeriod));
        this.comment.ifPresent(value -> joiner.add("comment=" + value));
        joiner.add("owner=" + this.owner);
        joiner.add("properties=" + this.properties);
        return this.getClass().getSimpleName() + joiner.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorMaterializedViewDefinition that = (ConnectorMaterializedViewDefinition)o;
        return Objects.equals(this.originalSql, that.originalSql) && Objects.equals(this.storageTable, that.storageTable) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.schema, that.schema) && Objects.equals(this.columns, that.columns) && Objects.equals(this.gracePeriod, that.gracePeriod) && Objects.equals(this.comment, that.comment) && Objects.equals(this.owner, that.owner) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.originalSql, this.storageTable, this.catalog, this.schema, this.columns, this.gracePeriod, this.comment, this.owner, this.properties);
    }

    public static final class Column {
        private final String name;
        private final TypeId type;

        public Column(String name, TypeId type) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public String getName() {
            return this.name;
        }

        public TypeId getType() {
            return this.type;
        }

        public String toString() {
            return this.name + " " + this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            return Objects.equals(this.name, column.name) && Objects.equals(this.type, column.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

