/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Experimental;
import io.trino.spi.function.table.Argument;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.Type;
import java.util.Objects;
import javax.annotation.Nullable;

@Experimental(eta="2022-10-31")
public class ScalarArgument
extends Argument {
    private final Type type;
    @Nullable
    private final Object value;

    public ScalarArgument(Type type, Object value) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @JsonCreator
    public static ScalarArgument fromNullableValue(@JsonProperty(value="nullableValue") NullableValue nullableValue) {
        return new ScalarArgument(nullableValue.getType(), nullableValue.getValue());
    }

    @JsonProperty
    public NullableValue getNullableValue() {
        return new NullableValue(this.type, this.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Type type;
        private Object value;

        private Builder() {
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public ScalarArgument build() {
            return new ScalarArgument(this.type, this.value);
        }
    }
}

