/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.AllOrNone;
import io.trino.spi.predicate.DiscreteValues;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.ToStringSession;
import io.trino.spi.predicate.Utils;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.predicate.ValuesProcessor;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class SortedRangeSet
implements ValueSet {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SortedRangeSet.class);
    private final Type type;
    private final MethodHandle equalOperator;
    private final MethodHandle hashCodeOperator;
    private final MethodHandle comparisonOperator;
    private final MethodHandle rangeComparisonOperator;
    private final boolean[] inclusive;
    private final Block sortedRanges;
    private int lazyHash;

    private SortedRangeSet(Type type, boolean[] inclusive, Block sortedRanges) {
        Objects.requireNonNull(type, "type is null");
        if (!type.isOrderable()) {
            throw new IllegalArgumentException("Type is not orderable: " + type);
        }
        this.type = type;
        this.equalOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getEqualOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.DEFAULT_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        this.hashCodeOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getHashCodeOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        this.comparisonOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        this.rangeComparisonOperator = Range.getComparisonOperator(type);
        Objects.requireNonNull(inclusive, "inclusive is null");
        Objects.requireNonNull(sortedRanges, "sortedRanges is null");
        if (inclusive.length % 2 != 0) {
            throw new IllegalArgumentException("Malformed inclusive markers");
        }
        if (inclusive.length != sortedRanges.getPositionCount()) {
            throw new IllegalArgumentException(String.format("Size mismatch between inclusive markers and sortedRanges block: %s, %s", inclusive.length, sortedRanges.getPositionCount()));
        }
        for (int position = 0; position < sortedRanges.getPositionCount(); ++position) {
            if (!sortedRanges.isNull(position)) continue;
            if (inclusive[position]) {
                throw new IllegalArgumentException("Invalid inclusive marker for null value at position " + position);
            }
            if (position == 0 || position == sortedRanges.getPositionCount() - 1) continue;
            throw new IllegalArgumentException(String.format("Invalid null value at position %s of %s", position, sortedRanges.getPositionCount()));
        }
        this.inclusive = inclusive;
        this.sortedRanges = sortedRanges;
    }

    static SortedRangeSet none(Type type) {
        return new SortedRangeSet(type, new boolean[0], type.createBlockBuilder(null, 0).build());
    }

    static SortedRangeSet all(Type type) {
        return new SortedRangeSet(type, new boolean[]{false, false}, type.createBlockBuilder(null, 2).appendNull().appendNull().build());
    }

    @Deprecated
    @JsonCreator
    public static SortedRangeSet fromJson(@JsonProperty(value="type") Type type, @JsonProperty(value="inclusive") boolean[] inclusive, @JsonProperty(value="sortedRanges") Block sortedRanges) {
        if (sortedRanges instanceof BlockBuilder) {
            throw new IllegalArgumentException("sortedRanges must be a block: " + sortedRanges);
        }
        return new SortedRangeSet(type, (boolean[])inclusive.clone(), sortedRanges);
    }

    static SortedRangeSet of(Type type, Object first, Object ... rest) {
        if (rest.length == 0) {
            return SortedRangeSet.of(type, first);
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1 + rest.length);
        SortedRangeSet.checkNotNaN(type, first);
        TypeUtils.writeNativeValue(type, blockBuilder, first);
        for (Object value : rest) {
            SortedRangeSet.checkNotNaN(type, value);
            TypeUtils.writeNativeValue(type, blockBuilder, value);
        }
        Block block = blockBuilder.build();
        return SortedRangeSet.fromUnorderedValuesBlock(type, block);
    }

    static SortedRangeSet of(Type type, Collection<?> values) {
        if (values.isEmpty()) {
            return SortedRangeSet.none(type);
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, values.size());
        for (Object value : values) {
            SortedRangeSet.checkNotNaN(type, value);
            TypeUtils.writeNativeValue(type, blockBuilder, value);
        }
        Block block = blockBuilder.build();
        return SortedRangeSet.fromUnorderedValuesBlock(type, block);
    }

    private static SortedRangeSet fromUnorderedValuesBlock(Type type, Block block) {
        MethodHandle comparisonOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        ArrayList<Integer> indexes = new ArrayList<Integer>(block.getPositionCount());
        for (int position = 0; position < block.getPositionCount(); ++position) {
            indexes.add(position);
        }
        indexes.sort((left, right) -> SortedRangeSet.compareValues(comparisonOperator, block, left, block, right));
        int[] dictionary = new int[block.getPositionCount() * 2];
        dictionary[0] = (Integer)indexes.get(0);
        dictionary[1] = (Integer)indexes.get(0);
        int dictionaryIndex = 2;
        for (int i = 1; i < indexes.size(); ++i) {
            int compare = SortedRangeSet.compareValues(comparisonOperator, block, (Integer)indexes.get(i - 1), block, (Integer)indexes.get(i));
            if (compare > 0) {
                throw new IllegalStateException("Values not sorted");
            }
            if (compare == 0) continue;
            dictionary[dictionaryIndex] = (Integer)indexes.get(i);
            dictionary[++dictionaryIndex] = (Integer)indexes.get(i);
            ++dictionaryIndex;
        }
        boolean[] inclusive = new boolean[dictionaryIndex];
        Arrays.fill(inclusive, true);
        return new SortedRangeSet(type, inclusive, DictionaryBlock.create(dictionaryIndex, block, dictionary));
    }

    static SortedRangeSet of(Range first, Range ... rest) {
        if (rest.length == 0 && first.isSingleValue()) {
            return SortedRangeSet.of(first.getType(), first.getSingleValue());
        }
        ArrayList<Range> rangeList = new ArrayList<Range>(rest.length + 1);
        rangeList.add(first);
        rangeList.addAll(Arrays.asList(rest));
        return SortedRangeSet.copyOf(first.getType(), rangeList);
    }

    static SortedRangeSet of(List<Range> rangeList) {
        if (rangeList.isEmpty()) {
            throw new IllegalArgumentException("cannot use empty rangeList");
        }
        return SortedRangeSet.copyOf(rangeList.get(0).getType(), rangeList);
    }

    private static SortedRangeSet of(Type type, Object value) {
        SortedRangeSet.checkNotNaN(type, value);
        Block block = Utils.nativeValueToBlock(type, value);
        return new SortedRangeSet(type, new boolean[]{true, true}, RunLengthEncodedBlock.create(block, 2));
    }

    static SortedRangeSet copyOf(Type type, Collection<Range> ranges) {
        return SortedRangeSet.buildFromUnsortedRanges(type, ranges);
    }

    public static SortedRangeSet copyOf(Type type, List<Range> ranges) {
        return SortedRangeSet.copyOf(type, ranges);
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean[] getInclusive() {
        return this.inclusive;
    }

    @JsonProperty
    public Block getSortedRanges() {
        return this.sortedRanges;
    }

    public List<Range> getOrderedRanges() {
        ArrayList<Range> ranges = new ArrayList<Range>(this.getRangeCount());
        for (int rangeIndex = 0; rangeIndex < this.getRangeCount(); ++rangeIndex) {
            ranges.add(this.getRange(rangeIndex));
        }
        return Collections.unmodifiableList(ranges);
    }

    public int getRangeCount() {
        return this.inclusive.length / 2;
    }

    @Override
    public boolean isNone() {
        return this.getRangeCount() == 0;
    }

    @Override
    public boolean isAll() {
        if (this.getRangeCount() != 1) {
            return false;
        }
        return this.isRangeLowUnbounded(0) && this.isRangeHighUnbounded(0);
    }

    @Override
    public boolean isSingleValue() {
        return this.getRangeCount() == 1 && this.getRangeView(0).isSingleValue();
    }

    @Override
    public Object getSingleValue() {
        Optional<Object> singleValue;
        if (this.getRangeCount() == 1 && (singleValue = this.getRangeView(0).getSingleValue()).isPresent()) {
            return singleValue.get();
        }
        throw new IllegalStateException("SortedRangeSet does not have just a single value");
    }

    @Override
    public boolean isDiscreteSet() {
        for (int i = 0; i < this.getRangeCount(); ++i) {
            if (this.getRangeView(i).isSingleValue()) continue;
            return false;
        }
        return !this.isNone();
    }

    @Override
    public List<Object> getDiscreteSet() {
        ArrayList<Object> values = new ArrayList<Object>(this.getRangeCount());
        for (int rangeIndex = 0; rangeIndex < this.getRangeCount(); ++rangeIndex) {
            RangeView range = this.getRangeView(rangeIndex);
            values.add(range.getSingleValue().orElseThrow(() -> new IllegalStateException("SortedRangeSet is not a discrete set")));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value, "value is null");
        if (TypeUtils.isFloatingPointNaN(this.type, value)) {
            return this.isAll();
        }
        if (this.isNone()) {
            return false;
        }
        Block valueAsBlock = Utils.nativeValueToBlock(this.type, value);
        RangeView valueRange = new RangeView(this.type, this.comparisonOperator, this.rangeComparisonOperator, true, valueAsBlock, 0, true, valueAsBlock, 0);
        int lowRangeIndex = 0;
        int highRangeIndex = this.getRangeCount();
        while (lowRangeIndex + 1 < highRangeIndex) {
            int midRangeIndex = lowRangeIndex + highRangeIndex >>> 1;
            int compare = this.getRangeView(midRangeIndex).compareLowBound(valueRange);
            if (compare <= 0) {
                lowRangeIndex = midRangeIndex;
                continue;
            }
            highRangeIndex = midRangeIndex;
        }
        return this.getRangeView(lowRangeIndex).overlaps(valueRange);
    }

    public Range getSpan() {
        if (this.isNone()) {
            throw new IllegalStateException("Cannot get span if no ranges exist");
        }
        int lastIndex = (this.getRangeCount() - 1) * 2 + 1;
        return new RangeView(this.type, this.comparisonOperator, this.rangeComparisonOperator, this.inclusive[0], this.sortedRanges, 0, this.inclusive[lastIndex], this.sortedRanges, lastIndex).toRange();
    }

    private Range getRange(int rangeIndex) {
        return this.getRangeView(rangeIndex).toRange();
    }

    private RangeView getRangeView(int rangeIndex) {
        int rangeLeft = 2 * rangeIndex;
        int rangeRight = 2 * rangeIndex + 1;
        return new RangeView(this.type, this.comparisonOperator, this.rangeComparisonOperator, this.inclusive[rangeLeft], this.sortedRanges, rangeLeft, this.inclusive[rangeRight], this.sortedRanges, rangeRight);
    }

    private boolean isRangeLowUnbounded(int rangeIndex) {
        return this.sortedRanges.isNull(2 * rangeIndex);
    }

    private boolean isRangeHighUnbounded(int rangeIndex) {
        return this.sortedRanges.isNull(2 * rangeIndex + 1);
    }

    @Override
    public Ranges getRanges() {
        return new Ranges(){

            @Override
            public int getRangeCount() {
                return SortedRangeSet.this.getRangeCount();
            }

            @Override
            public List<Range> getOrderedRanges() {
                return SortedRangeSet.this.getOrderedRanges();
            }

            @Override
            public Range getSpan() {
                return SortedRangeSet.this.getSpan();
            }
        };
    }

    @Override
    public ValuesProcessor getValuesProcessor() {
        return new ValuesProcessor(){

            @Override
            public <T> T transform(Function<Ranges, T> rangesFunction, Function<DiscreteValues, T> valuesFunction, Function<AllOrNone, T> allOrNoneFunction) {
                return rangesFunction.apply(SortedRangeSet.this.getRanges());
            }

            @Override
            public void consume(Consumer<Ranges> rangesConsumer, Consumer<DiscreteValues> valuesConsumer, Consumer<AllOrNone> allOrNoneConsumer) {
                rangesConsumer.accept(SortedRangeSet.this.getRanges());
            }
        };
    }

    @Override
    public SortedRangeSet intersect(ValueSet other) {
        SortedRangeSet that = this.checkCompatibility(other);
        if (this.isNone()) {
            return this;
        }
        if (that.isNone()) {
            return that;
        }
        int thisRangeCount = this.getRangeCount();
        int thatRangeCount = that.getRangeCount();
        boolean[] inclusive = new boolean[2 * (thisRangeCount + thatRangeCount)];
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 2 * (thisRangeCount + thatRangeCount));
        int resultRangeIndex = 0;
        int thisNextRangeIndex = 0;
        int thatNextRangeIndex = 0;
        while (thisNextRangeIndex < thisRangeCount && thatNextRangeIndex < thatRangeCount) {
            int compare;
            RangeView thatCurrent;
            RangeView thisCurrent = this.getRangeView(thisNextRangeIndex);
            Optional<RangeView> intersect = thisCurrent.tryIntersect(thatCurrent = that.getRangeView(thatNextRangeIndex));
            if (intersect.isPresent()) {
                SortedRangeSet.writeRange(this.type, blockBuilder, inclusive, resultRangeIndex, intersect.get());
                ++resultRangeIndex;
            }
            if ((compare = thisCurrent.compareHighBound(thatCurrent)) == 0) {
                ++thisNextRangeIndex;
                ++thatNextRangeIndex;
            }
            if (compare < 0) {
                ++thisNextRangeIndex;
            }
            if (compare <= 0) continue;
            ++thatNextRangeIndex;
        }
        if (resultRangeIndex * 2 < inclusive.length) {
            inclusive = Arrays.copyOf(inclusive, resultRangeIndex * 2);
        }
        return new SortedRangeSet(this.type, inclusive, blockBuilder.build());
    }

    @Override
    public boolean overlaps(ValueSet other) {
        SortedRangeSet that = this.checkCompatibility(other);
        if (this.isNone() || that.isNone()) {
            return false;
        }
        int thisRangeCount = this.getRangeCount();
        int thatRangeCount = that.getRangeCount();
        int thisNextRangeIndex = 0;
        int thatNextRangeIndex = 0;
        while (thisNextRangeIndex < thisRangeCount && thatNextRangeIndex < thatRangeCount) {
            RangeView thatCurrent;
            RangeView thisCurrent = this.getRangeView(thisNextRangeIndex);
            if (thisCurrent.overlaps(thatCurrent = that.getRangeView(thatNextRangeIndex))) {
                return true;
            }
            int compare = thisCurrent.compareTo(thatCurrent);
            if (compare < 0) {
                ++thisNextRangeIndex;
            }
            if (compare <= 0) continue;
            ++thatNextRangeIndex;
        }
        return false;
    }

    @Override
    public SortedRangeSet union(Collection<ValueSet> valueSets) {
        if (this.isAll()) {
            return this;
        }
        ArrayList<SortedRangeSet> toUnion = new ArrayList<SortedRangeSet>(1 + valueSets.size());
        toUnion.add(this);
        for (ValueSet valueSet : valueSets) {
            SortedRangeSet other = this.checkCompatibility(valueSet);
            if (other.isAll()) {
                return other;
            }
            toUnion.add(other);
        }
        while (toUnion.size() > 1) {
            ArrayList<SortedRangeSet> unioned = new ArrayList<SortedRangeSet>((toUnion.size() + 1) / 2);
            for (int i = 0; i < toUnion.size() - 1; i += 2) {
                unioned.add(((SortedRangeSet)toUnion.get(i)).union((ValueSet)toUnion.get(i + 1)));
            }
            if (toUnion.size() % 2 != 0) {
                unioned.add((SortedRangeSet)toUnion.get(toUnion.size() - 1));
            }
            toUnion = unioned;
        }
        return (SortedRangeSet)toUnion.get(0);
    }

    @Override
    public SortedRangeSet union(ValueSet other) {
        SortedRangeSet that = this.checkCompatibility(other);
        if (this.isAll()) {
            return this;
        }
        if (that.isAll()) {
            return that;
        }
        if (this == that) {
            return this;
        }
        int thisRangeCount = this.getRangeCount();
        int thatRangeCount = that.getRangeCount();
        boolean[] inclusive = new boolean[2 * (thisRangeCount + thatRangeCount)];
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 2 * (thisRangeCount + thatRangeCount));
        int resultRangeIndex = 0;
        int thisNextRangeIndex = 0;
        int thatNextRangeIndex = 0;
        RangeView current = null;
        while (thisNextRangeIndex < thisRangeCount || thatNextRangeIndex < thatRangeCount) {
            RangeView next;
            if (thisNextRangeIndex == thisRangeCount) {
                next = that.getRangeView(thatNextRangeIndex);
                ++thatNextRangeIndex;
            } else if (thatNextRangeIndex == thatRangeCount) {
                next = this.getRangeView(thisNextRangeIndex);
                ++thisNextRangeIndex;
            } else {
                RangeView thatNext;
                RangeView thisNext = this.getRangeView(thisNextRangeIndex);
                if (thisNext.compareTo(thatNext = that.getRangeView(thatNextRangeIndex)) <= 0) {
                    next = thisNext;
                    ++thisNextRangeIndex;
                } else {
                    next = thatNext;
                    ++thatNextRangeIndex;
                }
            }
            if (current != null) {
                Optional<RangeView> merged = current.tryMergeWithNext(next);
                if (merged.isPresent()) {
                    current = merged.get();
                    continue;
                }
                SortedRangeSet.writeRange(this.type, blockBuilder, inclusive, resultRangeIndex, current);
                ++resultRangeIndex;
                current = next;
                continue;
            }
            current = next;
        }
        if (current != null) {
            SortedRangeSet.writeRange(this.type, blockBuilder, inclusive, resultRangeIndex, current);
            ++resultRangeIndex;
        }
        if (resultRangeIndex * 2 < inclusive.length) {
            inclusive = Arrays.copyOf(inclusive, resultRangeIndex * 2);
        }
        return new SortedRangeSet(this.type, inclusive, blockBuilder.build());
    }

    @Override
    public boolean contains(ValueSet other) {
        SortedRangeSet that = this.checkCompatibility(other);
        if (this.isAll()) {
            return true;
        }
        if (that.isAll()) {
            return false;
        }
        if (this == that || that.isNone()) {
            return true;
        }
        if (this.isNone()) {
            return false;
        }
        int thisRangeCount = this.getRangeCount();
        int thatRangeCount = that.getRangeCount();
        int thisRangeIndex = 0;
        RangeView thisRangeView = this.getRangeView(thisRangeIndex);
        for (int thatRangeIndex = 0; thatRangeIndex < thatRangeCount; ++thatRangeIndex) {
            RangeView thatRangeView = that.getRangeView(thatRangeIndex);
            while (thisRangeView.isFullyBefore(thatRangeView)) {
                if (++thisRangeIndex == thisRangeCount) {
                    return false;
                }
                thisRangeView = this.getRangeView(thisRangeIndex);
            }
            if (thisRangeView.contains(thatRangeView)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SortedRangeSet complement() {
        if (this.isNone()) {
            return SortedRangeSet.all(this.type);
        }
        if (this.isAll()) {
            return SortedRangeSet.none(this.type);
        }
        RangeView first = this.getRangeView(0);
        RangeView last = this.getRangeView(this.getRangeCount() - 1);
        int resultRanges = this.getRangeCount() - 1;
        if (!first.isLowUnbounded()) {
            ++resultRanges;
        }
        if (!last.isHighUnbounded()) {
            ++resultRanges;
        }
        boolean[] inclusive = new boolean[2 * resultRanges];
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 2 * resultRanges);
        int resultRangeIndex = 0;
        if (!first.isLowUnbounded()) {
            inclusive[2 * resultRangeIndex] = false;
            inclusive[2 * resultRangeIndex + 1] = !first.lowInclusive;
            blockBuilder.appendNull();
            this.type.appendTo(first.lowValueBlock, first.lowValuePosition, blockBuilder);
            ++resultRangeIndex;
        }
        RangeView previous = first;
        for (int rangeIndex = 1; rangeIndex < this.getRangeCount(); ++rangeIndex) {
            RangeView current = this.getRangeView(rangeIndex);
            inclusive[2 * resultRangeIndex] = !previous.highInclusive;
            inclusive[2 * resultRangeIndex + 1] = !current.lowInclusive;
            this.type.appendTo(previous.highValueBlock, previous.highValuePosition, blockBuilder);
            this.type.appendTo(current.lowValueBlock, current.lowValuePosition, blockBuilder);
            ++resultRangeIndex;
            previous = current;
        }
        if (!last.isHighUnbounded()) {
            inclusive[2 * resultRangeIndex] = !last.highInclusive;
            inclusive[2 * resultRangeIndex + 1] = false;
            this.type.appendTo(last.highValueBlock, last.highValuePosition, blockBuilder);
            blockBuilder.appendNull();
            ++resultRangeIndex;
        }
        if (resultRangeIndex * 2 != inclusive.length) {
            throw new IllegalStateException("Incorrect number of ranges written");
        }
        return new SortedRangeSet(this.type, inclusive, blockBuilder.build());
    }

    private SortedRangeSet checkCompatibility(ValueSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalStateException(String.format("Mismatched types: %s vs %s", this.getType(), other.getType()));
        }
        if (!(other instanceof SortedRangeSet)) {
            throw new IllegalStateException(String.format("ValueSet is not a SortedRangeSet: %s", other.getClass()));
        }
        return (SortedRangeSet)other;
    }

    public int hashCode() {
        int hash = this.lazyHash;
        if (hash == 0) {
            hash = Objects.hash(this.type, Arrays.hashCode(this.inclusive));
            for (int position = 0; position < this.sortedRanges.getPositionCount(); ++position) {
                if (this.sortedRanges.isNull(position)) {
                    hash *= 31;
                    continue;
                }
                try {
                    hash = hash * 31 + (int)this.hashCodeOperator.invokeExact(this.sortedRanges, position);
                    continue;
                }
                catch (Throwable throwable) {
                    throw Utils.handleThrowable(throwable);
                }
            }
            if (hash == 0) {
                hash = 1;
            }
            this.lazyHash = hash;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SortedRangeSet other = (SortedRangeSet)obj;
        return this.hashCode() == other.hashCode() && Objects.equals(this.type, other.type) && Arrays.equals(this.inclusive, other.inclusive) && this.blocksEqual(this.sortedRanges, other.sortedRanges);
    }

    private boolean blocksEqual(Block leftBlock, Block rightBlock) {
        if (leftBlock.getPositionCount() != rightBlock.getPositionCount()) {
            return false;
        }
        for (int position = 0; position < leftBlock.getPositionCount(); ++position) {
            if (this.valuesEqual(leftBlock, position, rightBlock, position)) continue;
            return false;
        }
        return true;
    }

    private boolean valuesEqual(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean equal;
        boolean leftIsNull = leftBlock.isNull(leftPosition);
        boolean rightIsNull = rightBlock.isNull(rightPosition);
        if (leftIsNull || rightIsNull) {
            return leftIsNull == rightIsNull;
        }
        try {
            equal = this.equalOperator.invokeExact(leftBlock, leftPosition, rightBlock, rightPosition);
        }
        catch (Throwable throwable) {
            throw Utils.handleThrowable(throwable);
        }
        return equal;
    }

    private static int compareValues(MethodHandle comparisonOperator, Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        try {
            return (int)comparisonOperator.invokeExact(leftBlock, leftPosition, rightBlock, rightPosition);
        }
        catch (Throwable throwable) {
            throw Utils.handleThrowable(throwable);
        }
    }

    @Override
    public String toString() {
        return this.toString(ToStringSession.INSTANCE);
    }

    @Override
    public String toString(ConnectorSession session) {
        return this.toString(session, 10);
    }

    @Override
    public String toString(ConnectorSession session, int limit) {
        return new StringJoiner(", ", SortedRangeSet.class.getSimpleName() + "[", "]").add("type=" + this.type).add("ranges=" + this.getRangeCount()).add(this.formatRanges(session, limit)).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.inclusive) + this.sortedRanges.getRetainedSizeInBytes();
    }

    @Override
    public Optional<Collection<Object>> tryExpandRanges(int valuesLimit) {
        List<Range> ranges = this.getRanges().getOrderedRanges();
        Type type = this.getType();
        Range typeRange = type.getRange().map(range -> Range.range(type, range.getMin(), true, range.getMax(), true)).orElseGet(() -> Range.all(type));
        ArrayList result = new ArrayList();
        for (Range range2 : ranges) {
            if ((range2.isLowUnbounded() || range2.isHighUnbounded()) && ((range2 = range2.intersect(typeRange).orElse(range2)).isLowUnbounded() || range2.isHighUnbounded())) {
                return Optional.empty();
            }
            Optional<Stream<?>> discreteValues = type.getDiscreteValues(new Type.Range(range2.getLowBoundedValue(), range2.getHighBoundedValue()));
            if (discreteValues.isEmpty()) {
                return Optional.empty();
            }
            Iterator iterator = discreteValues.get().iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("discreteValues iterator is empty");
            }
            if (!range2.isLowInclusive()) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                Object current = iterator.next();
                if (!range2.isHighInclusive() && !iterator.hasNext()) continue;
                if (result.size() >= valuesLimit) {
                    return Optional.empty();
                }
                result.add(current);
            }
        }
        return Optional.of(Collections.unmodifiableList(result));
    }

    private String formatRanges(ConnectorSession session, int limit) {
        if (this.isNone()) {
            return "{}";
        }
        if (this.getRangeCount() == 1) {
            return "{" + this.getRangeView(0).formatRange(session) + "}";
        }
        if (limit < 2) {
            return String.format("{%s, ...}", this.getRangeView(0).formatRange(session));
        }
        Stream<String> prefix = Stream.concat(IntStream.range(0, Math.min(this.getRangeCount(), limit) - 1).mapToObj(this::getRangeView).map(rangeView -> rangeView.formatRange(session)), limit < this.getRangeCount() ? Stream.of("...") : Stream.of(new String[0]));
        Stream<String> suffix = Stream.of(this.getRangeView(this.getRangeCount() - 1).formatRange(session));
        return Stream.concat(prefix, suffix).collect(Collectors.joining(", ", "{", "}"));
    }

    public static Builder builder(Type type, int expectedSize) {
        return new Builder(type, expectedSize);
    }

    static SortedRangeSet buildFromUnsortedRanges(Type type, Collection<Range> unsortedRanges) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(unsortedRanges, "unsortedRanges is null");
        if (!type.isOrderable()) {
            throw new IllegalArgumentException("Type is not orderable: " + type);
        }
        ArrayList<Range> ranges = new ArrayList<Range>(unsortedRanges);
        for (Range range : ranges) {
            if (type.equals(range.getType())) continue;
            throw new IllegalArgumentException(String.format("Range type %s does not match builder type %s", range.getType(), type));
        }
        ranges.sort(Range::compareLowBound);
        ArrayList<Range> result = new ArrayList<Range>(ranges.size());
        Range current = null;
        for (Range next : ranges) {
            if (current == null) {
                current = next;
                continue;
            }
            Optional<Range> merged = current.tryMergeWithNext(next);
            if (merged.isPresent()) {
                current = merged.get();
                continue;
            }
            result.add(current);
            current = next;
        }
        if (current != null) {
            result.add(current);
        }
        boolean[] inclusive = new boolean[2 * result.size()];
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 2 * result.size());
        for (int rangeIndex = 0; rangeIndex < result.size(); ++rangeIndex) {
            Range range = (Range)result.get(rangeIndex);
            SortedRangeSet.writeRange(type, blockBuilder, inclusive, rangeIndex, range);
        }
        return new SortedRangeSet(type, inclusive, blockBuilder);
    }

    private static void writeRange(Type type, BlockBuilder blockBuilder, boolean[] inclusive, int rangeIndex, Range range) {
        inclusive[2 * rangeIndex] = range.isLowInclusive();
        inclusive[2 * rangeIndex + 1] = range.isHighInclusive();
        TypeUtils.writeNativeValue(type, blockBuilder, range.getLowValue().orElse(null));
        TypeUtils.writeNativeValue(type, blockBuilder, range.getHighValue().orElse(null));
    }

    private static void writeRange(Type type, BlockBuilder blockBuilder, boolean[] inclusive, int rangeIndex, RangeView range) {
        inclusive[2 * rangeIndex] = range.lowInclusive;
        inclusive[2 * rangeIndex + 1] = range.highInclusive;
        type.appendTo(range.lowValueBlock, range.lowValuePosition, blockBuilder);
        type.appendTo(range.highValueBlock, range.highValuePosition, blockBuilder);
    }

    private static void checkNotNaN(Type type, Object value) {
        if (TypeUtils.isFloatingPointNaN(type, value)) {
            throw new IllegalArgumentException("cannot use NaN as range bound");
        }
    }

    private static class RangeView
    implements Comparable<RangeView> {
        private final Type type;
        private final MethodHandle comparisonOperator;
        private final MethodHandle rangeComparisonOperator;
        private final boolean lowInclusive;
        private final Block lowValueBlock;
        private final int lowValuePosition;
        private final boolean highInclusive;
        private final Block highValueBlock;
        private final int highValuePosition;

        RangeView(Type type, MethodHandle comparisonOperator, MethodHandle rangeComparisonOperator, boolean lowInclusive, Block lowValueBlock, int lowValuePosition, boolean highInclusive, Block highValueBlock, int highValuePosition) {
            this.type = type;
            this.comparisonOperator = comparisonOperator;
            this.rangeComparisonOperator = rangeComparisonOperator;
            this.lowInclusive = lowInclusive;
            this.lowValueBlock = lowValueBlock;
            this.lowValuePosition = lowValuePosition;
            this.highInclusive = highInclusive;
            this.highValueBlock = highValueBlock;
            this.highValuePosition = highValuePosition;
        }

        public Range toRange() {
            Object low = TypeUtils.readNativeValue(this.type, this.lowValueBlock, this.lowValuePosition);
            Object high = TypeUtils.readNativeValue(this.type, this.highValueBlock, this.highValuePosition);
            return new Range(this.type, this.lowInclusive, Optional.ofNullable(low), this.highInclusive, Optional.ofNullable(high), this.rangeComparisonOperator);
        }

        @Override
        public int compareTo(RangeView that) {
            int lowBoundCompare = this.compareLowBound(that);
            if (lowBoundCompare != 0) {
                return lowBoundCompare;
            }
            return this.compareHighBound(that);
        }

        private int compareLowBound(RangeView that) {
            if (this.isLowUnbounded() || that.isLowUnbounded()) {
                return Boolean.compare(!this.isLowUnbounded(), !that.isLowUnbounded());
            }
            int compare = SortedRangeSet.compareValues(this.comparisonOperator, this.lowValueBlock, this.lowValuePosition, that.lowValueBlock, that.lowValuePosition);
            if (compare != 0) {
                return compare;
            }
            return Boolean.compare(!this.lowInclusive, !that.lowInclusive);
        }

        private int compareHighBound(RangeView that) {
            if (this.isHighUnbounded() || that.isHighUnbounded()) {
                return Boolean.compare(this.isHighUnbounded(), that.isHighUnbounded());
            }
            int compare = SortedRangeSet.compareValues(this.comparisonOperator, this.highValueBlock, this.highValuePosition, that.highValueBlock, that.highValuePosition);
            if (compare != 0) {
                return compare;
            }
            return Boolean.compare(this.highInclusive, that.highInclusive);
        }

        public Optional<RangeView> tryMergeWithNext(RangeView next) {
            boolean merge;
            if (this.compareTo(next) > 0) {
                throw new IllegalArgumentException("next before this");
            }
            if (this.isHighUnbounded()) {
                return Optional.of(this);
            }
            if (next.isLowUnbounded()) {
                merge = true;
            } else {
                int compare = SortedRangeSet.compareValues(this.comparisonOperator, this.highValueBlock, this.highValuePosition, next.lowValueBlock, next.lowValuePosition);
                boolean bl = merge = compare > 0 || compare == 0 && (this.highInclusive || next.lowInclusive);
            }
            if (merge) {
                int compareHighBound = this.compareHighBound(next);
                return Optional.of(new RangeView(this.type, this.comparisonOperator, this.rangeComparisonOperator, this.lowInclusive, this.lowValueBlock, this.lowValuePosition, compareHighBound <= 0 ? next.highInclusive : this.highInclusive, compareHighBound <= 0 ? next.highValueBlock : this.highValueBlock, compareHighBound <= 0 ? next.highValuePosition : this.highValuePosition));
            }
            return Optional.empty();
        }

        public boolean isLowUnbounded() {
            return this.lowValueBlock.isNull(this.lowValuePosition);
        }

        public boolean isHighUnbounded() {
            return this.highValueBlock.isNull(this.highValuePosition);
        }

        public boolean isSingleValue() {
            return this.lowInclusive && this.highInclusive && SortedRangeSet.compareValues(this.comparisonOperator, this.lowValueBlock, this.lowValuePosition, this.highValueBlock, this.highValuePosition) == 0;
        }

        public Optional<Object> getSingleValue() {
            if (!this.isSingleValue()) {
                return Optional.empty();
            }
            return Optional.of(TypeUtils.readNativeValue(this.type, this.lowValueBlock, this.lowValuePosition));
        }

        public boolean overlaps(RangeView that) {
            return !this.isFullyBefore(that) && !that.isFullyBefore(this);
        }

        public boolean contains(RangeView that) {
            return this.compareLowBound(that) <= 0 && this.compareHighBound(that) >= 0;
        }

        public Optional<RangeView> tryIntersect(RangeView that) {
            if (!this.overlaps(that)) {
                return Optional.empty();
            }
            int compareLowBound = this.compareLowBound(that);
            int compareHighBound = this.compareHighBound(that);
            return Optional.of(new RangeView(this.type, this.comparisonOperator, this.rangeComparisonOperator, compareLowBound <= 0 ? that.lowInclusive : this.lowInclusive, compareLowBound <= 0 ? that.lowValueBlock : this.lowValueBlock, compareLowBound <= 0 ? that.lowValuePosition : this.lowValuePosition, compareHighBound <= 0 ? this.highInclusive : that.highInclusive, compareHighBound <= 0 ? this.highValueBlock : that.highValueBlock, compareHighBound <= 0 ? this.highValuePosition : that.highValuePosition));
        }

        private boolean isFullyBefore(RangeView that) {
            if (this.isHighUnbounded()) {
                return false;
            }
            if (that.isLowUnbounded()) {
                return false;
            }
            int compare = SortedRangeSet.compareValues(this.comparisonOperator, this.highValueBlock, this.highValuePosition, that.lowValueBlock, that.lowValuePosition);
            if (compare < 0) {
                return true;
            }
            if (compare == 0) {
                return !this.highInclusive || !that.lowInclusive;
            }
            return false;
        }

        public String toString() {
            return new StringJoiner(", ", RangeView.class.getSimpleName() + "[", "]").add(this.formatRange(ToStringSession.INSTANCE)).add("type=" + this.type.getDisplayName()).toString();
        }

        public String formatRange(ConnectorSession session) {
            if (this.isSingleValue()) {
                return String.format("[%s]", this.type.getObjectValue(session, this.lowValueBlock, this.lowValuePosition));
            }
            String lowValue = this.isLowUnbounded() ? "<min>" : this.type.getObjectValue(session, this.lowValueBlock, this.lowValuePosition);
            String highValue = this.isHighUnbounded() ? "<max>" : this.type.getObjectValue(session, this.highValueBlock, this.highValuePosition);
            return String.format("%s%s,%s%s", this.lowInclusive ? "[" : "(", lowValue, highValue, this.highInclusive ? "]" : ")");
        }
    }

    public static class Builder {
        private final Type type;
        private final MethodHandle rangeComparisonOperator;
        private final List<Range> ranges;

        private Builder(Type type, int expectedSize) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.rangeComparisonOperator = Range.getComparisonOperator(type);
            this.ranges = new ArrayList<Range>(expectedSize);
        }

        public Builder addRangeInclusive(Object lowValue, Object highValue) {
            this.ranges.add(new Range(this.type, true, Optional.of(lowValue), true, Optional.of(highValue), this.rangeComparisonOperator));
            return this;
        }

        public Builder addValue(Object value) {
            Optional<Object> valueAsOptional = Optional.of(value);
            this.ranges.add(new Range(this.type, true, valueAsOptional, true, valueAsOptional, this.rangeComparisonOperator));
            return this;
        }

        public SortedRangeSet build() {
            return SortedRangeSet.of(this.ranges);
        }
    }
}

