/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import com.google.errorprone.annotations.Immutable;

@Immutable
public class Location {
    private final int lineNumber;
    private final int columnNumber;

    public Location(int lineNumber, int columnNumber) {
        if (lineNumber < 1) {
            throw new IllegalArgumentException("lineNumber must be at least one");
        }
        if (columnNumber < 1) {
            throw new IllegalArgumentException("columnNumber must be at least one");
        }
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        return this.lineNumber + ":" + this.columnNumber;
    }
}

