/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.type.MapType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class BufferedMapValueBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BufferedMapValueBuilder.class);
    private final MapType mapType;
    private final HashBuildMode hashBuildMode;
    private BlockBuilder keyBlockBuilder;
    private BlockBuilder valueBlockBuilder;
    private int bufferSize;

    public static BufferedMapValueBuilder createBuffered(MapType mapType) {
        return new BufferedMapValueBuilder(mapType, HashBuildMode.DUPLICATE_NOT_CHECKED, 1024);
    }

    public static BufferedMapValueBuilder createBufferedStrict(MapType mapType) {
        return new BufferedMapValueBuilder(mapType, HashBuildMode.STRICT_EQUALS, 1024);
    }

    public static BufferedMapValueBuilder createBufferedDistinctStrict(MapType mapType) {
        return new BufferedMapValueBuilder(mapType, HashBuildMode.STRICT_NOT_DISTINCT_FROM, 1024);
    }

    BufferedMapValueBuilder(MapType mapType, HashBuildMode hashBuildMode, int bufferSize) {
        this.mapType = Objects.requireNonNull(mapType, "mapType is null");
        this.hashBuildMode = hashBuildMode;
        this.keyBlockBuilder = mapType.getKeyType().createBlockBuilder(null, bufferSize);
        this.valueBlockBuilder = mapType.getValueType().createBlockBuilder(null, bufferSize);
        this.bufferSize = bufferSize;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes();
    }

    public <E extends Throwable> Block build(int entryCount, MapValueBuilder<E> builder) throws E {
        if (this.keyBlockBuilder.getPositionCount() != this.valueBlockBuilder.getPositionCount()) {
            throw new IllegalStateException("Key and value builders were corrupted by a previous call to buildValue");
        }
        if (this.keyBlockBuilder.getPositionCount() + entryCount > this.bufferSize) {
            if (this.bufferSize < entryCount) {
                this.bufferSize = entryCount;
            }
            this.keyBlockBuilder = this.keyBlockBuilder.newBlockBuilderLike(this.bufferSize, null);
            this.valueBlockBuilder = this.valueBlockBuilder.newBlockBuilderLike(this.bufferSize, null);
        }
        int startSize = this.keyBlockBuilder.getPositionCount();
        try {
            builder.build(this.keyBlockBuilder, this.valueBlockBuilder);
        }
        catch (Exception e) {
            this.equalizeBlockBuilders();
            throw e;
        }
        if (this.equalizeBlockBuilders()) {
            throw new IllegalStateException("Expected key and value builders to have the same size");
        }
        int endSize = this.keyBlockBuilder.getPositionCount();
        Block keyBlock = this.keyBlockBuilder.build().getRegion(startSize, endSize - startSize);
        Block valueBlock = this.valueBlockBuilder.build().getRegion(startSize, endSize - startSize);
        int[] table = new int[keyBlock.getPositionCount() * 2];
        Arrays.fill(table, -1);
        MapHashTables hashTables = new MapHashTables(this.mapType, Optional.of(table));
        switch (this.hashBuildMode) {
            case DUPLICATE_NOT_CHECKED: {
                hashTables.buildHashTable(keyBlock, 0, keyBlock.getPositionCount());
                break;
            }
            case STRICT_EQUALS: {
                hashTables.buildHashTableStrict(keyBlock, 0, keyBlock.getPositionCount());
                break;
            }
            case STRICT_NOT_DISTINCT_FROM: {
                hashTables.buildDistinctHashTableStrict(keyBlock, 0, keyBlock.getPositionCount());
            }
        }
        MapBlock mapBlock = MapBlock.createMapBlockInternal(this.mapType, 0, 1, Optional.empty(), new int[]{0, keyBlock.getPositionCount()}, keyBlock, valueBlock, hashTables);
        return new SingleMapBlock(0, keyBlock.getPositionCount() * 2, mapBlock);
    }

    private boolean equalizeBlockBuilders() {
        int keyBlockSize = this.keyBlockBuilder.getPositionCount();
        if (keyBlockSize == this.valueBlockBuilder.getPositionCount()) {
            return false;
        }
        int expectedSize = Math.max(keyBlockSize, this.valueBlockBuilder.getPositionCount());
        while (this.keyBlockBuilder.getPositionCount() < expectedSize) {
            this.keyBlockBuilder.appendNull();
        }
        while (this.valueBlockBuilder.getPositionCount() < expectedSize) {
            this.valueBlockBuilder.appendNull();
        }
        return true;
    }

    static enum HashBuildMode {
        DUPLICATE_NOT_CHECKED,
        STRICT_EQUALS,
        STRICT_NOT_DISTINCT_FROM;

    }
}

