/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.AbstractVariableWidthBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public class VariableWidthBlockBuilder
extends AbstractVariableWidthBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(VariableWidthBlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new VariableWidthBlock(0, 1, Slices.EMPTY_SLICE, new int[]{0, 0}, new boolean[]{true});
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int initialSliceOutputSize;
    private SliceOutput sliceOutput = new DynamicSliceOutput(0);
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] offsets = new int[1];
    private int positions;
    private long arraysRetainedSizeInBytes;

    public VariableWidthBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytes) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = expectedEntries;
        this.initialSliceOutputSize = Math.min(expectedBytes, 0x7FFFFFF7);
        this.updateArraysDataSize();
    }

    @Override
    protected int getPositionOffset(int position) {
        BlockUtil.checkValidPosition(position, this.positions);
        return this.getOffset(position);
    }

    @Override
    public int getSliceLength(int position) {
        BlockUtil.checkValidPosition(position, this.positions);
        return this.getOffset(position + 1) - this.getOffset(position);
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positions;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getSizeInBytes() {
        long arraysSizeInBytes = 5L * (long)this.positions;
        return (long)this.sliceOutput.size() + arraysSizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, positionOffset, length);
        long arraysSizeInBytes = 5L * (long)length;
        return (long)(this.getOffset(positionOffset + length) - this.getOffset(positionOffset)) + arraysSizeInBytes;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionCount) {
        BlockUtil.checkValidPositions(positions, this.getPositionCount());
        long sizeInBytes = 0L;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            sizeInBytes += (long)(this.getOffset(i + 1) - this.getOffset(i));
        }
        return sizeInBytes + 5L * (long)selectedPositionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.sliceOutput.getRetainedSize() + this.arraysRetainedSizeInBytes;
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.sliceOutput, this.sliceOutput.getRetainedSize());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        int finalLength = 0;
        for (int i = offset; i < offset + length; ++i) {
            finalLength += this.getSliceLength(positions[i]);
        }
        SliceOutput newSlice = Slices.allocate((int)finalLength).getOutput();
        int[] newOffsets = new int[length + 1];
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = new boolean[length];
        }
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (this.isEntryNull(position)) {
                newValueIsNull[i] = true;
            } else {
                newSlice.writeBytes(this.sliceOutput.getUnderlyingSlice(), this.getPositionOffset(position), this.getSliceLength(position));
            }
            newOffsets[i + 1] = newSlice.size();
        }
        return new VariableWidthBlock(0, length, newSlice.slice(), newOffsets, newValueIsNull);
    }

    public VariableWidthBlockBuilder writeEntry(Slice source) {
        return this.writeEntry(source, 0, source.length());
    }

    public VariableWidthBlockBuilder writeEntry(Slice source, int sourceIndex, int length) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.entryAdded(length, false);
        return this;
    }

    public <E extends Throwable> void buildEntry(VariableWidthEntryBuilder<E> builder) throws E {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        int start = this.sliceOutput.size();
        builder.build(this.sliceOutput);
        int length = this.sliceOutput.size() - start;
        this.entryAdded(length, false);
    }

    @Override
    public BlockBuilder appendNull() {
        this.hasNullValue = true;
        this.entryAdded(0, true);
        return this;
    }

    private void entryAdded(int bytesWritten, boolean isNull) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        if (this.valueIsNull.length <= this.positions) {
            this.growCapacity();
        }
        this.valueIsNull[this.positions] = isNull;
        this.offsets[this.positions + 1] = this.sliceOutput.size();
        ++this.positions;
        this.hasNonNullValue |= !isNull;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5 + bytesWritten);
        }
    }

    private void growCapacity() {
        int newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateArraysDataSize();
    }

    private void initializeCapacity() {
        if (this.positions != 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was used before initialization");
        }
        this.initialized = true;
        this.valueIsNull = new boolean[this.initialEntryCount];
        this.offsets = new int[this.initialEntryCount + 1];
        this.sliceOutput = new DynamicSliceOutput(this.initialSliceOutputSize);
        this.updateArraysDataSize();
    }

    private void updateArraysDataSize() {
        this.arraysRetainedSizeInBytes = SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.offsets);
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullValue;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, positionOffset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        return new VariableWidthBlock(positionOffset, length, this.sliceOutput.slice(), this.offsets, this.hasNullValue ? this.valueIsNull : null);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, positionOffset, length);
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, length);
        }
        int[] newOffsets = BlockUtil.compactOffsets(this.offsets, positionOffset, length);
        boolean[] newValueIsNull = null;
        if (this.hasNullValue) {
            newValueIsNull = BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        }
        Slice slice = BlockUtil.compactSlice(this.sliceOutput.getUnderlyingSlice(), this.offsets[positionOffset], newOffsets[length]);
        return new VariableWidthBlock(0, length, slice, newOffsets, newValueIsNull);
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positions);
        }
        return new VariableWidthBlock(0, this.positions, this.sliceOutput.slice(), this.offsets, this.hasNullValue ? this.valueIsNull : null);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        int currentSizeInBytes = this.positions == 0 ? this.positions : this.getOffset(this.positions) - this.getOffset(0);
        return new VariableWidthBlockBuilder(blockBuilderStatus, expectedEntries, BlockUtil.calculateBlockResetBytes(currentSizeInBytes));
    }

    private int getOffset(int position) {
        return this.offsets[position];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positions);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append('}');
        return sb.toString();
    }

    public static interface VariableWidthEntryBuilder<E extends Throwable> {
        public void build(SliceOutput var1) throws E;
    }
}

