/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.Identity;
import io.trino.spi.security.TrinoPrincipal;
import java.security.Principal;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class AccessDeniedException
extends TrinoException {
    public static final String PREFIX = "Access Denied: ";

    public AccessDeniedException(String message) {
        super((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, PREFIX + message);
    }

    public AccessDeniedException(String message, AccessDeniedException e) {
        super(StandardErrorCode.PERMISSION_DENIED, PREFIX + message, (Throwable)e);
    }

    public static void denyImpersonateUser(String originalUser, String newUser) {
        AccessDeniedException.denyImpersonateUser(originalUser, newUser, null);
    }

    public static void denyImpersonateUser(String originalUser, String newUser, String extraInfo) {
        throw new AccessDeniedException(String.format("User %s cannot impersonate user %s%s", originalUser, newUser, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetUser(Optional<Principal> principal, String userName) {
        AccessDeniedException.denySetUser(principal, userName, null);
    }

    public static void denySetUser(Optional<Principal> principal, String userName, String extraInfo) {
        throw new AccessDeniedException(String.format("Principal %s cannot become user %s%s", principal.orElse(null), userName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyReadSystemInformationAccess() {
        AccessDeniedException.denyReadSystemInformationAccess(null);
    }

    public static void denyReadSystemInformationAccess(String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot read system information%s", AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyWriteSystemInformationAccess() {
        AccessDeniedException.denyWriteSystemInformationAccess(null);
    }

    public static void denyWriteSystemInformationAccess(String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot write system information%s", AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyExecuteQuery() {
        AccessDeniedException.denyExecuteQuery(null);
    }

    public static void denyExecuteQuery(String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot execute query%s", AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyViewQuery() {
        AccessDeniedException.denyViewQuery(null);
    }

    public static void denyViewQuery(String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot view query%s", AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyKillQuery() {
        AccessDeniedException.denyKillQuery(null);
    }

    public static void denyKillQuery(String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot kill query%s", AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCatalogAccess(String catalogName) {
        AccessDeniedException.denyCatalogAccess(catalogName, null);
    }

    public static void denyCatalogAccess(String catalogName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot access catalog %s%s", catalogName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateCatalog(String catalogName) {
        AccessDeniedException.denyCreateCatalog(catalogName, null);
    }

    public static void denyCreateCatalog(String catalogName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create catalog %s%s", catalogName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropCatalog(String catalogName) {
        AccessDeniedException.denyDropCatalog(catalogName, null);
    }

    public static void denyDropCatalog(String catalogName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop catalog %s%s", catalogName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateSchema(String schemaName) {
        AccessDeniedException.denyCreateSchema(schemaName, null);
    }

    public static void denyCreateSchema(String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create schema %s%s", schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropSchema(String schemaName) {
        AccessDeniedException.denyDropSchema(schemaName, null);
    }

    public static void denyDropSchema(String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop schema %s%s", schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRenameSchema(String schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schemaName, newSchemaName, null);
    }

    public static void denyRenameSchema(String schemaName, String newSchemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename schema from %s to %s%s", schemaName, newSchemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetSchemaAuthorization(String schemaName, TrinoPrincipal principal) {
        AccessDeniedException.denySetSchemaAuthorization(schemaName, principal, null);
    }

    public static void denySetSchemaAuthorization(String schemaName, TrinoPrincipal principal, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set authorization for schema %s to %s%s", schemaName, principal, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowSchemas() {
        AccessDeniedException.denyShowSchemas(null);
    }

    public static void denyShowSchemas(String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot show schemas%s", AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowCreateSchema(String schemaName) {
        AccessDeniedException.denyShowCreateSchema(schemaName, null);
    }

    public static void denyShowCreateSchema(String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot show create schema for %s%s", schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowCreateTable(String tableName) {
        AccessDeniedException.denyShowCreateTable(tableName, null);
    }

    public static void denyShowCreateTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot show create table for %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateTable(String tableName) {
        AccessDeniedException.denyCreateTable(tableName, null);
    }

    public static void denyCreateTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropTable(String tableName) {
        AccessDeniedException.denyDropTable(tableName, null);
    }

    public static void denyDropTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRenameTable(String tableName, String newTableName) {
        AccessDeniedException.denyRenameTable(tableName, newTableName, null);
    }

    public static void denyRenameTable(String tableName, String newTableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename table from %s to %s%s", tableName, newTableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetTableProperties(String tableName) {
        AccessDeniedException.denySetTableProperties(tableName, null);
    }

    public static void denySetTableProperties(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set table properties to %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCommentTable(String tableName) {
        AccessDeniedException.denyCommentTable(tableName, null);
    }

    public static void denyCommentTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot comment table to %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCommentView(String viewName) {
        AccessDeniedException.denyCommentView(viewName, null);
    }

    public static void denyCommentView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot comment view to %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCommentColumn(String tableName) {
        AccessDeniedException.denyCommentColumn(tableName, null);
    }

    public static void denyCommentColumn(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot comment column to %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowTables(String schemaName) {
        AccessDeniedException.denyShowTables(schemaName, null);
    }

    public static void denyShowTables(String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot show tables of schema %s%s", schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowColumns(String tableName) {
        throw new AccessDeniedException(String.format("Cannot show columns of table %s", tableName));
    }

    public static void denyShowColumns(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot show columns of table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyAddColumn(String tableName) {
        AccessDeniedException.denyAddColumn(tableName, null);
    }

    public static void denyAddColumn(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot add a column to table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropColumn(String tableName) {
        AccessDeniedException.denyDropColumn(tableName, null);
    }

    public static void denyDropColumn(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop a column from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyAlterColumn(String tableName) {
        AccessDeniedException.denyAlterColumn(tableName, null);
    }

    public static void denyAlterColumn(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot alter a column for table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetTableAuthorization(String tableName, TrinoPrincipal principal) {
        AccessDeniedException.denySetTableAuthorization(tableName, principal, null);
    }

    public static void denySetTableAuthorization(String tableName, TrinoPrincipal principal, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set authorization for table %s to %s%s", tableName, principal, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRenameColumn(String tableName) {
        AccessDeniedException.denyRenameColumn(tableName, null);
    }

    public static void denyRenameColumn(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename a column in table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySelectTable(String tableName) {
        AccessDeniedException.denySelectTable(tableName, null);
    }

    public static void denySelectTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot select from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyInsertTable(String tableName) {
        AccessDeniedException.denyInsertTable(tableName, null);
    }

    public static void denyInsertTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot insert into table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDeleteTable(String tableName) {
        AccessDeniedException.denyDeleteTable(tableName, null);
    }

    public static void denyDeleteTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot delete from table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyTruncateTable(String tableName) {
        AccessDeniedException.denyTruncateTable(tableName, null);
    }

    public static void denyTruncateTable(String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot truncate table %s%s", tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyUpdateTableColumns(String tableName, Set<String> updatedColumnNames) {
        AccessDeniedException.denyUpdateTableColumns(tableName, updatedColumnNames, null);
    }

    public static void denyUpdateTableColumns(String tableName, Set<String> updatedColumnNames, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot update columns %s in table %s%s", updatedColumnNames, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateView(String viewName) {
        AccessDeniedException.denyCreateView(viewName, null);
    }

    public static void denyCreateView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateViewWithSelect(String sourceName, Identity identity) {
        AccessDeniedException.denyCreateViewWithSelect(sourceName, identity.toConnectorIdentity());
    }

    public static void denyCreateViewWithSelect(String sourceName, ConnectorIdentity identity) {
        AccessDeniedException.denyCreateViewWithSelect(sourceName, identity, null);
    }

    public static void denyCreateViewWithSelect(String sourceName, ConnectorIdentity identity, String extraInfo) {
        throw new AccessDeniedException(String.format("View owner '%s' cannot create view that selects from %s%s", identity.getUser(), sourceName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyGrantExecuteFunctionPrivilege(String functionName, Identity identity, Identity grantee) {
        AccessDeniedException.denyGrantExecuteFunctionPrivilege(functionName, identity, String.format("user '%s'", grantee.getUser()));
    }

    public static void denyGrantExecuteFunctionPrivilege(String functionName, Identity identity, String grantee) {
        throw new AccessDeniedException(String.format("'%s' cannot grant '%s' execution to %s", identity.getUser(), functionName, grantee));
    }

    public static void denyRenameView(String viewName, String newViewName) {
        AccessDeniedException.denyRenameView(viewName, newViewName, null);
    }

    public static void denyRenameView(String viewName, String newViewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename view from %s to %s%s", viewName, newViewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetViewAuthorization(String viewName, TrinoPrincipal principal) {
        AccessDeniedException.denySetViewAuthorization(viewName, principal, null);
    }

    public static void denySetViewAuthorization(String viewName, TrinoPrincipal principal, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set authorization for view %s to %s%s", viewName, principal, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetViewComment(String viewName) {
        AccessDeniedException.denySetViewComment(viewName, null);
    }

    public static void denySetViewComment(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set comment for view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropView(String viewName) {
        AccessDeniedException.denyDropView(viewName, null);
    }

    public static void denyDropView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySelectView(String viewName) {
        AccessDeniedException.denySelectView(viewName, null);
    }

    public static void denySelectView(String viewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot select from view %s%s", viewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateMaterializedView(String materializedViewName) {
        AccessDeniedException.denyCreateMaterializedView(materializedViewName, null);
    }

    public static void denyCreateMaterializedView(String materializedViewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot create materialized view %s%s", materializedViewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRefreshMaterializedView(String materializedViewName) {
        AccessDeniedException.denyRefreshMaterializedView(materializedViewName, null);
    }

    public static void denyRefreshMaterializedView(String materializedViewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot refresh materialized view %s%s", materializedViewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetMaterializedViewProperties(String materializedViewName) {
        AccessDeniedException.denySetMaterializedViewProperties(materializedViewName, null);
    }

    public static void denySetMaterializedViewProperties(String materializedViewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set properties of materialized view %s%s", materializedViewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDropMaterializedView(String materializedViewName) {
        AccessDeniedException.denyDropMaterializedView(materializedViewName, null);
    }

    public static void denyDropMaterializedView(String materializedViewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot drop materialized view %s%s", materializedViewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRenameMaterializedView(String materializedViewName, String newMaterializedViewName) {
        AccessDeniedException.denyRenameMaterializedView(materializedViewName, newMaterializedViewName, null);
    }

    public static void denyRenameMaterializedView(String materializedViewName, String newMaterializedViewName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot rename materialized view from %s to %s%s", materializedViewName, newMaterializedViewName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyGrantSchemaPrivilege(String privilege, String schemaName) {
        AccessDeniedException.denyGrantSchemaPrivilege(privilege, schemaName, null);
    }

    public static void denyGrantSchemaPrivilege(String privilege, String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot grant privilege %s on schema %s%s", privilege, schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDenySchemaPrivilege(String privilege, String schemaName) {
        AccessDeniedException.denyDenySchemaPrivilege(privilege, schemaName, null);
    }

    public static void denyDenySchemaPrivilege(String privilege, String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot deny privilege %s on schema %s%s", privilege, schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRevokeSchemaPrivilege(String privilege, String schemaName) {
        AccessDeniedException.denyRevokeSchemaPrivilege(privilege, schemaName, null);
    }

    public static void denyRevokeSchemaPrivilege(String privilege, String schemaName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot revoke privilege %s on schema %s%s", privilege, schemaName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyGrantTablePrivilege(String privilege, String tableName) {
        AccessDeniedException.denyGrantTablePrivilege(privilege, tableName, null);
    }

    public static void denyGrantTablePrivilege(String privilege, String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot grant privilege %s on table %s%s", privilege, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyDenyTablePrivilege(String privilege, String tableName) {
        AccessDeniedException.denyDenyTablePrivilege(privilege, tableName, null);
    }

    public static void denyDenyTablePrivilege(String privilege, String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot deny privilege %s on table %s%s", privilege, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyRevokeTablePrivilege(String privilege, String tableName) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege, tableName, null);
    }

    public static void denyRevokeTablePrivilege(String privilege, String tableName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot revoke privilege %s on table %s%s", privilege, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyShowRoles() {
        throw new AccessDeniedException("Cannot show roles");
    }

    public static void denyShowRoleAuthorizationDescriptors() {
        throw new AccessDeniedException("Cannot show role authorization descriptors");
    }

    public static void denyShowCurrentRoles() {
        throw new AccessDeniedException("Cannot show current roles");
    }

    public static void denyShowRoleGrants() {
        throw new AccessDeniedException("Cannot show role grants");
    }

    public static void denySetSystemSessionProperty(String propertyName) {
        AccessDeniedException.denySetSystemSessionProperty(propertyName, null);
    }

    public static void denySetSystemSessionProperty(String propertyName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set system session property %s%s", propertyName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetCatalogSessionProperty(String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(catalogName, propertyName, null);
    }

    public static void denySetCatalogSessionProperty(String catalogName, String propertyName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot set catalog session property %s.%s%s", catalogName, propertyName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denySetCatalogSessionProperty(String propertyName) {
        throw new AccessDeniedException(String.format("Cannot set catalog session property %s", propertyName));
    }

    public static void denySelectColumns(String tableName, Collection<String> columnNames) {
        AccessDeniedException.denySelectColumns(tableName, columnNames, null);
    }

    public static void denySelectColumns(String tableName, Collection<String> columnNames, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot select from columns %s in table or view %s%s", columnNames, tableName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyCreateRole(String roleName) {
        throw new AccessDeniedException(String.format("Cannot create role %s", roleName));
    }

    public static void denyDropRole(String roleName) {
        throw new AccessDeniedException(String.format("Cannot drop role %s", roleName));
    }

    public static void denyGrantRoles(Set<String> roles, Set<TrinoPrincipal> grantees) {
        throw new AccessDeniedException(String.format("Cannot grant roles %s to %s", roles, grantees));
    }

    public static void denyRevokeRoles(Set<String> roles, Set<TrinoPrincipal> grantees) {
        throw new AccessDeniedException(String.format("Cannot revoke roles %s from %s", roles, grantees));
    }

    public static void denySetRole(String role) {
        throw new AccessDeniedException(String.format("Cannot set role %s", role));
    }

    public static void denyExecuteProcedure(String procedureName) {
        AccessDeniedException.denyExecuteProcedure(procedureName, null);
    }

    public static void denyExecuteProcedure(String procedureName, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot execute procedure %s%s", procedureName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyExecuteFunction(String functionName) {
        throw new AccessDeniedException(String.format("Cannot execute function %s", functionName));
    }

    public static void denyExecuteFunction(String functionName, FunctionKind functionKind, String extraInfo) {
        throw new AccessDeniedException(String.format("Cannot execute %s function %s%s", functionKind.name().toLowerCase(Locale.ROOT), functionName, AccessDeniedException.formatExtraInfo(extraInfo)));
    }

    public static void denyExecuteTableProcedure(String tableName, String procedureName) {
        throw new AccessDeniedException(String.format("Cannot execute table procedure %s on %s", procedureName, tableName));
    }

    private static Object formatExtraInfo(String extraInfo) {
        if (extraInfo == null || extraInfo.isEmpty()) {
            return "";
        }
        return ": " + extraInfo;
    }
}

