/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSingleArrayBlock
implements Block {
    protected final int start;

    protected AbstractSingleArrayBlock(int start) {
        this.start = start;
    }

    @Override
    public final List<Block> getChildren() {
        return Collections.singletonList(this.getBlock());
    }

    protected abstract Block getBlock();

    @Override
    public int getSliceLength(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getSliceLength(position + this.start);
    }

    @Override
    public byte getByte(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getByte(position + this.start, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getShort(position + this.start, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getInt(position + this.start, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getLong(position + this.start, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getSlice(position + this.start, offset, length);
    }

    @Override
    public void writeSliceTo(int position, int offset, int length, SliceOutput output) {
        BlockUtil.checkReadablePosition(this, position);
        this.getBlock().writeSliceTo(position + this.start, offset, length, output);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getObject(position + this.start, clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().bytesEqual(position + this.start, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().bytesCompare(position + this.start, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().equals(position + this.start, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().hash(position + this.start, offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        BlockUtil.checkReadablePosition(this, leftPosition);
        return this.getBlock().compareTo(leftPosition + this.start, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getSingleValueBlock(position + this.start);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().getEstimatedDataSizeForStats(position + this.start);
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.getBlock().isNull(position + this.start);
    }

    @Override
    public String getEncodingName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }
}

