/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.expression;

import io.airlift.slice.Slice;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Constant
extends ConnectorExpression {
    public static final Constant TRUE = new Constant(true, BooleanType.BOOLEAN);
    public static final Constant FALSE = new Constant(false, BooleanType.BOOLEAN);
    private final Object value;

    public Constant(@Nullable Object value, Type type) {
        super(type);
        this.value = value;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Override
    public List<? extends ConnectorExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.getType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constant that = (Constant)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.getType(), that.getType());
    }

    @Override
    public String toString() {
        if (this.value instanceof Slice) {
            return "Slice[hash=" + this.value.hashCode() + ",length=" + ((Slice)this.value).length() + "]::" + this.getType();
        }
        return this.value + "::" + this.getType();
    }
}

