/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.statistics;

import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.OptionalDouble;

public final class StatsUtil {
    private StatsUtil() {
    }

    public static OptionalDouble toStatsRepresentation(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        if (type == BooleanType.BOOLEAN) {
            return OptionalDouble.of((Boolean)value != false ? 1.0 : 0.0);
        }
        if (type == TinyintType.TINYINT || type == SmallintType.SMALLINT || type == IntegerType.INTEGER || type == BigintType.BIGINT) {
            return OptionalDouble.of(((Long)value).longValue());
        }
        if (type == RealType.REAL) {
            return OptionalDouble.of(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type == DoubleType.DOUBLE) {
            return OptionalDouble.of((Double)value);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return OptionalDouble.of(DecimalConversions.shortDecimalToDouble((Long)value, Decimals.longTenToNth(decimalType.getScale())));
            }
            return OptionalDouble.of(DecimalConversions.longDecimalToDouble((Int128)value, decimalType.getScale()));
        }
        if (type == DateType.DATE) {
            return OptionalDouble.of(((Long)value).longValue());
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.isShort()) {
                return OptionalDouble.of(((Long)value).longValue());
            }
            return OptionalDouble.of(((LongTimestamp)value).getEpochMicros());
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            if (timestampWithTimeZoneType.isShort()) {
                return OptionalDouble.of(DateTimeEncoding.unpackMillisUtc((Long)value));
            }
            return OptionalDouble.of(((LongTimestampWithTimeZone)value).getEpochMillis());
        }
        return OptionalDouble.empty();
    }
}

