/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.Fixed12BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeWithTimeZoneTypes;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;

final class LongTimeWithTimeZoneType
extends TimeWithTimeZoneType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(LongTimeWithTimeZoneType.class, MethodHandles.lookup(), LongTimeWithTimeZone.class);

    public LongTimeWithTimeZoneType(int precision) {
        super(precision, LongTimeWithTimeZone.class);
        if (precision < 10 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [%s, %s]", 10, 12));
        }
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 12;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Fixed12BlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Fixed12BlockBuilder(null, positionCount);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            ((Fixed12BlockBuilder)blockBuilder).writeFixed12(LongTimeWithTimeZoneType.getPicos(block, position), LongTimeWithTimeZoneType.getOffsetMinutes(block, position));
        }
    }

    @Override
    public Object getObject(Block block, int position) {
        return new LongTimeWithTimeZone(LongTimeWithTimeZoneType.getPicos(block, position), LongTimeWithTimeZoneType.getOffsetMinutes(block, position));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LongTimeWithTimeZone timestamp = (LongTimeWithTimeZone)value;
        ((Fixed12BlockBuilder)blockBuilder).writeFixed12(timestamp.getPicoseconds(), timestamp.getOffsetMinutes());
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return SqlTimeWithTimeZone.newInstance(this.getPrecision(), LongTimeWithTimeZoneType.getPicos(block, position), LongTimeWithTimeZoneType.getOffsetMinutes(block, position));
    }

    private static long getPicos(Block block, int position) {
        return block.getLong(position, 0);
    }

    private static int getOffsetMinutes(Block block, int position) {
        return block.getInt(position, 8);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(LongTimeWithTimeZone left, LongTimeWithTimeZone right) {
        return LongTimeWithTimeZoneType.equal(left.getPicoseconds(), left.getOffsetMinutes(), right.getPicoseconds(), right.getOffsetMinutes());
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimeWithTimeZoneType.equal(LongTimeWithTimeZoneType.getPicos(leftBlock, leftPosition), LongTimeWithTimeZoneType.getOffsetMinutes(leftBlock, leftPosition), LongTimeWithTimeZoneType.getPicos(rightBlock, rightPosition), LongTimeWithTimeZoneType.getOffsetMinutes(rightBlock, rightPosition));
    }

    private static boolean equal(long leftPicos, int leftOffsetMinutes, long rightPicos, int rightOffsetMinutes) {
        return TimeWithTimeZoneTypes.normalizePicos(leftPicos, leftOffsetMinutes) == TimeWithTimeZoneTypes.normalizePicos(rightPicos, rightOffsetMinutes);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(LongTimeWithTimeZone value) {
        return LongTimeWithTimeZoneType.hashCodeOperator(value.getPicoseconds(), value.getOffsetMinutes());
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(@BlockPosition Block block, @BlockIndex int position) {
        return LongTimeWithTimeZoneType.hashCodeOperator(LongTimeWithTimeZoneType.getPicos(block, position), LongTimeWithTimeZoneType.getOffsetMinutes(block, position));
    }

    private static long hashCodeOperator(long picos, int offsetMinutes) {
        return AbstractLongType.hash(TimeWithTimeZoneTypes.normalizePicos(picos, offsetMinutes));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(LongTimeWithTimeZone value) {
        return LongTimeWithTimeZoneType.xxHash64(value.getPicoseconds(), value.getOffsetMinutes());
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return LongTimeWithTimeZoneType.xxHash64(LongTimeWithTimeZoneType.getPicos(block, position), LongTimeWithTimeZoneType.getOffsetMinutes(block, position));
    }

    private static long xxHash64(long picos, int offsetMinutes) {
        return XxHash64.hash((long)TimeWithTimeZoneTypes.normalizePicos(picos, offsetMinutes));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(LongTimeWithTimeZone left, LongTimeWithTimeZone right) {
        return LongTimeWithTimeZoneType.comparison(left.getPicoseconds(), left.getOffsetMinutes(), right.getPicoseconds(), right.getOffsetMinutes());
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimeWithTimeZoneType.comparison(LongTimeWithTimeZoneType.getPicos(leftBlock, leftPosition), LongTimeWithTimeZoneType.getOffsetMinutes(leftBlock, leftPosition), LongTimeWithTimeZoneType.getPicos(rightBlock, rightPosition), LongTimeWithTimeZoneType.getOffsetMinutes(rightBlock, rightPosition));
    }

    private static long comparison(long leftPicos, int leftOffsetMinutes, long rightPicos, int rightOffsetMinutes) {
        return Long.compare(TimeWithTimeZoneTypes.normalizePicos(leftPicos, leftOffsetMinutes), TimeWithTimeZoneTypes.normalizePicos(rightPicos, rightOffsetMinutes));
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(LongTimeWithTimeZone left, LongTimeWithTimeZone right) {
        return LongTimeWithTimeZoneType.lessThan(left.getPicoseconds(), left.getOffsetMinutes(), right.getPicoseconds(), right.getOffsetMinutes());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimeWithTimeZoneType.lessThan(LongTimeWithTimeZoneType.getPicos(leftBlock, leftPosition), LongTimeWithTimeZoneType.getOffsetMinutes(leftBlock, leftPosition), LongTimeWithTimeZoneType.getPicos(rightBlock, rightPosition), LongTimeWithTimeZoneType.getOffsetMinutes(rightBlock, rightPosition));
    }

    private static boolean lessThan(long leftPicos, int leftOffsetMinutes, long rightPicos, int rightOffsetMinutes) {
        return TimeWithTimeZoneTypes.normalizePicos(leftPicos, leftOffsetMinutes) < TimeWithTimeZoneTypes.normalizePicos(rightPicos, rightOffsetMinutes);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(LongTimeWithTimeZone left, LongTimeWithTimeZone right) {
        return LongTimeWithTimeZoneType.lessThanOrEqual(left.getPicoseconds(), left.getOffsetMinutes(), right.getPicoseconds(), right.getOffsetMinutes());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimeWithTimeZoneType.lessThanOrEqual(LongTimeWithTimeZoneType.getPicos(leftBlock, leftPosition), LongTimeWithTimeZoneType.getOffsetMinutes(leftBlock, leftPosition), LongTimeWithTimeZoneType.getPicos(rightBlock, rightPosition), LongTimeWithTimeZoneType.getOffsetMinutes(rightBlock, rightPosition));
    }

    private static boolean lessThanOrEqual(long leftPicos, int leftOffsetMinutes, long rightPicos, int rightOffsetMinutes) {
        return TimeWithTimeZoneTypes.normalizePicos(leftPicos, leftOffsetMinutes) <= TimeWithTimeZoneTypes.normalizePicos(rightPicos, rightOffsetMinutes);
    }
}

