/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.Fixed12BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandles;
import java.util.Optional;

final class LongTimestampWithTimeZoneType
extends TimestampWithTimeZoneType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(LongTimestampWithTimeZoneType.class, MethodHandles.lookup(), LongTimestampWithTimeZone.class);

    public LongTimestampWithTimeZoneType(int precision) {
        super(precision, LongTimestampWithTimeZone.class);
        if (precision < 4 || precision > 12) {
            throw new IllegalArgumentException(String.format("Precision must be in the range [%s, %s]", 4, 12));
        }
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public int getFixedSize() {
        return 12;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Fixed12BlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Fixed12BlockBuilder(null, positionCount);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            ((Fixed12BlockBuilder)blockBuilder).writeFixed12(LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position), LongTimestampWithTimeZoneType.getPicosOfMilli(block, position));
        }
    }

    @Override
    public Object getObject(Block block, int position) {
        long packedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position);
        int picosOfMilli = LongTimestampWithTimeZoneType.getPicosOfMilli(block, position);
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction(DateTimeEncoding.unpackMillisUtc(packedEpochMillis), picosOfMilli, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LongTimestampWithTimeZone timestamp = (LongTimestampWithTimeZone)value;
        ((Fixed12BlockBuilder)blockBuilder).writeFixed12(DateTimeEncoding.packDateTimeWithZone(timestamp.getEpochMillis(), timestamp.getTimeZoneKey()), timestamp.getPicosOfMilli());
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long packedEpochMillis = LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position);
        int picosOfMilli = LongTimestampWithTimeZoneType.getPicosOfMilli(block, position);
        return SqlTimestampWithTimeZone.newInstance(this.getPrecision(), DateTimeEncoding.unpackMillisUtc(packedEpochMillis), picosOfMilli, DateTimeEncoding.unpackZoneKey(packedEpochMillis));
    }

    @Override
    public Optional<Object> getPreviousValue(Object value) {
        LongTimestampWithTimeZone timestampWithTimeZone = (LongTimestampWithTimeZone)value;
        long epochMillis = timestampWithTimeZone.getEpochMillis();
        int picosOfMilli = timestampWithTimeZone.getPicosOfMilli();
        if ((picosOfMilli -= Math.toIntExact(Timestamps.rescale(1L, 0, 12 - this.getPrecision()))) < 0) {
            if (epochMillis == Long.MIN_VALUE) {
                return Optional.empty();
            }
            --epochMillis;
            picosOfMilli += 1000000000;
        }
        return Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction(epochMillis, picosOfMilli, TimeZoneKey.UTC_KEY));
    }

    @Override
    public Optional<Object> getNextValue(Object value) {
        LongTimestampWithTimeZone timestampWithTimeZone = (LongTimestampWithTimeZone)value;
        long epochMillis = timestampWithTimeZone.getEpochMillis();
        int picosOfMilli = timestampWithTimeZone.getPicosOfMilli();
        if ((picosOfMilli += Math.toIntExact(Timestamps.rescale(1L, 0, 12 - this.getPrecision()))) >= 1000000000) {
            if (epochMillis == Long.MAX_VALUE) {
                return Optional.empty();
            }
            --epochMillis;
            picosOfMilli -= 1000000000;
        }
        return Optional.of(LongTimestampWithTimeZone.fromEpochMillisAndFraction(epochMillis, picosOfMilli, TimeZoneKey.UTC_KEY));
    }

    private static long getPackedEpochMillis(Block block, int position) {
        return block.getLong(position, 0);
    }

    private static long getEpochMillis(Block block, int position) {
        return DateTimeEncoding.unpackMillisUtc(LongTimestampWithTimeZoneType.getPackedEpochMillis(block, position));
    }

    private static int getPicosOfMilli(Block block, int position) {
        return block.getInt(position, 8);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.equal(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.equal(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(rightBlock, rightPosition));
    }

    private static boolean equal(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        return leftEpochMillis == rightEpochMillis && leftPicosOfMilli == rightPicosOfMilli;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(LongTimestampWithTimeZone value) {
        return LongTimestampWithTimeZoneType.xxHash64(value.getEpochMillis(), value.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return LongTimestampWithTimeZoneType.xxHash64(LongTimestampWithTimeZoneType.getEpochMillis(block, position), LongTimestampWithTimeZoneType.getPicosOfMilli(block, position));
    }

    private static long xxHash64(long epochMillis, int picosOfMilli) {
        return XxHash64.hash((long)epochMillis) ^ XxHash64.hash((long)picosOfMilli);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.comparison(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.comparison(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(rightBlock, rightPosition));
    }

    private static int comparison(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        int value = Long.compare(leftEpochMillis, rightEpochMillis);
        if (value != 0) {
            return value;
        }
        return Integer.compare(leftPicosOfMilli, rightPicosOfMilli);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.lessThan(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.lessThan(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(rightBlock, rightPosition));
    }

    private static boolean lessThan(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        return leftEpochMillis < rightEpochMillis || leftEpochMillis == rightEpochMillis && leftPicosOfMilli < rightPicosOfMilli;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(LongTimestampWithTimeZone left, LongTimestampWithTimeZone right) {
        return LongTimestampWithTimeZoneType.lessThanOrEqual(left.getEpochMillis(), left.getPicosOfMilli(), right.getEpochMillis(), right.getPicosOfMilli());
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return LongTimestampWithTimeZoneType.lessThanOrEqual(LongTimestampWithTimeZoneType.getEpochMillis(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(leftBlock, leftPosition), LongTimestampWithTimeZoneType.getEpochMillis(rightBlock, rightPosition), LongTimestampWithTimeZoneType.getPicosOfMilli(rightBlock, rightPosition));
    }

    private static boolean lessThanOrEqual(long leftEpochMillis, int leftPicosOfMilli, long rightEpochMillis, int rightPicosOfMilli) {
        return leftEpochMillis < rightEpochMillis || leftEpochMillis == rightEpochMillis && leftPicosOfMilli <= rightPicosOfMilli;
    }
}

