/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractIntType;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.util.Optional;

public final class RealType
extends AbstractIntType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(RealType.class, MethodHandles.lookup(), Long.TYPE);
    public static final RealType REAL = new RealType();

    private RealType() {
        super(new TypeSignature("real", new TypeSignatureParameter[0]));
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return Float.valueOf(this.getFloat(block, position));
    }

    public float getFloat(Block block, int position) {
        return Float.intBitsToFloat(block.getInt(position, 0));
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        int floatValue;
        try {
            floatValue = Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value (%sb) is not a valid single-precision float", Long.toBinaryString(value)));
        }
        this.writeInt(blockBuilder, floatValue);
    }

    public void writeFloat(BlockBuilder blockBuilder, float value) {
        this.writeInt(blockBuilder, Float.floatToIntBits(value));
    }

    @Override
    public boolean equals(Object other) {
        return other == REAL;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.empty();
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return Float.intBitsToFloat((int)left) == Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        float realValue = Float.intBitsToFloat((int)value);
        if (realValue == 0.0f) {
            realValue = 0.0f;
        }
        return AbstractLongType.hash(Float.floatToIntBits(realValue));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        float realValue = Float.intBitsToFloat((int)value);
        if (realValue == 0.0f) {
            realValue = 0.0f;
        }
        return XxHash64.hash((long)Float.floatToIntBits(realValue));
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    private static boolean distinctFromOperator(long left, @IsNull boolean leftNull, long right, @IsNull boolean rightNull) {
        if (leftNull || rightNull) {
            return leftNull != rightNull;
        }
        float leftFloat = Float.intBitsToFloat((int)left);
        float rightFloat = Float.intBitsToFloat((int)right);
        if (Float.isNaN(leftFloat) && Float.isNaN(rightFloat)) {
            return false;
        }
        return leftFloat != rightFloat;
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonUnorderedLastOperator(long left, long right) {
        return Float.compare(Float.intBitsToFloat((int)left), Float.intBitsToFloat((int)right));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_FIRST)
    private static long comparisonUnorderedFirstOperator(long leftBits, long rightBits) {
        float left = Float.intBitsToFloat((int)leftBits);
        float right = Float.intBitsToFloat((int)rightBits);
        if (Float.isNaN(left) && Float.isNaN(right)) {
            return 0L;
        }
        if (Float.isNaN(left)) {
            return -1L;
        }
        if (Float.isNaN(right)) {
            return 1L;
        }
        return Float.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return Float.intBitsToFloat((int)left) < Float.intBitsToFloat((int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return Float.intBitsToFloat((int)left) <= Float.intBitsToFloat((int)right);
    }
}

