/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.Fixed12BlockBuilder;

public class Fixed12BlockEncoding
implements BlockEncoding {
    public static final String NAME = "FIXED12";

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            if (block instanceof Fixed12Block) {
                Fixed12Block valueBlock = (Fixed12Block)block;
                sliceOutput.writeInts(valueBlock.getRawValues(), valueBlock.getPositionOffset() * 3, valueBlock.getPositionCount() * 3);
                return;
            } else {
                if (!(block instanceof Fixed12BlockBuilder)) throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
                Fixed12BlockBuilder blockBuilder = (Fixed12BlockBuilder)((Object)block);
                sliceOutput.writeInts(blockBuilder.getRawValues(), 0, blockBuilder.getPositionCount() * 3);
            }
            return;
        } else {
            int[] valuesWithoutNull = new int[positionCount * 3];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = block.getInt(i, 0);
                valuesWithoutNull[nonNullPositionCount + 1] = block.getInt(i, 4);
                valuesWithoutNull[nonNullPositionCount + 2] = block.getInt(i, 8);
                if (block.isNull(i)) continue;
                nonNullPositionCount += 3;
            }
            sliceOutput.writeInt(nonNullPositionCount / 3);
            sliceOutput.writeInts(valuesWithoutNull, 0, nonNullPositionCount);
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        int[] values = new int[positionCount * 3];
        if (valueIsNull == null) {
            sliceInput.readInts(values);
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readInts(values, 0, nonNullPositionCount * 3);
            int position = 3 * (nonNullPositionCount - 1);
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                System.arraycopy(values, position, values, 3 * i, 3);
                if (valueIsNull[i]) continue;
                position -= 3;
            }
        }
        return new Fixed12Block(0, positionCount, valueIsNull, values);
    }
}

