/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.Int128ArrayBlockBuilder;

public class Int128ArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT128_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            if (block instanceof Int128ArrayBlock) {
                Int128ArrayBlock valueBlock = (Int128ArrayBlock)block;
                sliceOutput.writeLongs(valueBlock.getRawValues(), valueBlock.getPositionOffset() * 2, valueBlock.getPositionCount() * 2);
                return;
            } else {
                if (!(block instanceof Int128ArrayBlockBuilder)) throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
                Int128ArrayBlockBuilder blockBuilder = (Int128ArrayBlockBuilder)((Object)block);
                sliceOutput.writeLongs(blockBuilder.getRawValues(), 0, blockBuilder.getPositionCount() * 2);
            }
            return;
        } else {
            long[] valuesWithoutNull = new long[positionCount * 2];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = block.getLong(i, 0);
                valuesWithoutNull[nonNullPositionCount + 1] = block.getLong(i, 8);
                if (block.isNull(i)) continue;
                nonNullPositionCount += 2;
            }
            sliceOutput.writeInt(nonNullPositionCount / 2);
            sliceOutput.writeLongs(valuesWithoutNull, 0, nonNullPositionCount);
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] values = new long[positionCount * 2];
        if (valueIsNull == null) {
            sliceInput.readLongs(values);
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readLongs(values, 0, nonNullPositionCount * 2);
            int position = 2 * (nonNullPositionCount - 1);
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                System.arraycopy(values, position, values, 2 * i, 2);
                if (valueIsNull[i]) continue;
                position -= 2;
            }
        }
        return new Int128ArrayBlock(0, positionCount, valueIsNull, values);
    }
}

