/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;

public class LongArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(LongArrayBlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new LongArrayBlock(0, 1, new boolean[]{true}, new long[1]);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private long[] values = new long[0];
    private long retainedSizeInBytes;

    public LongArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    public BlockBuilder writeLong(long value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(9);
        }
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(9);
        }
        return this;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return new LongArrayBlock(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new LongArrayBlockBuilder(blockBuilderStatus, expectedEntries);
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((long[])this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public long getSizeInBytes() {
        return 9L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LongArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    long[] getRawValues() {
        return this.values;
    }
}

