/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.SqlRow;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public class RowBlock
implements Block {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RowBlock.class);
    private final int numFields;
    private final int startOffset;
    private final int positionCount;
    private final boolean[] rowIsNull;
    private final int[] fieldBlockOffsets;
    private final Block[] fieldBlocks;
    private final List<Block> fieldBlocksList;
    private volatile long sizeInBytes = -1L;
    private final long retainedSizeInBytes;

    public static Block fromFieldBlocks(int positionCount, Optional<boolean[]> rowIsNullOptional, Block[] fieldBlocks) {
        boolean[] rowIsNull = rowIsNullOptional.orElse(null);
        int[] fieldBlockOffsets = null;
        if (rowIsNull != null) {
            fieldBlockOffsets = new int[positionCount + 1];
            fieldBlockOffsets[0] = 0;
            for (int position = 0; position < positionCount; ++position) {
                fieldBlockOffsets[position + 1] = fieldBlockOffsets[position] + (rowIsNull[position] ? 0 : 1);
            }
            if (fieldBlockOffsets[positionCount] == positionCount) {
                rowIsNull = null;
                fieldBlockOffsets = null;
            }
        }
        RowBlock.validateConstructorArguments(0, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
        return new RowBlock(0, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }

    static RowBlock createRowBlockInternal(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, @Nullable int[] fieldBlockOffsets, Block[] fieldBlocks) {
        RowBlock.validateConstructorArguments(startOffset, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
        return new RowBlock(startOffset, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }

    private static void validateConstructorArguments(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, @Nullable int[] fieldBlockOffsets, Block[] fieldBlocks) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (rowIsNull != null && rowIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("rowIsNull length is less than positionCount");
        }
        if (rowIsNull == null != (fieldBlockOffsets == null)) {
            throw new IllegalArgumentException("When rowIsNull is (non) null then fieldBlockOffsets should be (non) null as well");
        }
        if (fieldBlockOffsets != null && fieldBlockOffsets.length - startOffset < positionCount + 1) {
            throw new IllegalArgumentException("fieldBlockOffsets length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlocks, "fieldBlocks is null");
        if (fieldBlocks.length == 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        int firstFieldBlockPositionCount = fieldBlocks[0].getPositionCount();
        for (int i = 1; i < fieldBlocks.length; ++i) {
            if (firstFieldBlockPositionCount == fieldBlocks[i].getPositionCount()) continue;
            throw new IllegalArgumentException(String.format("length of field blocks differ: field 0: %s, block %s: %s", firstFieldBlockPositionCount, i, fieldBlocks[i].getPositionCount()));
        }
    }

    private RowBlock(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, @Nullable int[] fieldBlockOffsets, Block[] fieldBlocks) {
        if (fieldBlocks.length == 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        this.numFields = fieldBlocks.length;
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.rowIsNull = rowIsNull;
        this.fieldBlockOffsets = fieldBlockOffsets;
        this.fieldBlocks = fieldBlocks;
        this.fieldBlocksList = List.of(fieldBlocks);
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])fieldBlockOffsets) + SizeOf.sizeOf((boolean[])rowIsNull);
    }

    protected List<Block> getRawFieldBlocks() {
        return this.fieldBlocksList;
    }

    @Nullable
    protected int[] getFieldBlockOffsets() {
        return this.fieldBlockOffsets;
    }

    protected int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    public boolean mayHaveNull() {
        return this.rowIsNull != null;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes >= 0L) {
            return this.sizeInBytes;
        }
        long sizeInBytes = 5L * (long)this.positionCount;
        boolean hasUnloadedBlocks = false;
        int startFieldBlockOffset = this.fieldBlockOffsets != null ? this.fieldBlockOffsets[this.startOffset] : this.startOffset;
        int endFieldBlockOffset = this.fieldBlockOffsets != null ? this.fieldBlockOffsets[this.startOffset + this.positionCount] : this.startOffset + this.positionCount;
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        for (Block fieldBlock : this.fieldBlocks) {
            sizeInBytes += fieldBlock.getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
            hasUnloadedBlocks = hasUnloadedBlocks || !fieldBlock.isLoaded();
        }
        if (!hasUnloadedBlocks) {
            this.sizeInBytes = sizeInBytes;
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = this.retainedSizeInBytes;
        for (Block fieldBlock : this.fieldBlocks) {
            retainedSizeInBytes += fieldBlock.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        for (int i = 0; i < this.numFields; ++i) {
            consumer.accept(this.fieldBlocks[i], this.fieldBlocks[i].getRetainedSizeInBytes());
        }
        if (this.fieldBlockOffsets != null) {
            consumer.accept(this.fieldBlockOffsets, SizeOf.sizeOf((int[])this.fieldBlockOffsets));
        }
        if (this.rowIsNull != null) {
            consumer.accept(this.rowIsNull, SizeOf.sizeOf((boolean[])this.rowIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    public String toString() {
        return String.format("RowBlock{numFields=%d, positionCount=%d}", this.numFields, this.getPositionCount());
    }

    @Override
    public boolean isLoaded() {
        for (Block fieldBlock : this.fieldBlocks) {
            if (fieldBlock.isLoaded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Block getLoadedBlock() {
        Block[] loadedFieldBlocks = BlockUtil.ensureBlocksAreLoaded(this.fieldBlocks);
        if (loadedFieldBlocks == this.fieldBlocks) {
            return this;
        }
        return RowBlock.createRowBlockInternal(this.startOffset, this.positionCount, this.rowIsNull, this.fieldBlockOffsets, loadedFieldBlocks);
    }

    @Override
    public Block copyWithAppendedNull() {
        int[] newOffsets;
        boolean[] newRowIsNull = BlockUtil.copyIsNullAndAppendNull(this.rowIsNull, this.startOffset, this.getPositionCount());
        if (this.fieldBlockOffsets == null) {
            int desiredLength = this.startOffset + this.positionCount + 2;
            newOffsets = new int[desiredLength];
            newOffsets[this.startOffset] = this.startOffset;
            for (int position = this.startOffset; position < this.startOffset + this.positionCount; ++position) {
                newOffsets[position + 1] = newOffsets[position] + 1;
            }
            newOffsets[desiredLength - 1] = newOffsets[desiredLength - 2];
        } else {
            newOffsets = BlockUtil.copyOffsetsAndAppendNull(this.fieldBlockOffsets, this.startOffset, this.getPositionCount());
        }
        return RowBlock.createRowBlockInternal(this.startOffset, this.getPositionCount() + 1, newRowIsNull, newOffsets, this.fieldBlocks);
    }

    @Override
    public final List<Block> getChildren() {
        return List.of(this.fieldBlocks);
    }

    public final int getFieldBlockOffset(int position) {
        int[] offsets = this.fieldBlockOffsets;
        if (offsets != null) {
            return offsets[position + this.startOffset];
        }
        return position + this.startOffset;
    }

    @Override
    public String getEncodingName() {
        return "ROW";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        int fieldBlockPositionCount;
        boolean[] newRowIsNull;
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = null;
        int[] fieldBlockPositions = new int[length];
        if (this.rowIsNull == null) {
            newRowIsNull = null;
            for (i = 0; i < fieldBlockPositions.length; ++i) {
                position = positions[offset + i];
                BlockUtil.checkReadablePosition(this, position);
                fieldBlockPositions[i] = this.getFieldBlockOffset(position);
            }
            fieldBlockPositionCount = fieldBlockPositions.length;
        } else {
            newRowIsNull = new boolean[length];
            newOffsets = new int[length + 1];
            fieldBlockPositionCount = 0;
            for (i = 0; i < length; ++i) {
                boolean positionIsNull;
                newOffsets[i] = fieldBlockPositionCount;
                position = positions[offset + i];
                newRowIsNull[i] = positionIsNull = this.isNull(position);
                fieldBlockPositions[fieldBlockPositionCount] = this.getFieldBlockOffset(position);
                fieldBlockPositionCount += positionIsNull ? 0 : 1;
            }
            newOffsets[length] = fieldBlockPositionCount;
            if (fieldBlockPositionCount == length) {
                newRowIsNull = null;
                newOffsets = null;
            }
        }
        Block[] newBlocks = new Block[this.numFields];
        Block[] rawBlocks = this.fieldBlocks;
        for (int i = 0; i < newBlocks.length; ++i) {
            newBlocks[i] = rawBlocks[i].copyPositions(fieldBlockPositions, 0, fieldBlockPositionCount);
        }
        return RowBlock.createRowBlockInternal(0, length, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return RowBlock.createRowBlockInternal(position + this.startOffset, length, this.rowIsNull, this.fieldBlockOffsets, this.fieldBlocks);
    }

    @Override
    public final OptionalInt fixedSizeInBytesPerPosition() {
        OptionalInt fieldSize;
        if (!this.mayHaveNull() && (fieldSize = this.fixedSizeInBytesPerFieldPosition()).isPresent()) {
            return OptionalInt.of(fieldSize.getAsInt() + 5);
        }
        return OptionalInt.empty();
    }

    private OptionalInt fixedSizeInBytesPerFieldPosition() {
        Block[] rawFieldBlocks = this.fieldBlocks;
        int fixedSizePerRow = 0;
        for (int i = 0; i < this.numFields; ++i) {
            OptionalInt fieldFixedSize = rawFieldBlocks[i].fixedSizeInBytesPerPosition();
            if (fieldFixedSize.isEmpty()) {
                return OptionalInt.empty();
            }
            fixedSizePerRow += fieldFixedSize.getAsInt();
        }
        return OptionalInt.of(fixedSizePerRow);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        long regionSizeInBytes = 5L * (long)length;
        for (int i = 0; i < this.numFields; ++i) {
            regionSizeInBytes += this.fieldBlocks[i].getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
        }
        return regionSizeInBytes;
    }

    @Override
    public final long getPositionsSizeInBytes(boolean[] positions, int selectedRowPositions) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidPositions(positions, positionCount);
        if (selectedRowPositions == 0) {
            return 0L;
        }
        if (selectedRowPositions == positionCount) {
            return this.getSizeInBytes();
        }
        OptionalInt fixedSizePerFieldPosition = this.fixedSizeInBytesPerFieldPosition();
        if (fixedSizePerFieldPosition.isPresent()) {
            int selectedFieldPositionCount = selectedRowPositions;
            boolean[] rowIsNull = this.rowIsNull;
            if (rowIsNull != null) {
                int offsetBase = this.startOffset;
                for (int i = 0; i < positions.length; ++i) {
                    if (!positions[i] || !rowIsNull[i + offsetBase]) continue;
                    --selectedFieldPositionCount;
                }
                if (selectedFieldPositionCount < 0) {
                    throw new IllegalStateException("Invalid field position selection after nulls removed: " + selectedFieldPositionCount);
                }
            }
            return 5L * (long)selectedRowPositions + (long)fixedSizePerFieldPosition.getAsInt() * (long)selectedFieldPositionCount;
        }
        return this.getSpecificPositionsSizeInBytes(positions, selectedRowPositions);
    }

    private long getSpecificPositionsSizeInBytes(boolean[] positions, int selectedRowPositions) {
        boolean[] fieldPositions;
        int selectedFieldPositionCount;
        int positionCount = this.getPositionCount();
        int offsetBase = this.startOffset;
        boolean[] rowIsNull = this.rowIsNull;
        int totalFieldPositions = this.fieldBlocks[0].getPositionCount();
        if (rowIsNull == null) {
            selectedFieldPositionCount = selectedRowPositions;
            if (offsetBase == 0 && positionCount == totalFieldPositions) {
                fieldPositions = positions;
            } else {
                fieldPositions = new boolean[totalFieldPositions];
                System.arraycopy(positions, 0, fieldPositions, offsetBase, positions.length);
            }
        } else {
            fieldPositions = new boolean[totalFieldPositions];
            selectedFieldPositionCount = 0;
            for (int i = 0; i < positions.length; ++i) {
                if (!positions[i] || rowIsNull[offsetBase + i]) continue;
                ++selectedFieldPositionCount;
                fieldPositions[this.getFieldBlockOffset((int)i)] = true;
            }
        }
        Block[] rawFieldBlocks = this.fieldBlocks;
        long sizeInBytes = 5L * (long)selectedRowPositions;
        for (int j = 0; j < this.numFields; ++j) {
            sizeInBytes += rawFieldBlocks[j].getPositionsSizeInBytes(fieldPositions, selectedFieldPositionCount);
        }
        return sizeInBytes;
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + length);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Object[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.fieldBlocks[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        int[] fieldBlockOffsets = this.fieldBlockOffsets;
        int[] newOffsets = fieldBlockOffsets == null ? null : BlockUtil.compactOffsets(fieldBlockOffsets, position + this.startOffset, length);
        boolean[] rowIsNull = this.rowIsNull;
        boolean[] newRowIsNull = rowIsNull == null ? null : BlockUtil.compactArray(rowIsNull, position + this.startOffset, length);
        if (BlockUtil.arraySame(newBlocks, this.fieldBlocks) && newOffsets == fieldBlockOffsets && newRowIsNull == rowIsNull) {
            return this;
        }
        return RowBlock.createRowBlockInternal(0, length, newRowIsNull, newOffsets, (Block[])newBlocks);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != SqlRow.class) {
            throw new IllegalArgumentException("clazz must be SqlRow.class");
        }
        BlockUtil.checkReadablePosition(this, position);
        return clazz.cast(new SqlRow(this.getFieldBlockOffset(position), this.fieldBlocks));
    }

    @Override
    public Block getSingleValueBlock(int position) {
        int[] nArray;
        boolean[] newRowIsNull;
        BlockUtil.checkReadablePosition(this, position);
        int startFieldBlockOffset = this.getFieldBlockOffset(position);
        int endFieldBlockOffset = this.getFieldBlockOffset(position + 1);
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        Block[] newBlocks = new Block[this.numFields];
        for (int i = 0; i < this.numFields; ++i) {
            newBlocks[i] = this.fieldBlocks[i].copyRegion(startFieldBlockOffset, fieldBlockLength);
        }
        if (this.isNull(position)) {
            boolean[] blArray = new boolean[1];
            v1 = blArray;
            blArray[0] = true;
        } else {
            v1 = newRowIsNull = null;
        }
        if (this.isNull(position)) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = fieldBlockLength;
        } else {
            nArray = null;
        }
        int[] newOffsets = nArray;
        return RowBlock.createRowBlockInternal(0, 1, newRowIsNull, newOffsets, newBlocks);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            return 0L;
        }
        Block[] rawFieldBlocks = this.fieldBlocks;
        long size = 0L;
        for (int i = 0; i < this.numFields; ++i) {
            size += rawFieldBlocks[i].getEstimatedDataSizeForStats(this.getFieldBlockOffset(position));
        }
        return size;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        boolean[] rowIsNull = this.rowIsNull;
        if (rowIsNull == null) {
            return false;
        }
        return rowIsNull[position + this.startOffset];
    }
}

