/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.RowBlock;
import java.util.List;

public class RowBlockEncoding
implements BlockEncoding {
    public static final String NAME = "ROW";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        RowBlock rowBlock = (RowBlock)block;
        int[] fieldBlockOffsets = rowBlock.getFieldBlockOffsets();
        int positionCount = rowBlock.getPositionCount();
        int offsetBase = rowBlock.getOffsetBase();
        int startFieldBlockOffset = fieldBlockOffsets != null ? fieldBlockOffsets[offsetBase] : offsetBase;
        int endFieldBlockOffset = fieldBlockOffsets != null ? fieldBlockOffsets[offsetBase + positionCount] : offsetBase + positionCount;
        List<Block> rawFieldBlocks = rowBlock.getRawFieldBlocks();
        sliceOutput.appendInt(rawFieldBlocks.size());
        sliceOutput.appendInt(positionCount);
        for (Block rawFieldBlock : rawFieldBlocks) {
            blockEncodingSerde.writeBlock(sliceOutput, rawFieldBlock.getRegion(startFieldBlockOffset, endFieldBlockOffset - startFieldBlockOffset));
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (rowBlock.mayHaveNull() == (fieldBlockOffsets == null)) {
            throw new IllegalArgumentException("When rowIsNull is (non) null then fieldBlockOffsets should be (non) null as well");
        }
        if (fieldBlockOffsets != null) {
            if (startFieldBlockOffset == 0) {
                sliceOutput.writeInts(fieldBlockOffsets, offsetBase, positionCount + 1);
            } else {
                int[] newFieldBlockOffsets = new int[positionCount + 1];
                for (int position = 0; position < positionCount + 1; ++position) {
                    newFieldBlockOffsets[position] = fieldBlockOffsets[offsetBase + position] - startFieldBlockOffset;
                }
                sliceOutput.writeInts(newFieldBlockOffsets);
            }
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int numFields = sliceInput.readInt();
        int positionCount = sliceInput.readInt();
        Block[] fieldBlocks = new Block[numFields];
        for (int i = 0; i < numFields; ++i) {
            fieldBlocks[i] = blockEncodingSerde.readBlock(sliceInput);
        }
        boolean[] rowIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        int[] fieldBlockOffsets = null;
        if (rowIsNull != null) {
            fieldBlockOffsets = new int[positionCount + 1];
            sliceInput.readInts(fieldBlockOffsets);
        }
        return RowBlock.createRowBlockInternal(0, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }
}

