/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.SchemaUtil;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ColumnMetadata {
    private final String name;
    private final Type type;
    private final boolean nullable;
    private final String comment;
    private final String extraInfo;
    private final boolean hidden;
    private final Map<String, Object> properties;

    public ColumnMetadata(String name, Type type) {
        this(name, type, true, null, null, false, Collections.emptyMap());
    }

    private ColumnMetadata(String name, Type type, boolean nullable, String comment, String extraInfo, boolean hidden, Map<String, Object> properties) {
        SchemaUtil.checkNotEmpty(name, "name");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(properties, "properties is null");
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.type = type;
        this.comment = comment;
        this.extraInfo = extraInfo;
        this.hidden = hidden;
        this.properties = properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
        this.nullable = nullable;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public String getExtraInfo() {
        return this.extraInfo;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ColumnSchema getColumnSchema() {
        return ColumnSchema.builder(this).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnMetadata{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", type=").append(this.type);
        sb.append(", ").append(this.nullable ? "nullable" : "nonnull");
        if (this.comment != null) {
            sb.append(", comment='").append(this.comment).append('\'');
        }
        if (this.extraInfo != null) {
            sb.append(", extraInfo='").append(this.extraInfo).append('\'');
        }
        if (this.hidden) {
            sb.append(", hidden");
        }
        if (!this.properties.isEmpty()) {
            sb.append(", properties=").append(this.properties);
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.nullable, this.comment, this.extraInfo, this.hidden);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnMetadata other = (ColumnMetadata)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.nullable, other.nullable) && Objects.equals(this.comment, other.comment) && Objects.equals(this.extraInfo, other.extraInfo) && Objects.equals(this.hidden, other.hidden);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(ColumnMetadata columnMetadata) {
        return new Builder(columnMetadata);
    }

    public static class Builder {
        private String name;
        private Type type;
        private boolean nullable = true;
        private Optional<String> comment = Optional.empty();
        private Optional<String> extraInfo = Optional.empty();
        private boolean hidden;
        private Map<String, Object> properties = Collections.emptyMap();

        private Builder() {
        }

        private Builder(ColumnMetadata columnMetadata) {
            this.name = columnMetadata.getName();
            this.type = columnMetadata.getType();
            this.nullable = columnMetadata.isNullable();
            this.comment = Optional.ofNullable(columnMetadata.getComment());
            this.extraInfo = Optional.ofNullable(columnMetadata.getExtraInfo());
            this.hidden = columnMetadata.isHidden();
            this.properties = columnMetadata.getProperties();
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
            return this;
        }

        public Builder setType(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            return this;
        }

        public Builder setNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder setComment(Optional<String> comment) {
            this.comment = Objects.requireNonNull(comment, "comment is null");
            return this;
        }

        public Builder setExtraInfo(Optional<String> extraInfo) {
            this.extraInfo = Objects.requireNonNull(extraInfo, "extraInfo is null");
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder setProperties(Map<String, Object> properties) {
            this.properties = Objects.requireNonNull(properties, "properties is null");
            return this;
        }

        public ColumnMetadata build() {
            return new ColumnMetadata(this.name, this.type, this.nullable, this.comment.orElse(null), this.extraInfo.orElse(null), this.hidden, this.properties);
        }
    }
}

