/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.ByteArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class TinyintType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(TinyintType.class, MethodHandles.lookup(), Long.TYPE);
    public static final TinyintType TINYINT = new TinyintType();

    private TinyintType() {
        super(new TypeSignature("tinyint", new TypeSignatureParameter[0]), Long.TYPE);
    }

    @Override
    public int getFixedSize() {
        return 1;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ByteArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 1));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 1);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ByteArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getByte(position, 0);
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(new Type.Range(-128L, 127L));
    }

    @Override
    public Optional<Object> getPreviousValue(Object object) {
        long value = (Long)object;
        this.checkValueValid(value);
        if (value == -128L) {
            return Optional.empty();
        }
        return Optional.of(value - 1L);
    }

    @Override
    public Optional<Object> getNextValue(Object object) {
        long value = (Long)object;
        this.checkValueValid(value);
        if (value == 127L) {
            return Optional.empty();
        }
        return Optional.of(value + 1L);
    }

    @Override
    public Optional<Stream<?>> getDiscreteValues(Type.Range range) {
        return Optional.of(LongStream.rangeClosed((Long)range.getMin(), (Long)range.getMax()).boxed());
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeByte(blockBuilder, block.getByte(position, 0));
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return this.getByte(block, position);
    }

    public byte getByte(Block block, int position) {
        return block.getByte(position, 0);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        this.checkValueValid(value);
        this.writeByte(blockBuilder, (byte)value);
    }

    public void writeByte(BlockBuilder blockBuilder, byte value) {
        ((ByteArrayBlockBuilder)blockBuilder).writeByte(value);
    }

    private void checkValueValid(long value) {
        if (value > 127L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d exceeds MAX_BYTE", value));
        }
        if (value < -128L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d is less than MIN_BYTE", value));
        }
    }

    @Override
    public int getFlatFixedSize() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return other == TINYINT;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        return fixedSizeSlice[fixedSizeOffset];
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(long value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        fixedSizeSlice[fixedSizeOffset] = (byte)value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        return AbstractLongType.hash((byte)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        return XxHash64.hash((long)((byte)value));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(long left, long right) {
        return Byte.compare((byte)left, (byte)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return (byte)left < (byte)right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return (byte)left <= (byte)right;
    }
}

