/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.OperatorMethodHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlNullable;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class TypeOperatorDeclaration {
    public static final TypeOperatorDeclaration NO_TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.builder(Boolean.TYPE).build();
    private final Collection<OperatorMethodHandle> readValueOperators;
    private final Collection<OperatorMethodHandle> equalOperators;
    private final Collection<OperatorMethodHandle> hashCodeOperators;
    private final Collection<OperatorMethodHandle> xxHash64Operators;
    private final Collection<OperatorMethodHandle> distinctFromOperators;
    private final Collection<OperatorMethodHandle> indeterminateOperators;
    private final Collection<OperatorMethodHandle> comparisonUnorderedLastOperators;
    private final Collection<OperatorMethodHandle> comparisonUnorderedFirstOperators;
    private final Collection<OperatorMethodHandle> lessThanOperators;
    private final Collection<OperatorMethodHandle> lessThanOrEqualOperators;

    private TypeOperatorDeclaration(Collection<OperatorMethodHandle> readValueOperators, Collection<OperatorMethodHandle> equalOperators, Collection<OperatorMethodHandle> hashCodeOperators, Collection<OperatorMethodHandle> xxHash64Operators, Collection<OperatorMethodHandle> distinctFromOperators, Collection<OperatorMethodHandle> indeterminateOperators, Collection<OperatorMethodHandle> comparisonUnorderedLastOperators, Collection<OperatorMethodHandle> comparisonUnorderedFirstOperators, Collection<OperatorMethodHandle> lessThanOperators, Collection<OperatorMethodHandle> lessThanOrEqualOperators) {
        this.readValueOperators = List.copyOf(Objects.requireNonNull(readValueOperators, "readValueOperators is null"));
        this.equalOperators = List.copyOf(Objects.requireNonNull(equalOperators, "equalOperators is null"));
        this.hashCodeOperators = List.copyOf(Objects.requireNonNull(hashCodeOperators, "hashCodeOperators is null"));
        this.xxHash64Operators = List.copyOf(Objects.requireNonNull(xxHash64Operators, "xxHash64Operators is null"));
        this.distinctFromOperators = List.copyOf(Objects.requireNonNull(distinctFromOperators, "distinctFromOperators is null"));
        this.indeterminateOperators = List.copyOf(Objects.requireNonNull(indeterminateOperators, "indeterminateOperators is null"));
        this.comparisonUnorderedLastOperators = List.copyOf(Objects.requireNonNull(comparisonUnorderedLastOperators, "comparisonUnorderedLastOperators is null"));
        this.comparisonUnorderedFirstOperators = List.copyOf(Objects.requireNonNull(comparisonUnorderedFirstOperators, "comparisonUnorderedFirstOperators is null"));
        this.lessThanOperators = List.copyOf(Objects.requireNonNull(lessThanOperators, "lessThanOperators is null"));
        this.lessThanOrEqualOperators = List.copyOf(Objects.requireNonNull(lessThanOrEqualOperators, "lessThanOrEqualOperators is null"));
    }

    public boolean isComparable() {
        return !this.equalOperators.isEmpty();
    }

    public boolean isOrderable() {
        return !this.comparisonUnorderedLastOperators.isEmpty();
    }

    public Collection<OperatorMethodHandle> getReadValueOperators() {
        return this.readValueOperators;
    }

    public Collection<OperatorMethodHandle> getEqualOperators() {
        return this.equalOperators;
    }

    public Collection<OperatorMethodHandle> getHashCodeOperators() {
        return this.hashCodeOperators;
    }

    public Collection<OperatorMethodHandle> getXxHash64Operators() {
        return this.xxHash64Operators;
    }

    public Collection<OperatorMethodHandle> getDistinctFromOperators() {
        return this.distinctFromOperators;
    }

    public Collection<OperatorMethodHandle> getIndeterminateOperators() {
        return this.indeterminateOperators;
    }

    public Collection<OperatorMethodHandle> getComparisonUnorderedLastOperators() {
        return this.comparisonUnorderedLastOperators;
    }

    public Collection<OperatorMethodHandle> getComparisonUnorderedFirstOperators() {
        return this.comparisonUnorderedFirstOperators;
    }

    public Collection<OperatorMethodHandle> getLessThanOperators() {
        return this.lessThanOperators;
    }

    public Collection<OperatorMethodHandle> getLessThanOrEqualOperators() {
        return this.lessThanOrEqualOperators;
    }

    public static Builder builder(Class<?> typeJavaType) {
        return new Builder(typeJavaType);
    }

    public static TypeOperatorDeclaration extractOperatorDeclaration(Class<?> operatorsClass, MethodHandles.Lookup lookup, Class<?> typeJavaType) {
        return new Builder(typeJavaType).addOperators(operatorsClass, lookup).build();
    }

    public static class Builder {
        private final Class<?> typeJavaType;
        private final Collection<OperatorMethodHandle> readValueOperators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> equalOperators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> hashCodeOperators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> xxHash64Operators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> distinctFromOperators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> indeterminateOperators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> comparisonUnorderedLastOperators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> comparisonUnorderedFirstOperators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> lessThanOperators = new ArrayList<OperatorMethodHandle>();
        private final Collection<OperatorMethodHandle> lessThanOrEqualOperators = new ArrayList<OperatorMethodHandle>();

        private Builder(Class<?> typeJavaType) {
            this.typeJavaType = Objects.requireNonNull(typeJavaType, "typeJavaType is null");
            Builder.checkArgument(!typeJavaType.equals(Void.TYPE), "void type is not supported", new Object[0]);
        }

        public Builder addOperators(TypeOperatorDeclaration operatorDeclaration) {
            operatorDeclaration.getReadValueOperators().forEach(this::addReadValueOperator);
            operatorDeclaration.getEqualOperators().forEach(this::addEqualOperator);
            operatorDeclaration.getHashCodeOperators().forEach(this::addHashCodeOperator);
            operatorDeclaration.getXxHash64Operators().forEach(this::addXxHash64Operator);
            operatorDeclaration.getDistinctFromOperators().forEach(this::addDistinctFromOperator);
            operatorDeclaration.getIndeterminateOperators().forEach(this::addIndeterminateOperator);
            operatorDeclaration.getComparisonUnorderedLastOperators().forEach(this::addComparisonUnorderedLastOperator);
            operatorDeclaration.getComparisonUnorderedFirstOperators().forEach(this::addComparisonUnorderedFirstOperator);
            operatorDeclaration.getLessThanOperators().forEach(this::addLessThanOperator);
            operatorDeclaration.getLessThanOrEqualOperators().forEach(this::addLessThanOrEqualOperator);
            return this;
        }

        public Builder addReadValueOperator(OperatorMethodHandle readValueOperator) {
            this.verifyMethodHandleSignature(1, this.typeJavaType, readValueOperator);
            this.readValueOperators.add(readValueOperator);
            return this;
        }

        public Builder addReadValueOperators(Collection<OperatorMethodHandle> readValueOperators) {
            for (OperatorMethodHandle readValueOperator : readValueOperators) {
                this.verifyMethodHandleSignature(1, this.typeJavaType, readValueOperator);
            }
            this.readValueOperators.addAll(readValueOperators);
            return this;
        }

        public Builder addEqualOperator(OperatorMethodHandle equalOperator) {
            this.verifyMethodHandleSignature(2, Boolean.TYPE, equalOperator);
            this.equalOperators.add(equalOperator);
            return this;
        }

        public Builder addEqualOperators(Collection<OperatorMethodHandle> equalOperators) {
            for (OperatorMethodHandle equalOperator : equalOperators) {
                this.verifyMethodHandleSignature(2, Boolean.TYPE, equalOperator);
            }
            this.equalOperators.addAll(equalOperators);
            return this;
        }

        public Builder addHashCodeOperator(OperatorMethodHandle hashCodeOperator) {
            this.verifyMethodHandleSignature(1, Long.TYPE, hashCodeOperator);
            this.hashCodeOperators.add(hashCodeOperator);
            return this;
        }

        public Builder addHashCodeOperators(Collection<OperatorMethodHandle> hashCodeOperators) {
            for (OperatorMethodHandle hashCodeOperator : hashCodeOperators) {
                this.verifyMethodHandleSignature(1, Long.TYPE, hashCodeOperator);
            }
            this.hashCodeOperators.addAll(hashCodeOperators);
            return this;
        }

        public Builder addXxHash64Operator(OperatorMethodHandle xxHash64Operator) {
            this.verifyMethodHandleSignature(1, Long.TYPE, xxHash64Operator);
            this.xxHash64Operators.add(xxHash64Operator);
            return this;
        }

        public Builder addXxHash64Operators(Collection<OperatorMethodHandle> xxHash64Operators) {
            for (OperatorMethodHandle xxHash64Operator : xxHash64Operators) {
                this.verifyMethodHandleSignature(1, Long.TYPE, xxHash64Operator);
            }
            this.xxHash64Operators.addAll(xxHash64Operators);
            return this;
        }

        public Builder addDistinctFromOperator(OperatorMethodHandle distinctFromOperator) {
            this.verifyMethodHandleSignature(2, Boolean.TYPE, distinctFromOperator);
            this.distinctFromOperators.add(distinctFromOperator);
            return this;
        }

        public Builder addDistinctFromOperators(Collection<OperatorMethodHandle> distinctFromOperators) {
            for (OperatorMethodHandle distinctFromOperator : distinctFromOperators) {
                this.verifyMethodHandleSignature(2, Boolean.TYPE, distinctFromOperator);
            }
            this.distinctFromOperators.addAll(distinctFromOperators);
            return this;
        }

        public Builder addIndeterminateOperator(OperatorMethodHandle indeterminateOperator) {
            this.verifyMethodHandleSignature(1, Boolean.TYPE, indeterminateOperator);
            this.indeterminateOperators.add(indeterminateOperator);
            return this;
        }

        public Builder addIndeterminateOperators(Collection<OperatorMethodHandle> indeterminateOperators) {
            for (OperatorMethodHandle indeterminateOperator : indeterminateOperators) {
                this.verifyMethodHandleSignature(1, Boolean.TYPE, indeterminateOperator);
            }
            this.indeterminateOperators.addAll(indeterminateOperators);
            return this;
        }

        public Builder addComparisonUnorderedLastOperator(OperatorMethodHandle comparisonOperator) {
            this.verifyMethodHandleSignature(2, Long.TYPE, comparisonOperator);
            this.comparisonUnorderedLastOperators.add(comparisonOperator);
            return this;
        }

        public Builder addComparisonUnorderedLastOperators(Collection<OperatorMethodHandle> comparisonOperators) {
            for (OperatorMethodHandle comparisonOperator : comparisonOperators) {
                this.verifyMethodHandleSignature(2, Long.TYPE, comparisonOperator);
            }
            this.comparisonUnorderedLastOperators.addAll(comparisonOperators);
            return this;
        }

        public Builder addComparisonUnorderedFirstOperator(OperatorMethodHandle comparisonOperator) {
            this.verifyMethodHandleSignature(2, Long.TYPE, comparisonOperator);
            this.comparisonUnorderedFirstOperators.add(comparisonOperator);
            return this;
        }

        public Builder addComparisonUnorderedFirstOperators(Collection<OperatorMethodHandle> comparisonOperators) {
            for (OperatorMethodHandle comparisonOperator : comparisonOperators) {
                this.verifyMethodHandleSignature(2, Long.TYPE, comparisonOperator);
            }
            this.comparisonUnorderedFirstOperators.addAll(comparisonOperators);
            return this;
        }

        public Builder addLessThanOrEqualOperator(OperatorMethodHandle lessThanOrEqualOperator) {
            this.verifyMethodHandleSignature(2, Boolean.TYPE, lessThanOrEqualOperator);
            this.lessThanOrEqualOperators.add(lessThanOrEqualOperator);
            return this;
        }

        public Builder addLessThanOrEqualOperators(Collection<OperatorMethodHandle> lessThanOrEqualOperators) {
            for (OperatorMethodHandle lessThanOrEqualOperator : lessThanOrEqualOperators) {
                this.verifyMethodHandleSignature(2, Boolean.TYPE, lessThanOrEqualOperator);
            }
            this.lessThanOrEqualOperators.addAll(lessThanOrEqualOperators);
            return this;
        }

        public Builder addLessThanOperator(OperatorMethodHandle lessThanOperator) {
            this.verifyMethodHandleSignature(2, Boolean.TYPE, lessThanOperator);
            this.lessThanOperators.add(lessThanOperator);
            return this;
        }

        public Builder addLessThanOperators(Collection<OperatorMethodHandle> lessThanOperators) {
            for (OperatorMethodHandle lessThanOperator : lessThanOperators) {
                this.verifyMethodHandleSignature(2, Boolean.TYPE, lessThanOperator);
            }
            this.lessThanOperators.addAll(lessThanOperators);
            return this;
        }

        public Builder addOperators(Class<?> operatorsClass, MethodHandles.Lookup lookup) {
            boolean addedOperator = false;
            for (Method method : operatorsClass.getDeclaredMethods()) {
                MethodHandle methodHandle;
                ScalarOperator scalarOperator = method.getAnnotation(ScalarOperator.class);
                if (scalarOperator == null) continue;
                OperatorType operatorType = scalarOperator.value();
                try {
                    methodHandle = lookup.unreflect(method);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                switch (operatorType) {
                    case READ_VALUE: {
                        this.addReadValueOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, this.typeJavaType), methodHandle));
                        break;
                    }
                    case EQUAL: {
                        this.addEqualOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Boolean.TYPE), methodHandle));
                        break;
                    }
                    case HASH_CODE: {
                        this.addHashCodeOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Long.TYPE), methodHandle));
                        break;
                    }
                    case XX_HASH_64: {
                        this.addXxHash64Operator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Long.TYPE), methodHandle));
                        break;
                    }
                    case IS_DISTINCT_FROM: {
                        this.addDistinctFromOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Boolean.TYPE), methodHandle));
                        break;
                    }
                    case INDETERMINATE: {
                        this.addIndeterminateOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Boolean.TYPE), methodHandle));
                        break;
                    }
                    case COMPARISON_UNORDERED_LAST: {
                        this.addComparisonUnorderedLastOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Long.TYPE), methodHandle));
                        break;
                    }
                    case COMPARISON_UNORDERED_FIRST: {
                        this.addComparisonUnorderedFirstOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Long.TYPE), methodHandle));
                        break;
                    }
                    case LESS_THAN: {
                        this.addLessThanOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Boolean.TYPE), methodHandle));
                        break;
                    }
                    case LESS_THAN_OR_EQUAL: {
                        this.addLessThanOrEqualOperator(new OperatorMethodHandle(Builder.parseInvocationConvention(operatorType, this.typeJavaType, method, Boolean.TYPE), methodHandle));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(operatorType + " operator is not supported: " + method);
                    }
                }
                addedOperator = true;
            }
            if (!addedOperator) {
                throw new IllegalArgumentException(operatorsClass + " does not contain any operators");
            }
            return this;
        }

        private void verifyMethodHandleSignature(int expectedArgumentCount, Class<?> returnJavaType, OperatorMethodHandle operatorMethodHandle) {
            MethodType methodType = operatorMethodHandle.getMethodHandle().type();
            InvocationConvention convention = operatorMethodHandle.getCallingConvention();
            Builder.checkArgument(convention.getArgumentConventions().size() == expectedArgumentCount, "Expected %s arguments, but got %s", expectedArgumentCount, convention.getArgumentConventions().size());
            Builder.checkArgument(methodType.parameterList().stream().noneMatch(ConnectorSession.class::equals), "Session is not supported in type operators", new Object[0]);
            int expectedParameterCount = convention.getArgumentConventions().stream().mapToInt(InvocationConvention.InvocationArgumentConvention::getParameterCount).sum();
            Builder.checkArgument((expectedParameterCount += convention.getReturnConvention().getParameterCount()) == methodType.parameterCount(), "Expected %s method parameters, but got %s", expectedParameterCount, methodType.parameterCount());
            int parameterIndex = 0;
            for (InvocationConvention.InvocationArgumentConvention argumentConvention : convention.getArgumentConventions()) {
                TypeDescriptor.OfField parameterType = methodType.parameterType(parameterIndex);
                Builder.checkArgument(!parameterType.equals(ConnectorSession.class), "Session is not supported in type operators", new Object[0]);
                switch (argumentConvention) {
                    case NEVER_NULL: {
                        Builder.checkArgument(((Class)parameterType).isAssignableFrom(this.typeJavaType), "Expected argument type to be %s, but is %s", this.typeJavaType, parameterType);
                        break;
                    }
                    case NULL_FLAG: {
                        Builder.checkArgument(((Class)parameterType).isAssignableFrom(this.typeJavaType), "Expected argument type to be %s, but is %s", this.typeJavaType, parameterType);
                        Builder.checkArgument(methodType.parameterType(parameterIndex + 1).equals(Boolean.TYPE), "Expected null flag parameter to be followed by a boolean parameter", new Object[0]);
                        break;
                    }
                    case BOXED_NULLABLE: {
                        Builder.checkArgument(((Class)parameterType).isAssignableFrom(Builder.wrap(this.typeJavaType)), "Expected argument type to be %s, but is %s", Builder.wrap(this.typeJavaType), parameterType);
                        break;
                    }
                    case BLOCK_POSITION_NOT_NULL: 
                    case BLOCK_POSITION: {
                        Builder.checkArgument(parameterType.equals(Block.class) && methodType.parameterType(parameterIndex + 1).equals(Integer.TYPE), "Expected BLOCK_POSITION argument have parameters Block and int", new Object[0]);
                        break;
                    }
                    case FLAT: {
                        Builder.checkArgument(parameterType.equals(byte[].class) && methodType.parameterType(parameterIndex + 1).equals(Integer.TYPE) && methodType.parameterType(parameterIndex + 2).equals(byte[].class), "Expected FLAT argument have parameters byte[], int, and byte[]", new Object[0]);
                        break;
                    }
                    case FUNCTION: {
                        throw new IllegalArgumentException("Function argument convention is not supported in type operators");
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown argument convention: " + argumentConvention);
                    }
                }
                parameterIndex += argumentConvention.getParameterCount();
            }
            InvocationConvention.InvocationReturnConvention returnConvention = convention.getReturnConvention();
            switch (returnConvention) {
                case FAIL_ON_NULL: {
                    Builder.checkArgument(methodType.returnType().equals(returnJavaType), "Expected return type to be %s, but is %s", returnJavaType, methodType.returnType());
                    break;
                }
                case NULLABLE_RETURN: {
                    Builder.checkArgument(methodType.returnType().equals(Builder.wrap(returnJavaType)), "Expected return type to be %s, but is %s", returnJavaType, Builder.wrap(methodType.returnType()));
                    break;
                }
                case BLOCK_BUILDER: {
                    Builder.checkArgument(methodType.lastParameterType().equals(BlockBuilder.class), "Expected last argument type to be BlockBuilder, but is %s", methodType.returnType());
                    Builder.checkArgument(methodType.returnType().equals(Void.TYPE), "Expected return type to be void, but is %s", methodType.returnType());
                    break;
                }
                case FLAT_RETURN: {
                    List<Class<?>> parameters = methodType.parameterList();
                    parameters = parameters.subList(parameters.size() - 4, parameters.size());
                    Builder.checkArgument(parameters.equals(List.of(byte[].class, Integer.TYPE, byte[].class, Integer.TYPE)), "Expected last argument types to be (byte[], int, byte[], int), but is %s", methodType);
                    Builder.checkArgument(methodType.returnType().equals(Void.TYPE), "Expected return type to be void, but is %s", methodType.returnType());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown return convention: " + returnConvention);
                }
            }
        }

        private static InvocationConvention parseInvocationConvention(OperatorType operatorType, Class<?> typeJavaType, Method method, Class<?> expectedReturnType) {
            InvocationConvention.InvocationReturnConvention returnConvention = Builder.getReturnConvention(expectedReturnType, operatorType, method);
            List<Class<?>> parameterTypes = List.of(method.getParameterTypes());
            List<Annotation[]> parameterAnnotations = List.of(method.getParameterAnnotations());
            InvocationConvention.InvocationArgumentConvention leftArgumentConvention = Builder.extractNextArgumentConvention(typeJavaType, parameterTypes = parameterTypes.subList(0, parameterTypes.size() - returnConvention.getParameterCount()), parameterAnnotations = parameterAnnotations.subList(0, parameterAnnotations.size() - returnConvention.getParameterCount()), operatorType, method);
            if (leftArgumentConvention.getParameterCount() == parameterTypes.size()) {
                return InvocationConvention.simpleConvention(returnConvention, leftArgumentConvention);
            }
            InvocationConvention.InvocationArgumentConvention rightArgumentConvention = Builder.extractNextArgumentConvention(typeJavaType, parameterTypes.subList(leftArgumentConvention.getParameterCount(), parameterTypes.size()), parameterAnnotations.subList(leftArgumentConvention.getParameterCount(), parameterTypes.size()), operatorType, method);
            Builder.checkArgument(leftArgumentConvention.getParameterCount() + rightArgumentConvention.getParameterCount() == parameterTypes.size(), "Unexpected parameters for %s operator: %s", new Object[]{operatorType, method});
            return InvocationConvention.simpleConvention(returnConvention, leftArgumentConvention, rightArgumentConvention);
        }

        private static boolean isAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> annotationType) {
            return Arrays.stream(annotations).anyMatch(annotationType::isInstance);
        }

        private static InvocationConvention.InvocationReturnConvention getReturnConvention(Class<?> expectedReturnType, OperatorType operatorType, Method method) {
            InvocationConvention.InvocationReturnConvention returnConvention;
            if (!method.isAnnotationPresent(SqlNullable.class) && method.getReturnType().equals(expectedReturnType)) {
                returnConvention = InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL;
            } else if (method.isAnnotationPresent(SqlNullable.class) && method.getReturnType().equals(Builder.wrap(expectedReturnType))) {
                returnConvention = InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN;
            } else if (method.getReturnType().equals(Void.TYPE) && method.getParameterCount() >= 1 && method.getParameterTypes()[method.getParameterCount() - 1].equals(BlockBuilder.class)) {
                returnConvention = InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER;
            } else if (method.getReturnType().equals(Void.TYPE) && method.getParameterCount() >= 4 && method.getParameterTypes()[method.getParameterCount() - 4].equals(byte[].class) && method.getParameterTypes()[method.getParameterCount() - 3].equals(Integer.TYPE) && method.getParameterTypes()[method.getParameterCount() - 2].equals(byte[].class) && method.getParameterTypes()[method.getParameterCount() - 1].equals(Integer.TYPE)) {
                returnConvention = InvocationConvention.InvocationReturnConvention.FLAT_RETURN;
            } else {
                throw new IllegalArgumentException(String.format("Expected %s operator to return %s: %s", new Object[]{operatorType, expectedReturnType, method}));
            }
            return returnConvention;
        }

        private static InvocationConvention.InvocationArgumentConvention extractNextArgumentConvention(Class<?> typeJavaType, List<Class<?>> parameterTypes, List<Annotation[]> parameterAnnotations, OperatorType operatorType, Method method) {
            if (Builder.isAnnotationPresent(parameterAnnotations.get(0), BlockPosition.class)) {
                if (parameterTypes.size() > 1 && Builder.isAnnotationPresent(parameterAnnotations.get(1), BlockIndex.class) && parameterTypes.get(0).equals(Block.class) && parameterTypes.get(1).equals(Integer.TYPE)) {
                    return Builder.isAnnotationPresent(parameterAnnotations.get(0), SqlNullable.class) ? InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION : InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL;
                }
            } else if (Builder.isAnnotationPresent(parameterAnnotations.get(0), SqlNullable.class)) {
                if (parameterTypes.get(0).equals(Builder.wrap(typeJavaType))) {
                    return InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE;
                }
            } else if (Builder.isAnnotationPresent(parameterAnnotations.get(0), FlatFixed.class)) {
                if (parameterTypes.size() > 2 && Builder.isAnnotationPresent(parameterAnnotations.get(1), FlatFixedOffset.class) && Builder.isAnnotationPresent(parameterAnnotations.get(2), FlatVariableWidth.class) && parameterTypes.get(0).equals(byte[].class) && parameterTypes.get(1).equals(Integer.TYPE) && parameterTypes.get(2).equals(byte[].class)) {
                    return InvocationConvention.InvocationArgumentConvention.FLAT;
                }
            } else if (parameterTypes.size() > 1 && Builder.isAnnotationPresent(parameterAnnotations.get(1), IsNull.class)) {
                if (parameterTypes.size() > 1 && parameterTypes.get(0).equals(typeJavaType) && parameterTypes.get(1).equals(Boolean.TYPE)) {
                    return InvocationConvention.InvocationArgumentConvention.NULL_FLAG;
                }
            } else if (parameterTypes.get(0).equals(typeJavaType)) {
                return InvocationConvention.InvocationArgumentConvention.NEVER_NULL;
            }
            throw new IllegalArgumentException(String.format("Unexpected parameters for %s operator: %s", new Object[]{operatorType, method}));
        }

        private static void checkArgument(boolean test, String message, Object ... arguments) {
            if (!test) {
                throw new IllegalArgumentException(String.format(message, arguments));
            }
        }

        private static Class<?> wrap(Class<?> type) {
            return MethodType.methodType(type).wrap().returnType();
        }

        public TypeOperatorDeclaration build() {
            if (this.equalOperators.isEmpty()) {
                if (!this.hashCodeOperators.isEmpty()) {
                    throw new IllegalStateException("Hash code operators can not be supplied when equal operators are not supplied");
                }
                if (!this.xxHash64Operators.isEmpty()) {
                    throw new IllegalStateException("xxHash64 operators can not be supplied when equal operators are not supplied");
                }
            } else if (this.xxHash64Operators.isEmpty()) {
                throw new IllegalStateException("xxHash64 operators must be supplied when equal operators are supplied");
            }
            if (this.comparisonUnorderedLastOperators.isEmpty() && this.comparisonUnorderedFirstOperators.isEmpty()) {
                if (!this.lessThanOperators.isEmpty()) {
                    throw new IllegalStateException("Less-than-operators can not be supplied when comparison operators are not supplied");
                }
                if (!this.lessThanOrEqualOperators.isEmpty()) {
                    throw new IllegalStateException("Less-than-or-equals operators can not be supplied when comparison operators are not supplied");
                }
            }
            return new TypeOperatorDeclaration(this.readValueOperators, this.equalOperators, this.hashCodeOperators, this.xxHash64Operators, this.distinctFromOperators, this.indeterminateOperators, this.comparisonUnorderedLastOperators, this.comparisonUnorderedFirstOperators, this.lessThanOperators, this.lessThanOrEqualOperators);
        }
    }
}

